/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="Avoid MongoDB's `$text` filter operator, as it can trigger heavy queries and even cause the server to run out of memory", link="https://error-prone.picnic.tech/bugpatterns/MongoDBTextFilterUsage", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Performance"})
@AutoService(value={BugChecker.class})
public final class MongoDBTextFilterUsage
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> MONGO_FILTERS_TEXT_METHOD = MethodMatchers.staticMethod().onClass("com.mongodb.client.model.Filters").named("text");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return MONGO_FILTERS_TEXT_METHOD.matches((Tree)tree, state) ? this.describeMatch(tree) : Description.NO_MATCH;
    }
}

