/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.BugCheckerRefactoringTestHelper;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.refaster.Refaster;
import com.sun.tools.javac.util.Constants;
import com.sun.tools.javac.util.Convert;
import javax.lang.model.element.Name;

final class BugCheckerRules {
    private BugCheckerRules() {
    }

    static final class NameContentEquals {
        NameContentEquals() {
        }

        boolean before(Name name, CharSequence string) {
            return name.toString().equals(string.toString());
        }

        boolean before(Name name, String string) {
            return name.toString().equals(string);
        }

        boolean after(Name name, CharSequence string) {
            return name.contentEquals(string);
        }
    }

    static final class ConstantsFormat {
        ConstantsFormat() {
        }

        String before(String value) {
            return String.format("\"%s\"", Convert.quote(value));
        }

        String after(String value) {
            return Constants.format(value);
        }
    }

    static final class BugCheckerRefactoringTestHelperAddInputLinesExpectUnchanged {
        BugCheckerRefactoringTestHelperAddInputLinesExpectUnchanged() {
        }

        BugCheckerRefactoringTestHelper before(BugCheckerRefactoringTestHelper helper, String path, String source) {
            return helper.addInputLines(path, new String[]{source}).addOutputLines(path, new String[]{source});
        }

        BugCheckerRefactoringTestHelper after(BugCheckerRefactoringTestHelper helper, String path, String source) {
            return helper.addInputLines(path, new String[]{source}).expectUnchanged();
        }
    }

    static final class BugCheckerRefactoringTestHelperIdentity {
        BugCheckerRefactoringTestHelperIdentity() {
        }

        BugCheckerRefactoringTestHelper before(BugCheckerRefactoringTestHelper helper) {
            return (BugCheckerRefactoringTestHelper)Refaster.anyOf((Object[])new BugCheckerRefactoringTestHelper[]{helper.setFixChooser((BugCheckerRefactoringTestHelper.FixChooser)BugCheckerRefactoringTestHelper.FixChoosers.FIRST), helper.setImportOrder("static-first")});
        }

        @CanIgnoreReturnValue
        BugCheckerRefactoringTestHelper after(BugCheckerRefactoringTestHelper helper) {
            return helper;
        }
    }
}

