/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.errorprone.refaster.Refaster;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

final class ImmutableMapRules {
    private ImmutableMapRules() {
    }

    static abstract class ImmutableMapCopyOfMapsFilterValues<K, V> {
        ImmutableMapCopyOfMapsFilterValues() {
        }

        abstract boolean valueFilter(V var1);

        ImmutableMap<K, V> before(ImmutableMap<K, V> map) {
            return (ImmutableMap)map.entrySet().stream().filter(e -> this.valueFilter(e.getValue())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        ImmutableMap<K, V> after(ImmutableMap<K, V> map) {
            return ImmutableMap.copyOf((Map)Maps.filterValues(map, v -> this.valueFilter(v)));
        }
    }

    static abstract class ImmutableMapCopyOfMapsFilterKeys<K, V> {
        ImmutableMapCopyOfMapsFilterKeys() {
        }

        abstract boolean keyFilter(K var1);

        ImmutableMap<K, V> before(ImmutableMap<K, V> map) {
            return (ImmutableMap)map.entrySet().stream().filter(e -> this.keyFilter(e.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        ImmutableMap<K, V> after(ImmutableMap<K, V> map) {
            return ImmutableMap.copyOf((Map)Maps.filterKeys(map, k -> this.keyFilter(k)));
        }
    }

    static final class ImmutableMapOf5<K, V> {
        ImmutableMapOf5() {
        }

        Map<K, V> before(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
            return Map.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
        }

        ImmutableMap<K, V> after(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
            return ImmutableMap.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
        }
    }

    static final class ImmutableMapOf4<K, V> {
        ImmutableMapOf4() {
        }

        Map<K, V> before(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
            return Map.of(k1, v1, k2, v2, k3, v3, k4, v4);
        }

        ImmutableMap<K, V> after(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
            return ImmutableMap.of(k1, v1, k2, v2, k3, v3, k4, v4);
        }
    }

    static final class ImmutableMapOf3<K, V> {
        ImmutableMapOf3() {
        }

        Map<K, V> before(K k1, V v1, K k2, V v2, K k3, V v3) {
            return Map.of(k1, v1, k2, v2, k3, v3);
        }

        ImmutableMap<K, V> after(K k1, V v1, K k2, V v2, K k3, V v3) {
            return ImmutableMap.of(k1, v1, k2, v2, k3, v3);
        }
    }

    static final class ImmutableMapOf2<K, V> {
        ImmutableMapOf2() {
        }

        Map<K, V> before(K k1, V v1, K k2, V v2) {
            return Map.of(k1, v1, k2, v2);
        }

        ImmutableMap<K, V> after(K k1, V v1, K k2, V v2) {
            return ImmutableMap.of(k1, v1, k2, v2);
        }
    }

    static final class ImmutableMapOf1<K, V> {
        ImmutableMapOf1() {
        }

        Map<K, V> before(K k1, V v1) {
            return (Map)Refaster.anyOf((Object[])new Map[]{ImmutableMap.builder().put(k1, v1).build(), Collections.singletonMap(k1, v1), Map.of(k1, v1)});
        }

        ImmutableMap<K, V> after(K k1, V v1) {
            return ImmutableMap.of(k1, v1);
        }
    }

    static final class ImmutableMapOf<K, V> {
        ImmutableMapOf() {
        }

        Map<K, V> before() {
            return (Map)Refaster.anyOf((Object[])new Map[]{ImmutableMap.builder().build(), Collections.emptyMap(), Map.of()});
        }

        ImmutableMap<K, V> after() {
            return ImmutableMap.of();
        }
    }

    static abstract class TransformMapValuesToImmutableMap<K, V1, V2> {
        TransformMapValuesToImmutableMap() {
        }

        abstract V2 valueTransformation(V1 var1);

        ImmutableMap<K, V2> before(Map<K, V1> map) {
            return (ImmutableMap)Refaster.anyOf((Object[])new ImmutableMap[]{(ImmutableMap)map.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> this.valueTransformation(e.getValue()))), Maps.toMap(map.keySet(), key -> this.valueTransformation(map.get(key)))});
        }

        ImmutableMap<K, V2> after(Map<K, V1> map) {
            return ImmutableMap.copyOf((Map)Maps.transformValues(map, v -> this.valueTransformation(v)));
        }
    }

    static final class IndexIterableToImmutableMap<K, V> {
        IndexIterableToImmutableMap() {
        }

        ImmutableMap<K, V> before(Iterator<V> iterable, java.util.function.Function<? super V, ? extends K> keyFunction, java.util.function.Function<? super V, ? extends V> valueFunction) {
            return (ImmutableMap)Streams.stream(iterable).collect(ImmutableMap.toImmutableMap(keyFunction, valueFunction));
        }

        ImmutableMap<K, V> before(Iterable<V> iterable, java.util.function.Function<? super V, ? extends K> keyFunction, java.util.function.Function<? super V, ? extends V> valueFunction) {
            return (ImmutableMap)Streams.stream(iterable).collect(ImmutableMap.toImmutableMap(keyFunction, valueFunction));
        }

        ImmutableMap<K, V> before(Collection<V> iterable, java.util.function.Function<? super V, ? extends K> keyFunction, java.util.function.Function<? super V, ? extends V> valueFunction) {
            return (ImmutableMap)iterable.stream().collect(ImmutableMap.toImmutableMap(keyFunction, valueFunction));
        }

        ImmutableMap<K, V> after(Iterable<V> iterable, Function<? super V, K> keyFunction) {
            return Maps.uniqueIndex(iterable, keyFunction);
        }
    }

    static abstract class StreamOfMapEntriesToImmutableMap<E, K, V> {
        StreamOfMapEntriesToImmutableMap() {
        }

        abstract K keyFunction(E var1);

        abstract V valueFunction(E var1);

        ImmutableMap<K, V> before(Stream<E> stream) {
            return (ImmutableMap)stream.map(e -> Map.entry(this.keyFunction(e), this.valueFunction(e))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        ImmutableMap<K, V> after(Stream<E> stream) {
            return (ImmutableMap)stream.collect(ImmutableMap.toImmutableMap(e -> this.keyFunction(e), e -> this.valueFunction(e)));
        }
    }

    static final class EntryIterableToImmutableMap<K, V> {
        EntryIterableToImmutableMap() {
        }

        ImmutableMap<K, V> before(Map<? extends K, ? extends V> iterable) {
            return (ImmutableMap)Refaster.anyOf((Object[])new ImmutableMap[]{ImmutableMap.copyOf(iterable.entrySet()), ImmutableMap.builder().putAll(iterable).build()});
        }

        ImmutableMap<K, V> before(Iterable<? extends Map.Entry<? extends K, ? extends V>> iterable) {
            return (ImmutableMap)Refaster.anyOf((Object[])new ImmutableMap[]{ImmutableMap.builder().putAll(iterable).build(), (ImmutableMap)Streams.stream(iterable).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue))});
        }

        ImmutableMap<K, V> before(Collection<? extends Map.Entry<? extends K, ? extends V>> iterable) {
            return (ImmutableMap)iterable.stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        ImmutableMap<K, V> after(Iterable<? extends Map.Entry<? extends K, ? extends V>> iterable) {
            return ImmutableMap.copyOf(iterable);
        }
    }

    static final class IterableToImmutableMap<K, V> {
        IterableToImmutableMap() {
        }

        ImmutableMap<K, V> before(Iterator<K> iterable, java.util.function.Function<? super K, ? extends V> valueFunction, java.util.function.Function<? super K, ? extends K> keyFunction) {
            return (ImmutableMap)Streams.stream(iterable).collect(ImmutableMap.toImmutableMap(keyFunction, valueFunction));
        }

        ImmutableMap<K, V> before(Iterable<K> iterable, java.util.function.Function<? super K, ? extends V> valueFunction, java.util.function.Function<? super K, ? extends K> keyFunction) {
            return (ImmutableMap)Streams.stream(iterable).collect(ImmutableMap.toImmutableMap(keyFunction, valueFunction));
        }

        ImmutableMap<K, V> before(Collection<K> iterable, java.util.function.Function<? super K, ? extends V> valueFunction, java.util.function.Function<? super K, ? extends K> keyFunction) {
            return (ImmutableMap)iterable.stream().collect(ImmutableMap.toImmutableMap(keyFunction, valueFunction));
        }

        ImmutableMap<K, V> before(Set<K> iterable, Function<? super K, V> valueFunction) {
            return ImmutableMap.copyOf((Map)Maps.asMap(iterable, valueFunction));
        }

        ImmutableMap<K, V> after(Iterable<K> iterable, Function<? super K, V> valueFunction) {
            return Maps.toMap(iterable, valueFunction);
        }
    }

    static final class EntryToImmutableMap<K, V> {
        EntryToImmutableMap() {
        }

        ImmutableMap<K, V> before(Map.Entry<? extends K, ? extends V> entry) {
            return (ImmutableMap)Refaster.anyOf((Object[])new ImmutableMap[]{ImmutableMap.builder().put(entry).build(), (ImmutableMap)Stream.of(entry).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue))});
        }

        ImmutableMap<K, V> after(Map.Entry<? extends K, ? extends V> entry) {
            return ImmutableMap.of(entry.getKey(), entry.getValue());
        }
    }

    static final class ImmutableMapBuilder<K, V> {
        ImmutableMapBuilder() {
        }

        ImmutableMap.Builder<K, V> before() {
            return new ImmutableMap.Builder();
        }

        ImmutableMap.Builder<K, V> after() {
            return ImmutableMap.builder();
        }
    }
}

