/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.refaster.Refaster;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;

final class AssertJLongRules {
    private AssertJLongRules() {
    }

    static final class AbstractLongAssertIsOne {
        AbstractLongAssertIsOne() {
        }

        AbstractLongAssert<?> before(AbstractLongAssert<?> longAssert) {
            return longAssert.isOne();
        }

        AbstractLongAssert<?> after(AbstractLongAssert<?> longAssert) {
            return longAssert.isEqualTo(1L);
        }
    }

    static final class AbstractLongAssertIsNotZero {
        AbstractLongAssertIsNotZero() {
        }

        AbstractLongAssert<?> before(AbstractLongAssert<?> longAssert) {
            return longAssert.isNotZero();
        }

        AbstractLongAssert<?> after(AbstractLongAssert<?> longAssert) {
            return longAssert.isNotEqualTo(0L);
        }
    }

    static final class AbstractLongAssertIsZero {
        AbstractLongAssertIsZero() {
        }

        AbstractLongAssert<?> before(AbstractLongAssert<?> longAssert) {
            return longAssert.isZero();
        }

        AbstractLongAssert<?> after(AbstractLongAssert<?> longAssert) {
            return longAssert.isEqualTo(0L);
        }
    }

    static final class AbstractLongAssertIsNotEqualTo {
        AbstractLongAssertIsNotEqualTo() {
        }

        AbstractLongAssert<?> before(AbstractLongAssert<?> longAssert, long n) {
            return (AbstractLongAssert)Refaster.anyOf((Object[])new AbstractLongAssert[]{longAssert.isNotCloseTo(n, Offset.offset((Number)0L)), longAssert.isNotCloseTo(n, Percentage.withPercentage((double)0.0))});
        }

        AbstractLongAssert<?> after(AbstractLongAssert<?> longAssert, long n) {
            return longAssert.isNotEqualTo(n);
        }
    }

    static final class AbstractLongAssertIsEqualTo {
        AbstractLongAssertIsEqualTo() {
        }

        AbstractLongAssert<?> before(AbstractLongAssert<?> longAssert, long n) {
            return (AbstractLongAssert)Refaster.anyOf((Object[])new AbstractLongAssert[]{longAssert.isCloseTo(n, Offset.offset((Number)0L)), longAssert.isCloseTo(n, Percentage.withPercentage((double)0.0))});
        }

        AbstractLongAssert<?> after(AbstractLongAssert<?> longAssert, long n) {
            return longAssert.isEqualTo(n);
        }
    }
}

