/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.refaster.Refaster;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractPathAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;

final class AssertJPathRules {
    private AssertJPathRules() {
    }

    static final class AssertThatHasExtension {
        AssertThatHasExtension() {
        }

        AbstractStringAssert<?> before(Path actual, String expectedExtension) {
            return (AbstractStringAssert)Assertions.assertThat((String)((String)Refaster.anyOf((Object[])new String[]{actual.getFileName().toString(), actual.toString()}))).endsWith((CharSequence)Refaster.anyOf((Object[])new String[]{"." + expectedExtension, "." + expectedExtension}));
        }

        AbstractPathAssert<?> after(Path actual, String expectedExtension) {
            return Assertions.assertThat((Path)actual).hasExtension(expectedExtension);
        }
    }

    static final class AssertThatEndsWithRaw {
        AssertThatEndsWithRaw() {
        }

        AbstractBooleanAssert<?> before(Path actual, Path other) {
            return Assertions.assertThat((boolean)actual.endsWith(other)).isTrue();
        }

        AbstractPathAssert<?> after(Path actual, Path other) {
            return Assertions.assertThat((Path)actual).endsWithRaw(other);
        }
    }

    static final class AssertThatStartsWithRaw {
        AssertThatStartsWithRaw() {
        }

        AbstractBooleanAssert<?> before(Path actual, Path other) {
            return Assertions.assertThat((boolean)actual.startsWith(other)).isTrue();
        }

        AbstractPathAssert<?> after(Path actual, Path other) {
            return Assertions.assertThat((Path)actual).startsWithRaw(other);
        }
    }

    static final class AssertThatHasNoParent {
        AssertThatHasNoParent() {
        }

        void before(Path actual) {
            Assertions.assertThat((Path)actual.getParent()).isNull();
        }

        void after(Path actual) {
            Assertions.assertThat((Path)actual).hasNoParent();
        }
    }

    static final class AssertThatHasParentRaw {
        AssertThatHasParentRaw() {
        }

        AbstractPathAssert<?> before(Path actual, Path expected) {
            return (AbstractPathAssert)Assertions.assertThat((Path)actual.getParent()).isEqualTo((Object)expected);
        }

        AbstractPathAssert<?> after(Path actual, Path expected) {
            return Assertions.assertThat((Path)actual).hasParentRaw(expected);
        }
    }

    static final class AssertThatHasFileName {
        AssertThatHasFileName() {
        }

        AbstractPathAssert<?> before(Path actual, String fileName) {
            return (AbstractPathAssert)Assertions.assertThat((Path)actual.getFileName()).hasToString(fileName);
        }

        AbstractPathAssert<?> after(Path actual, String fileName) {
            return Assertions.assertThat((Path)actual).hasFileName(fileName);
        }
    }

    static final class AssertThatIsExecutable {
        AssertThatIsExecutable() {
        }

        AbstractBooleanAssert<?> before(Path actual) {
            return Assertions.assertThat((boolean)Files.isExecutable(actual)).isTrue();
        }

        AbstractPathAssert<?> after(Path actual) {
            return Assertions.assertThat((Path)actual).isExecutable();
        }
    }

    static final class AssertThatIsWritable {
        AssertThatIsWritable() {
        }

        AbstractBooleanAssert<?> before(Path actual) {
            return Assertions.assertThat((boolean)Files.isWritable(actual)).isTrue();
        }

        AbstractPathAssert<?> after(Path actual) {
            return Assertions.assertThat((Path)actual).isWritable();
        }
    }

    static final class AssertThatIsReadable {
        AssertThatIsReadable() {
        }

        AbstractBooleanAssert<?> before(Path actual) {
            return Assertions.assertThat((boolean)Files.isReadable(actual)).isTrue();
        }

        AbstractPathAssert<?> after(Path actual) {
            return Assertions.assertThat((Path)actual).isReadable();
        }
    }

    static final class AssertThatIsRelative {
        AssertThatIsRelative() {
        }

        AbstractBooleanAssert<?> before(Path actual) {
            return Assertions.assertThat((boolean)actual.isAbsolute()).isFalse();
        }

        AbstractPathAssert<?> after(Path actual) {
            return Assertions.assertThat((Path)actual).isRelative();
        }
    }

    static final class AssertThatIsAbsolute {
        AssertThatIsAbsolute() {
        }

        AbstractBooleanAssert<?> before(Path actual) {
            return Assertions.assertThat((boolean)actual.isAbsolute()).isTrue();
        }

        AbstractPathAssert<?> after(Path actual) {
            return Assertions.assertThat((Path)actual).isAbsolute();
        }
    }

    static final class AssertThatIsSymbolicLink {
        AssertThatIsSymbolicLink() {
        }

        AbstractBooleanAssert<?> before(Path actual) {
            return Assertions.assertThat((boolean)Files.isSymbolicLink(actual)).isTrue();
        }

        AbstractPathAssert<?> after(Path actual) {
            return Assertions.assertThat((Path)actual).isSymbolicLink();
        }
    }

    static final class AssertThatIsDirectory {
        AssertThatIsDirectory() {
        }

        AbstractBooleanAssert<?> before(Path actual) {
            return Assertions.assertThat((boolean)Files.isDirectory(actual, new LinkOption[0])).isTrue();
        }

        AbstractPathAssert<?> after(Path actual) {
            return Assertions.assertThat((Path)actual).isDirectory();
        }
    }

    static final class AssertThatIsRegularFile {
        AssertThatIsRegularFile() {
        }

        AbstractBooleanAssert<?> before(Path actual) {
            return Assertions.assertThat((boolean)Files.isRegularFile(actual, new LinkOption[0])).isTrue();
        }

        AbstractPathAssert<?> after(Path actual) {
            return Assertions.assertThat((Path)actual).isRegularFile();
        }
    }

    static final class AssertThatDoesNotExist {
        AssertThatDoesNotExist() {
        }

        AbstractBooleanAssert<?> before(Path actual) {
            return Assertions.assertThat((boolean)Files.exists(actual, new LinkOption[0])).isFalse();
        }

        AbstractPathAssert<?> after(Path actual) {
            return Assertions.assertThat((Path)actual).doesNotExist();
        }
    }

    static final class AssertThatExists {
        AssertThatExists() {
        }

        AbstractBooleanAssert<?> before(Path actual) {
            return Assertions.assertThat((boolean)Files.exists(actual, new LinkOption[0])).isTrue();
        }

        AbstractPathAssert<?> after(Path actual) {
            return Assertions.assertThat((Path)actual).exists();
        }
    }
}

