/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Streams;
import com.google.errorprone.refaster.Refaster;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Stream;

final class ImmutableSortedMapRules {
    private ImmutableSortedMapRules() {
    }

    static final class IterableToImmutableSortedMap<K extends Comparable<? super K>, V> {
        IterableToImmutableSortedMap() {
        }

        ImmutableMap<K, V> before(Map<? extends K, ? extends V> iterable) {
            return (ImmutableMap)Refaster.anyOf((Object[])new ImmutableSortedMap[]{ImmutableSortedMap.copyOf(iterable, Comparator.naturalOrder()), ImmutableSortedMap.copyOf(iterable.entrySet()), ImmutableSortedMap.naturalOrder().putAll(iterable).buildOrThrow()});
        }

        ImmutableSortedMap<K, V> before(Iterable<? extends Map.Entry<? extends K, ? extends V>> iterable) {
            return (ImmutableSortedMap)Refaster.anyOf((Object[])new ImmutableSortedMap[]{ImmutableSortedMap.copyOf(iterable, Comparator.naturalOrder()), ImmutableSortedMap.naturalOrder().putAll(iterable).buildOrThrow(), (ImmutableSortedMap)Streams.stream(iterable).collect(ImmutableSortedMap.toImmutableSortedMap(Comparator.naturalOrder(), Map.Entry::getKey, Map.Entry::getValue))});
        }

        ImmutableSortedMap<K, V> before(Collection<? extends Map.Entry<? extends K, ? extends V>> iterable) {
            return (ImmutableSortedMap)iterable.stream().collect(ImmutableSortedMap.toImmutableSortedMap(Comparator.naturalOrder(), Map.Entry::getKey, Map.Entry::getValue));
        }

        ImmutableSortedMap<K, V> after(Iterable<? extends Map.Entry<? extends K, ? extends V>> iterable) {
            return ImmutableSortedMap.copyOf(iterable);
        }
    }

    static final class EntryToImmutableSortedMap<K extends Comparable<? super K>, V> {
        EntryToImmutableSortedMap() {
        }

        ImmutableSortedMap<K, V> before(Map.Entry<? extends K, ? extends V> entry) {
            return (ImmutableSortedMap)Refaster.anyOf((Object[])new ImmutableSortedMap[]{ImmutableSortedMap.naturalOrder().put(entry).buildOrThrow(), (ImmutableSortedMap)Stream.of(entry).collect(ImmutableSortedMap.toImmutableSortedMap(Comparator.naturalOrder(), Map.Entry::getKey, Map.Entry::getValue))});
        }

        ImmutableSortedMap<K, V> after(Map.Entry<? extends K, ? extends V> entry) {
            return ImmutableSortedMap.of((Comparable)((Comparable)entry.getKey()), entry.getValue());
        }
    }

    static final class PairToImmutableSortedMap<K extends Comparable<? super K>, V> {
        PairToImmutableSortedMap() {
        }

        ImmutableSortedMap<K, V> before(K key, V value) {
            return ImmutableSortedMap.naturalOrder().put(key, value).buildOrThrow();
        }

        ImmutableSortedMap<K, V> after(K key, V value) {
            return ImmutableSortedMap.of(key, value);
        }
    }

    static final class EmptyImmutableSortedMap<K extends Comparable<? super K>, V> {
        EmptyImmutableSortedMap() {
        }

        ImmutableSortedMap<K, V> before() {
            return ImmutableSortedMap.naturalOrder().buildOrThrow();
        }

        ImmutableSortedMap<K, V> after() {
            return ImmutableSortedMap.of();
        }
    }

    static final class ImmutableSortedMapReverseOrderBuilder<K extends Comparable<? super K>, V> {
        ImmutableSortedMapReverseOrderBuilder() {
        }

        ImmutableSortedMap.Builder<K, V> before() {
            return ImmutableSortedMap.orderedBy(Comparator.reverseOrder());
        }

        ImmutableSortedMap.Builder<K, V> after() {
            return ImmutableSortedMap.reverseOrder();
        }
    }

    static final class ImmutableSortedMapNaturalOrderBuilder<K extends Comparable<? super K>, V> {
        ImmutableSortedMapNaturalOrderBuilder() {
        }

        ImmutableSortedMap.Builder<K, V> before() {
            return ImmutableSortedMap.orderedBy(Comparator.naturalOrder());
        }

        ImmutableSortedMap.Builder<K, V> after() {
            return ImmutableSortedMap.naturalOrder();
        }
    }

    static final class ImmutableSortedMapBuilder<K, V> {
        ImmutableSortedMapBuilder() {
        }

        ImmutableSortedMap.Builder<K, V> before(Comparator<K> cmp) {
            return new ImmutableSortedMap.Builder(cmp);
        }

        ImmutableSortedMap.Builder<K, V> after(Comparator<K> cmp) {
            return ImmutableSortedMap.orderedBy(cmp);
        }
    }
}

