/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.base.Predicates;
import java.util.function.Predicate;
import java.util.regex.Pattern;

final class PatternRules {
    private PatternRules() {
    }

    static final class PatternCompileAsPredicate {
        PatternCompileAsPredicate() {
        }

        Predicate<CharSequence> before(String pattern) {
            return Predicates.containsPattern((String)pattern);
        }

        Predicate<String> after(String pattern) {
            return Pattern.compile(pattern).asPredicate();
        }
    }

    static final class PatternAsPredicate {
        PatternAsPredicate() {
        }

        Predicate<CharSequence> before(Pattern pattern) {
            return Predicates.contains((Pattern)pattern);
        }

        Predicate<String> after(Pattern pattern) {
            return pattern.asPredicate();
        }
    }
}

