/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class MockitoRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`MockitoRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to Mockito expressions and statements.\n[Source](https://error-prone.picnic.tech/refasterrules/MockitoRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new NeverRecipe(), new VerifyOnceRecipe(), new InvocationOnMockGetArgumentsRecipe()});
    }

    @NullMarked
    public static class NeverRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `MockitoRules.Never`";
        }

        public String getDescription() {
            return "Prefer `Mockito#never()`} over explicitly specifying that the associated invocation must happen precisely zero times.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.mockito.Mockito.times(0)").bindType("org.mockito.verification.VerificationMode").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"mockito-core-5"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.mockito.Mockito");
                        this.maybeRemoveImport("org.mockito.Mockito.times");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.mockito.Mockito.never()").bindType("org.mockito.verification.VerificationMode").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"mockito-core-5"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.mockito.verification.VerificationMode", Boolean.valueOf(true)), new UsesMethod("org.mockito.Mockito times(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class VerifyOnceRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `MockitoRules.VerifyOnce`";
        }

        public String getDescription() {
            return "Prefer `Mockito#verify(Object)` over explicitly specifying that the associated invocation must happen precisely once; this is the default behavior.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.mockito.Mockito.verify(#{mock:any(T)}, org.mockito.Mockito.times(1))").bindType("T").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"mockito-core-5"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.mockito.Mockito");
                        this.maybeRemoveImport("org.mockito.Mockito.times");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.mockito.Mockito.verify(#{mock:any(T)})").bindType("T").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"mockito-core-5"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.mockito.Mockito times(..)", true), new UsesMethod("org.mockito.Mockito verify(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class InvocationOnMockGetArgumentsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `MockitoRules.InvocationOnMockGetArguments`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class InvocationOnMockGetArguments {\n    \n    @BeforeTemplate\n    Object before(InvocationOnMock invocation, int i) {\n        return invocation.getArguments()[i];\n    }\n    \n    @AfterTemplate\n    Object after(InvocationOnMock invocation, int i) {\n        return invocation.getArgument(i);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitExpression(Expression elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{invocation:any(org.mockito.invocation.InvocationOnMock)}.getArguments()[#{i:any(int)}]").bindType("java.lang.Object").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"mockito-core-5"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{invocation:any(org.mockito.invocation.InvocationOnMock)}.getArgument(#{i:any(int)})").bindType("java.lang.Object").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"mockito-core-5"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitExpression(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.mockito.invocation.InvocationOnMock", Boolean.valueOf(true)), new UsesMethod("org.mockito.invocation.InvocationOnMock getArguments(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

