/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class PrimitiveRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`PrimitiveRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to expressions dealing with primitives.\n[Source](https://error-prone.picnic.tech/refasterrules/PrimitiveRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new LessThanRecipe(), new LessThanOrEqualToRecipe(), new GreaterThanRecipe(), new GreaterThanOrEqualToRecipe(), new LongToIntExactRecipe(), new CharacterBytesRecipe(), new ShortBytesRecipe(), new IntegerBytesRecipe(), new LongBytesRecipe(), new FloatBytesRecipe(), new DoubleBytesRecipe(), new IntegerSignumIsPositiveRecipe(), new IntegerSignumIsNegativeRecipe(), new LongSignumIsPositiveRecipe(), new LongSignumIsNegativeRecipe(), new IntegerCompareUnsignedRecipe(), new LongCompareUnsignedRecipe(), new IntegerDivideUnsignedRecipe(), new LongDivideUnsignedRecipe(), new IntegerRemainderUnsignedRecipe(), new LongRemainderUnsignedRecipe(), new IntegerParseUnsignedIntRecipe(), new LongParseUnsignedLongRecipe(), new IntegerParseUnsignedIntWithRadixRecipe(), new LongParseUnsignedLongWithRadixRecipe(), new IntegerToUnsignedStringRecipe(), new LongToUnsignedStringRecipe(), new IntegerToUnsignedStringWithRadixRecipe(), new LongToUnsignedStringWithRadixRecipe(), new ArraysCompareUnsignedBytesRecipe(), new ArraysCompareUnsignedIntsRecipe(), new ArraysCompareUnsignedLongsRecipe()});
    }

    @NullMarked
    public static class LessThanRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.LessThan`";
        }

        public String getDescription() {
            return "Avoid contrived ways of expressing the \"less than\" relationship.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S1940");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"!(#{a:any(double)} >= #{b:any(double)})").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{a:any(double)} < #{b:any(double)}").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitUnary(elem, (Object)ctx);
                }
            };
        }
    }

    @NullMarked
    public static class LessThanOrEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.LessThanOrEqualTo`";
        }

        public String getDescription() {
            return "Avoid contrived ways of expressing the \"less than or equal to\" relationship.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S1940");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"!(#{a:any(double)} > #{b:any(double)})").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{a:any(double)} <= #{b:any(double)}").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitUnary(elem, (Object)ctx);
                }
            };
        }
    }

    @NullMarked
    public static class GreaterThanRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.GreaterThan`";
        }

        public String getDescription() {
            return "Avoid contrived ways of expressing the \"greater than\" relationship.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S1940");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"!(#{a:any(double)} <= #{b:any(double)})").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{a:any(double)} > #{b:any(double)}").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitUnary(elem, (Object)ctx);
                }
            };
        }
    }

    @NullMarked
    public static class GreaterThanOrEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.GreaterThanOrEqualTo`";
        }

        public String getDescription() {
            return "Avoid contrived ways of expressing the \"greater than or equal to\" relationship.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S1940");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"!(#{a:any(double)} < #{b:any(double)})").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{a:any(double)} >= #{b:any(double)}").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitUnary(elem, (Object)ctx);
                }
            };
        }
    }

    @NullMarked
    public static class LongToIntExactRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.LongToIntExact`";
        }

        public String getDescription() {
            return "Prefer `Math#toIntExact(long)` over the Guava alternative.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.primitives.Ints.checkedCast(#{l:any(long)})").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Ints");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Math.toIntExact(#{l:any(long)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.Ints", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.Ints checkedCast(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class CharacterBytesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.CharacterBytes`";
        }

        public String getDescription() {
            return "Prefer `Character#BYTES` over the Guava alternative.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitFieldAccess(J.FieldAccess elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.primitives.Chars.BYTES").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Chars");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Character.BYTES").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitFieldAccess(elem, (Object)ctx);
                }

                public J visitIdentifier(J.Identifier elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.primitives.Chars.BYTES").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Chars");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Character.BYTES").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitIdentifier(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("com.google.common.primitives.Chars", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ShortBytesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.ShortBytes`";
        }

        public String getDescription() {
            return "Prefer `Short#BYTES` over the Guava alternative.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitFieldAccess(J.FieldAccess elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.primitives.Shorts.BYTES").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Shorts");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Short.BYTES").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitFieldAccess(elem, (Object)ctx);
                }

                public J visitIdentifier(J.Identifier elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.primitives.Shorts.BYTES").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Shorts");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Short.BYTES").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitIdentifier(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("com.google.common.primitives.Shorts", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class IntegerBytesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.IntegerBytes`";
        }

        public String getDescription() {
            return "Prefer `Integer#BYTES` over the Guava alternative.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitFieldAccess(J.FieldAccess elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.primitives.Ints.BYTES").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Ints");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Integer.BYTES").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitFieldAccess(elem, (Object)ctx);
                }

                public J visitIdentifier(J.Identifier elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.primitives.Ints.BYTES").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Ints");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Integer.BYTES").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitIdentifier(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("com.google.common.primitives.Ints", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LongBytesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.LongBytes`";
        }

        public String getDescription() {
            return "Prefer `Long#BYTES` over the Guava alternative.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitFieldAccess(J.FieldAccess elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.primitives.Longs.BYTES").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Longs");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Long.BYTES").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitFieldAccess(elem, (Object)ctx);
                }

                public J visitIdentifier(J.Identifier elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.primitives.Longs.BYTES").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Longs");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Long.BYTES").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitIdentifier(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("com.google.common.primitives.Longs", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FloatBytesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.FloatBytes`";
        }

        public String getDescription() {
            return "Prefer `Float#BYTES` over the Guava alternative.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitFieldAccess(J.FieldAccess elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.primitives.Floats.BYTES").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Floats");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Float.BYTES").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitFieldAccess(elem, (Object)ctx);
                }

                public J visitIdentifier(J.Identifier elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.primitives.Floats.BYTES").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Floats");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Float.BYTES").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitIdentifier(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("com.google.common.primitives.Floats", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class DoubleBytesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.DoubleBytes`";
        }

        public String getDescription() {
            return "Prefer `Double#BYTES` over the Guava alternative.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitFieldAccess(J.FieldAccess elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.primitives.Doubles.BYTES").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Doubles");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Double.BYTES").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitFieldAccess(elem, (Object)ctx);
                }

                public J visitIdentifier(J.Identifier elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.primitives.Doubles.BYTES").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Doubles");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Double.BYTES").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitIdentifier(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("com.google.common.primitives.Doubles", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class IntegerSignumIsPositiveRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.IntegerSignumIsPositive`";
        }

        public String getDescription() {
            return "Prefer an `Integer#signum(int)` comparison to 1 over less clear alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"Integer.signum(#{i:any(int)}) > 0").build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Integer.signum(#{i:any(int)}) == 1").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"Integer.signum(#{i:any(int)}) >= 1").build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Integer.signum(#{i:any(int)}) == 1").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("java.lang.Integer signum(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class IntegerSignumIsNegativeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.IntegerSignumIsNegative`";
        }

        public String getDescription() {
            return "Prefer an `Integer#signum(int)` comparison to -1 over less clear alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"Integer.signum(#{i:any(int)}) < 0").build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Integer.signum(#{i:any(int)}) == -1").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"Integer.signum(#{i:any(int)}) <= -1").build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Integer.signum(#{i:any(int)}) == -1").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("java.lang.Integer signum(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LongSignumIsPositiveRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.LongSignumIsPositive`";
        }

        public String getDescription() {
            return "Prefer an `Long#signum(long)` comparison to 1 over less clear alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"Long.signum(#{l:any(long)}) > 0").build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Long.signum(#{l:any(long)}) == 1").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"Long.signum(#{l:any(long)}) >= 1").build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Long.signum(#{l:any(long)}) == 1").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("java.lang.Long signum(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LongSignumIsNegativeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.LongSignumIsNegative`";
        }

        public String getDescription() {
            return "Prefer an `Long#signum(long)` comparison to -1 over less clear alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"Long.signum(#{l:any(long)}) < 0").build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Long.signum(#{l:any(long)}) == -1").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"Long.signum(#{l:any(long)}) <= -1").build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Long.signum(#{l:any(long)}) == -1").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("java.lang.Long signum(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class IntegerCompareUnsignedRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.IntegerCompareUnsigned`";
        }

        public String getDescription() {
            return "Prefer JDK's `Integer#compareUnsigned(int, int)` over third-party alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.primitives.UnsignedInts.compare(#{x:any(int)}, #{y:any(int)})").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.primitives.UnsignedInts");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Integer.compareUnsigned(#{x:any(int)}, #{y:any(int)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.UnsignedInts", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.UnsignedInts compare(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LongCompareUnsignedRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.LongCompareUnsigned`";
        }

        public String getDescription() {
            return "Prefer JDK's `Long#compareUnsigned(long, long)` over third-party alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.primitives.UnsignedLongs.compare(#{x:any(long)}, #{y:any(long)})").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.primitives.UnsignedLongs");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Long.compareUnsigned(#{x:any(long)}, #{y:any(long)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.UnsignedLongs", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.UnsignedLongs compare(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class IntegerDivideUnsignedRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.IntegerDivideUnsigned`";
        }

        public String getDescription() {
            return "Prefer JDK's `Integer#divideUnsigned(int, int)` over third-party alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.primitives.UnsignedInts.divide(#{x:any(int)}, #{y:any(int)})").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.primitives.UnsignedInts");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Integer.divideUnsigned(#{x:any(int)}, #{y:any(int)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.UnsignedInts", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.UnsignedInts divide(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LongDivideUnsignedRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.LongDivideUnsigned`";
        }

        public String getDescription() {
            return "Prefer JDK's `Long#divideUnsigned(long, long)` over third-party alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.primitives.UnsignedLongs.divide(#{x:any(long)}, #{y:any(long)})").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.primitives.UnsignedLongs");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Long.divideUnsigned(#{x:any(long)}, #{y:any(long)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.UnsignedLongs", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.UnsignedLongs divide(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class IntegerRemainderUnsignedRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.IntegerRemainderUnsigned`";
        }

        public String getDescription() {
            return "Prefer JDK's `Integer#remainderUnsigned(int, int)` over third-party alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.primitives.UnsignedInts.remainder(#{x:any(int)}, #{y:any(int)})").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.primitives.UnsignedInts");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Integer.remainderUnsigned(#{x:any(int)}, #{y:any(int)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.UnsignedInts", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.UnsignedInts remainder(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LongRemainderUnsignedRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.LongRemainderUnsigned`";
        }

        public String getDescription() {
            return "Prefer JDK's `Long#remainderUnsigned(long, long)` over third-party alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.primitives.UnsignedLongs.remainder(#{x:any(long)}, #{y:any(long)})").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.primitives.UnsignedLongs");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Long.remainderUnsigned(#{x:any(long)}, #{y:any(long)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.UnsignedLongs", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.UnsignedLongs remainder(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class IntegerParseUnsignedIntRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.IntegerParseUnsignedInt`";
        }

        public String getDescription() {
            return "Prefer JDK's `Integer#parseUnsignedInt(String)` over third-party or more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"com.google.common.primitives.UnsignedInts.parseUnsignedInt(#{string:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.primitives.UnsignedInts");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Integer.parseUnsignedInt(#{string:any(java.lang.String)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"Integer.parseUnsignedInt(#{string:any(java.lang.String)}, 10)").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Integer.parseUnsignedInt(#{string:any(java.lang.String)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.Integer parseUnsignedInt(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.UnsignedInts", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.UnsignedInts parseUnsignedInt(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LongParseUnsignedLongRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.LongParseUnsignedLong`";
        }

        public String getDescription() {
            return "Prefer JDK's `Long#parseUnsignedLong(String)` over third-party or more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"com.google.common.primitives.UnsignedLongs.parseUnsignedLong(#{string:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.primitives.UnsignedLongs");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Long.parseUnsignedLong(#{string:any(java.lang.String)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"Long.parseUnsignedLong(#{string:any(java.lang.String)}, 10)").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Long.parseUnsignedLong(#{string:any(java.lang.String)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.Long parseUnsignedLong(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.UnsignedLongs", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.UnsignedLongs parseUnsignedLong(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class IntegerParseUnsignedIntWithRadixRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.IntegerParseUnsignedIntWithRadix`";
        }

        public String getDescription() {
            return "Prefer JDK's `Integer#parseUnsignedInt(String, int)` over third-party alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.primitives.UnsignedInts.parseUnsignedInt(#{string:any(java.lang.String)}, #{radix:any(int)})").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.primitives.UnsignedInts");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Integer.parseUnsignedInt(#{string:any(java.lang.String)}, #{radix:any(int)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.UnsignedInts", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.UnsignedInts parseUnsignedInt(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LongParseUnsignedLongWithRadixRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.LongParseUnsignedLongWithRadix`";
        }

        public String getDescription() {
            return "Prefer JDK's `Long#parseUnsignedLong(String, int)` over third-party alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.primitives.UnsignedLongs.parseUnsignedLong(#{string:any(java.lang.String)}, #{radix:any(int)})").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.primitives.UnsignedLongs");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Long.parseUnsignedLong(#{string:any(java.lang.String)}, #{radix:any(int)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.UnsignedLongs", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.UnsignedLongs parseUnsignedLong(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class IntegerToUnsignedStringRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.IntegerToUnsignedString`";
        }

        public String getDescription() {
            return "Prefer JDK's `Integer#toUnsignedString(int)` over third-party or more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"com.google.common.primitives.UnsignedInts.toString(#{i:any(int)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.primitives.UnsignedInts");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Integer.toUnsignedString(#{i:any(int)})").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"Integer.toUnsignedString(#{i:any(int)}, 10)").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Integer.toUnsignedString(#{i:any(int)})").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.Integer toUnsignedString(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.UnsignedInts", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.UnsignedInts toString(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LongToUnsignedStringRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.LongToUnsignedString`";
        }

        public String getDescription() {
            return "Prefer JDK's `Long#toUnsignedString(long)` over third-party or more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"com.google.common.primitives.UnsignedLongs.toString(#{i:any(long)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.primitives.UnsignedLongs");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Long.toUnsignedString(#{i:any(long)})").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"Long.toUnsignedString(#{i:any(long)}, 10)").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Long.toUnsignedString(#{i:any(long)})").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.Long toUnsignedString(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.UnsignedLongs", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.UnsignedLongs toString(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class IntegerToUnsignedStringWithRadixRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.IntegerToUnsignedStringWithRadix`";
        }

        public String getDescription() {
            return "Prefer JDK's `Integer#toUnsignedString(int,int)` over third-party alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.primitives.UnsignedInts.toString(#{i:any(int)}, #{radix:any(int)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.primitives.UnsignedInts");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Integer.toUnsignedString(#{i:any(int)}, #{radix:any(int)})").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.UnsignedInts", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.UnsignedInts toString(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LongToUnsignedStringWithRadixRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.LongToUnsignedStringWithRadix`";
        }

        public String getDescription() {
            return "Prefer JDK's `Long#toUnsignedString(long,int)` over third-party alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.primitives.UnsignedLongs.toString(#{i:any(long)}, #{radix:any(int)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.primitives.UnsignedLongs");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Long.toUnsignedString(#{i:any(long)}, #{radix:any(int)})").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.UnsignedLongs", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.UnsignedLongs toString(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ArraysCompareUnsignedBytesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.ArraysCompareUnsignedBytes`";
        }

        public String getDescription() {
            return "Prefer JDK's `Arrays#compareUnsigned(byte[], byte[])` over third-party alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.primitives.UnsignedBytes.lexicographicalComparator()").bindType("java.util.Comparator<byte[]>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.primitives.UnsignedBytes");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Arrays::compareUnsigned").bindType("java.util.Comparator<byte[]>").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.UnsignedBytes", Boolean.valueOf(true)), new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.UnsignedBytes lexicographicalComparator(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ArraysCompareUnsignedIntsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.ArraysCompareUnsignedInts`";
        }

        public String getDescription() {
            return "Prefer JDK's `Arrays#compareUnsigned(int[], int[])` over third-party alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.primitives.UnsignedInts.lexicographicalComparator()").bindType("java.util.Comparator<int[]>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.primitives.UnsignedInts");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Arrays::compareUnsigned").bindType("java.util.Comparator<int[]>").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.UnsignedInts", Boolean.valueOf(true)), new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.UnsignedInts lexicographicalComparator(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ArraysCompareUnsignedLongsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PrimitiveRules.ArraysCompareUnsignedLongs`";
        }

        public String getDescription() {
            return "Prefer JDK's `Arrays#compareUnsigned(long[], long[])` over third-party alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.primitives.UnsignedLongs.lexicographicalComparator()").bindType("java.util.Comparator<long[]>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.primitives.UnsignedLongs");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Arrays::compareUnsigned").bindType("java.util.Comparator<long[]>").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.UnsignedLongs", Boolean.valueOf(true)), new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.UnsignedLongs lexicographicalComparator(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

