/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectArrayAssert;
import org.assertj.core.api.Assertions;

final class AssertJArrayRules {
    private AssertJArrayRules() {
    }

    static final class AssertThatHasSizeBetween<T> {
        AssertThatHasSizeBetween() {
        }

        AbstractIntegerAssert<?> before(T[] array, int lowerBound, int upperBound) {
            return Assertions.assertThat((int)array.length).isBetween(Integer.valueOf(lowerBound), Integer.valueOf(upperBound));
        }

        AbstractObjectArrayAssert<?, T> after(T[] array, int lowerBound, int upperBound) {
            return Assertions.assertThat((Object[])array).hasSizeBetween(lowerBound, upperBound);
        }
    }

    static final class AssertThatHasSizeGreaterThanOrEqualTo<T> {
        AssertThatHasSizeGreaterThanOrEqualTo() {
        }

        AbstractIntegerAssert<?> before(T[] array, int size) {
            return Assertions.assertThat((int)array.length).isGreaterThanOrEqualTo(size);
        }

        AbstractObjectArrayAssert<?, T> after(T[] array, int size) {
            return Assertions.assertThat((Object[])array).hasSizeGreaterThanOrEqualTo(size);
        }
    }

    static final class AssertThatHasSizeGreaterThan<T> {
        AssertThatHasSizeGreaterThan() {
        }

        AbstractIntegerAssert<?> before(T[] array, int size) {
            return Assertions.assertThat((int)array.length).isGreaterThan(size);
        }

        AbstractObjectArrayAssert<?, T> after(T[] array, int size) {
            return Assertions.assertThat((Object[])array).hasSizeGreaterThan(size);
        }
    }

    static final class AssertThatHasSizeLessThanOrEqualTo<T> {
        AssertThatHasSizeLessThanOrEqualTo() {
        }

        AbstractIntegerAssert<?> before(T[] array, int size) {
            return Assertions.assertThat((int)array.length).isLessThanOrEqualTo(size);
        }

        AbstractObjectArrayAssert<?, T> after(T[] array, int size) {
            return Assertions.assertThat((Object[])array).hasSizeLessThanOrEqualTo(size);
        }
    }

    static final class AssertThatHasSizeLessThan<T> {
        AssertThatHasSizeLessThan() {
        }

        AbstractIntegerAssert<?> before(T[] array, int size) {
            return Assertions.assertThat((int)array.length).isLessThan(size);
        }

        AbstractObjectArrayAssert<?, T> after(T[] array, int size) {
            return Assertions.assertThat((Object[])array).hasSizeLessThan(size);
        }
    }

    static final class AssertThatHasSize<T> {
        AssertThatHasSize() {
        }

        AbstractIntegerAssert<?> before(T[] array, int size) {
            return Assertions.assertThat((int)array.length).isEqualTo(size);
        }

        AbstractObjectArrayAssert<?, T> after(T[] array, int size) {
            return Assertions.assertThat((Object[])array).hasSize(size);
        }
    }
}

