/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;

final class AssertJStringRules {
    private AssertJStringRules() {
    }

    static final class AssertThatPathContentUtf8 {
        AssertThatPathContentUtf8() {
        }

        AbstractStringAssert<?> before(Path path) throws IOException {
            return Assertions.assertThat((String)Files.readString(path));
        }

        AbstractStringAssert<?> after(Path path) {
            return Assertions.assertThat((Path)path).content(StandardCharsets.UTF_8);
        }
    }

    static final class AssertThatPathContent {
        AssertThatPathContent() {
        }

        AbstractStringAssert<?> before(Path path, Charset charset) throws IOException {
            return Assertions.assertThat((String)Files.readString(path, charset));
        }

        AbstractStringAssert<?> after(Path path, Charset charset) {
            return Assertions.assertThat((Path)path).content(charset);
        }
    }

    static final class AssertThatDoesNotMatch {
        AssertThatDoesNotMatch() {
        }

        AbstractAssert<?, ?> before(String string, String regex) {
            return Assertions.assertThat((boolean)string.matches(regex)).isFalse();
        }

        AbstractAssert<?, ?> after(String string, String regex) {
            return Assertions.assertThat((String)string).doesNotMatch((CharSequence)regex);
        }
    }

    static final class AssertThatMatches {
        AssertThatMatches() {
        }

        AbstractAssert<?, ?> before(String string, String regex) {
            return Assertions.assertThat((boolean)string.matches(regex)).isTrue();
        }

        AbstractAssert<?, ?> after(String string, String regex) {
            return Assertions.assertThat((String)string).matches((CharSequence)regex);
        }
    }

    static final class AssertThatStringDoesNotContain {
        AssertThatStringDoesNotContain() {
        }

        AbstractBooleanAssert<?> before(String string, CharSequence substring) {
            return Assertions.assertThat((boolean)string.contains(substring)).isFalse();
        }

        AbstractStringAssert<?> after(String string, CharSequence substring) {
            return (AbstractStringAssert)Assertions.assertThat((String)string).doesNotContain(new CharSequence[]{substring});
        }
    }

    static final class AssertThatStringContains {
        AssertThatStringContains() {
        }

        AbstractBooleanAssert<?> before(String string, CharSequence substring) {
            return Assertions.assertThat((boolean)string.contains(substring)).isTrue();
        }

        AbstractStringAssert<?> after(String string, CharSequence substring) {
            return (AbstractStringAssert)Assertions.assertThat((String)string).contains(new CharSequence[]{substring});
        }
    }

    static final class AssertThatStringDoesNotEndWith {
        AssertThatStringDoesNotEndWith() {
        }

        AbstractBooleanAssert<?> before(String string, String prefix) {
            return Assertions.assertThat((boolean)string.endsWith(prefix)).isFalse();
        }

        AbstractStringAssert<?> after(String string, String prefix) {
            return (AbstractStringAssert)Assertions.assertThat((String)string).doesNotEndWith((CharSequence)prefix);
        }
    }

    static final class AssertThatStringEndsWith {
        AssertThatStringEndsWith() {
        }

        AbstractBooleanAssert<?> before(String string, String prefix) {
            return Assertions.assertThat((boolean)string.endsWith(prefix)).isTrue();
        }

        AbstractStringAssert<?> after(String string, String prefix) {
            return (AbstractStringAssert)Assertions.assertThat((String)string).endsWith((CharSequence)prefix);
        }
    }

    static final class AssertThatStringDoesNotStartWith {
        AssertThatStringDoesNotStartWith() {
        }

        AbstractBooleanAssert<?> before(String string, String prefix) {
            return Assertions.assertThat((boolean)string.startsWith(prefix)).isFalse();
        }

        AbstractStringAssert<?> after(String string, String prefix) {
            return (AbstractStringAssert)Assertions.assertThat((String)string).doesNotStartWith((CharSequence)prefix);
        }
    }

    static final class AssertThatStringStartsWith {
        AssertThatStringStartsWith() {
        }

        AbstractBooleanAssert<?> before(String string, String prefix) {
            return Assertions.assertThat((boolean)string.startsWith(prefix)).isTrue();
        }

        AbstractStringAssert<?> after(String string, String prefix) {
            return (AbstractStringAssert)Assertions.assertThat((String)string).startsWith((CharSequence)prefix);
        }
    }

    static final class AbstractStringAssertStringIsNotEmpty {
        AbstractStringAssertStringIsNotEmpty() {
        }

        AbstractStringAssert<?> before(AbstractStringAssert<?> stringAssert) {
            return (AbstractStringAssert)stringAssert.isNotEqualTo((Object)"");
        }

        AbstractStringAssert<?> after(AbstractStringAssert<?> stringAssert) {
            return (AbstractStringAssert)stringAssert.isNotEmpty();
        }
    }

    static final class AbstractStringAssertStringIsEmpty {
        AbstractStringAssertStringIsEmpty() {
        }

        void before(AbstractStringAssert<?> stringAssert) {
            stringAssert.isEqualTo("");
        }

        void after(AbstractStringAssert<?> stringAssert) {
            stringAssert.isEmpty();
        }
    }
}

