/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.BugCheckerRefactoringTestHelper;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.refaster.Refaster;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.util.Constants;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.JCDiagnostic;
import javax.lang.model.element.Name;
import tech.picnic.errorprone.utils.SourceCode;

final class BugCheckerRules {
    private BugCheckerRules() {
    }

    static final class ASTHelpersGetStartPosition<T extends JCDiagnostic.DiagnosticPosition> {
        ASTHelpersGetStartPosition() {
        }

        int before(Tree tree) {
            return ((JCDiagnostic.DiagnosticPosition)((Object)tree)).getStartPosition();
        }

        int after(Tree tree) {
            return ASTHelpers.getStartPosition((Tree)tree);
        }
    }

    static final class NameContentEquals {
        NameContentEquals() {
        }

        boolean before(Name name, CharSequence string) {
            return name.toString().equals(string.toString());
        }

        boolean before(Name name, String string) {
            return name.toString().equals(string);
        }

        boolean after(Name name, CharSequence string) {
            return name.contentEquals(string);
        }
    }

    static final class ConstantsFormat {
        ConstantsFormat() {
        }

        String before(CharSequence value) {
            return Constants.format(value);
        }

        String before(String value) {
            return "\"%s\"".formatted(Convert.quote(value));
        }

        String after(CharSequence value) {
            return SourceCode.toStringConstantExpression((Object)value, (VisitorState)((VisitorState)Refaster.emitCommentBefore((String)"REPLACEME", null)));
        }
    }

    static final class BugCheckerRefactoringTestHelperAddInputLinesExpectUnchanged {
        BugCheckerRefactoringTestHelperAddInputLinesExpectUnchanged() {
        }

        BugCheckerRefactoringTestHelper before(BugCheckerRefactoringTestHelper helper, String path, String source) {
            return helper.addInputLines(path, new String[]{source}).addOutputLines(path, new String[]{source});
        }

        BugCheckerRefactoringTestHelper after(BugCheckerRefactoringTestHelper helper, String path, String source) {
            return helper.addInputLines(path, new String[]{source}).expectUnchanged();
        }
    }

    static final class BugCheckerRefactoringTestHelperIdentity {
        BugCheckerRefactoringTestHelperIdentity() {
        }

        BugCheckerRefactoringTestHelper before(BugCheckerRefactoringTestHelper helper) {
            return (BugCheckerRefactoringTestHelper)Refaster.anyOf((Object[])new BugCheckerRefactoringTestHelper[]{helper.setFixChooser((BugCheckerRefactoringTestHelper.FixChooser)BugCheckerRefactoringTestHelper.FixChoosers.FIRST), helper.setImportOrder("static-first")});
        }

        @CanIgnoreReturnValue
        BugCheckerRefactoringTestHelper after(BugCheckerRefactoringTestHelper helper) {
            return helper;
        }
    }
}

