/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.refaster.Refaster;
import java.util.Optional;
import tools.jackson.core.type.TypeReference;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;

final class Jackson3Rules {
    private Jackson3Rules() {
    }

    static final class ObjectMapperConvertValueWithTypeReference<T> {
        ObjectMapperConvertValueWithTypeReference() {
        }

        T before(ObjectMapper objectMapper, Object object, TypeReference<T> valueTypeRef) {
            return (T)Refaster.anyOf((Object[])new Object[]{objectMapper.readValue(objectMapper.writeValueAsBytes(object), valueTypeRef), objectMapper.readValue(objectMapper.writeValueAsString(object), valueTypeRef)});
        }

        T after(ObjectMapper objectMapper, Object object, TypeReference<T> valueTypeRef) {
            return (T)objectMapper.convertValue(object, valueTypeRef);
        }
    }

    static final class ObjectMapperConvertValueWithJavaType<T> {
        ObjectMapperConvertValueWithJavaType() {
        }

        T before(ObjectMapper objectMapper, Object object, JavaType valueType) {
            return (T)Refaster.anyOf((Object[])new Object[]{objectMapper.readValue(objectMapper.writeValueAsBytes(object), valueType), objectMapper.readValue(objectMapper.writeValueAsString(object), valueType)});
        }

        T after(ObjectMapper objectMapper, Object object, JavaType valueType) {
            return (T)objectMapper.convertValue(object, valueType);
        }
    }

    static final class ObjectMapperConvertValueWithClass<T> {
        ObjectMapperConvertValueWithClass() {
        }

        T before(ObjectMapper objectMapper, Object object, Class<T> valueType) {
            return (T)Refaster.anyOf((Object[])new Object[]{objectMapper.readValue(objectMapper.writeValueAsBytes(object), valueType), objectMapper.readValue(objectMapper.writeValueAsString(object), valueType)});
        }

        T after(ObjectMapper objectMapper, Object object, Class<T> valueType) {
            return (T)objectMapper.convertValue(object, valueType);
        }
    }

    static final class ObjectMapperValueToTree {
        ObjectMapperValueToTree() {
        }

        JsonNode before(ObjectMapper objectMapper, Object object) {
            return (JsonNode)Refaster.anyOf((Object[])new JsonNode[]{objectMapper.readTree(objectMapper.writeValueAsBytes(object)), objectMapper.readTree(objectMapper.writeValueAsString(object))});
        }

        JsonNode after(ObjectMapper objectMapper, Object object) {
            return objectMapper.valueToTree(object);
        }
    }

    static final class JsonNodeOptionalString {
        JsonNodeOptionalString() {
        }

        Optional<JsonNode> before(JsonNode node, String fieldName) {
            return (Optional)Refaster.anyOf((Object[])new Optional[]{node.get(fieldName).asOptional(), node.path(fieldName).asOptional(), Optional.of(node.get(fieldName)), Optional.ofNullable(node.get(fieldName))});
        }

        Optional<JsonNode> after(JsonNode node, String fieldName) {
            return node.optional(fieldName);
        }
    }

    static final class JsonNodeOptionalInt {
        JsonNodeOptionalInt() {
        }

        Optional<JsonNode> before(JsonNode node, int index) {
            return (Optional)Refaster.anyOf((Object[])new Optional[]{node.get(index).asOptional(), node.path(index).asOptional(), Optional.of(node.get(index)), Optional.ofNullable(node.get(index))});
        }

        Optional<JsonNode> after(JsonNode node, int index) {
            return node.optional(index);
        }
    }
}

