/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refaster.matchers;

import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.util.function.Function;
import tech.picnic.errorprone.utils.MoreMatchers;
import tech.picnic.errorprone.utils.MoreTypePredicates;
import tech.picnic.errorprone.utils.MoreTypes;

public final class ReturnsMono
implements Matcher<ExpressionTree> {
    private static final long serialVersionUID = 1L;
    private static final Supplier<Type> MONO = MoreTypes.generic((Supplier)Suppliers.typeFromString((String)"reactor.core.publisher.Mono"), (Supplier[])new Supplier[]{MoreTypes.unbound()});
    private static final Supplier<Type> MONO_RETURNING_FUNCTION = MoreTypes.generic((Supplier)Suppliers.typeFromString((String)Function.class.getCanonicalName()), (Supplier[])new Supplier[]{MoreTypes.unbound(), MoreTypes.subOf(MONO)});
    private static final TypePredicate IS_MONO_TYPE = MoreTypePredicates.isSubTypeOf(MONO);
    private static final Matcher<Tree> IS_MONO_TREE = MoreMatchers.isSubTypeOf(MONO);
    private static final Matcher<Tree> IS_FUNCTION_RETURNING_MONO_TREE = MoreMatchers.isSubTypeOf(MONO_RETURNING_FUNCTION);
    private static final Matcher<Tree> IS_FUNCTION_TREE = Matchers.isSubtypeOf(MONO_RETURNING_FUNCTION);

    public boolean matches(ExpressionTree tree, VisitorState state) {
        if (!IS_FUNCTION_TREE.matches((Tree)tree, state)) {
            return false;
        }
        if (tree instanceof LambdaExpressionTree) {
            LambdaExpressionTree lambdaExpression = (LambdaExpressionTree)tree;
            return IS_MONO_TREE.matches(lambdaExpression.getBody(), state);
        }
        if (tree instanceof MemberReferenceTree) {
            MemberReferenceTree memberReference = (MemberReferenceTree)tree;
            return IS_MONO_TYPE.apply(ASTHelpers.getSymbol((MemberReferenceTree)memberReference).type.asMethodType().getReturnType(), state);
        }
        return IS_FUNCTION_RETURNING_MONO_TREE.matches((Tree)tree, state);
    }
}

