/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.jenkins.remotesupport;

import com.testdroid.api.APIClient;
import com.testdroid.api.model.APIProject;
import com.testdroid.jenkins.Messages;
import com.testdroid.jenkins.TestdroidCloudSettings;
import com.testdroid.jenkins.remotesupport.MachineIndependentTask;
import com.testdroid.jenkins.utils.TestdroidApiUtil;
import hudson.FilePath;
import hudson.model.BuildListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MachineIndependentFileUploader
extends MachineIndependentTask
implements FilePath.FileCallable<Long> {
    private static final Logger LOGGER = Logger.getLogger(MachineIndependentFileUploader.class.getName());
    private FILE_TYPE fileType;
    BuildListener listener;
    long projectId;

    public MachineIndependentFileUploader(TestdroidCloudSettings.DescriptorImpl descriptor, long projectId, FILE_TYPE fileType, BuildListener listener) {
        super(descriptor);
        this.projectId = projectId;
        this.fileType = fileType;
        this.listener = listener;
    }

    public Long invoke(File file, VirtualChannel vc) throws IOException, InterruptedException {
        Long result = null;
        int attempts = 3;
        do {
            try {
                if (!TestdroidApiUtil.isInitialized()) {
                    TestdroidApiUtil.init(this.user, this.password, this.cloudUrl, this.privateInstance, this.noCheckCertificate, this.isProxy, this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPassword);
                }
                APIClient client = TestdroidApiUtil.getInstance().getTestdroidAPIClient();
                APIProject project = client.me().getProject(Long.valueOf(this.projectId));
                if (file.exists()) {
                    switch (this.fileType) {
                        case APPLICATION: {
                            result = project.uploadApplication(file, "application/octet-stream").getId();
                            break;
                        }
                        case TEST: {
                            result = project.uploadTest(file, "application/octet-stream").getId();
                            break;
                        }
                        case DATA: {
                            result = project.uploadData(file, "application/zip").getId();
                        }
                    }
                    continue;
                }
                this.listener.getLogger().println(String.format("%s: %s", Messages.ERROR_FILE_NOT_FOUND(), file.getAbsolutePath()));
                return null;
            }
            catch (Exception ex) {
                String message = String.format("Cannot upload file %s%s", file.getAbsolutePath(), attempts > 1 ? ". Will retry automatically" : "Won't be retried anymore");
                this.listener.getLogger().println(message);
                LOGGER.log(Level.WARNING, message, ex);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } while (result == null && --attempts > 0);
        return result;
    }

    public static enum FILE_TYPE {
        APPLICATION,
        TEST,
        DATA;

    }
}

