/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.jenkins.scheduler;

import com.testdroid.api.APIException;
import com.testdroid.api.model.APITestRun;
import com.testdroid.api.model.APIUser;
import com.testdroid.jenkins.Messages;
import com.testdroid.jenkins.TestdroidCloudSettings;
import com.testdroid.jenkins.scheduler.TestRunFinishCheckScheduler;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class APIDrivenTestFinishCheckScheduler
implements TestRunFinishCheckScheduler {
    public static final Logger LOGGER = Logger.getLogger(APIDrivenTestFinishCheckScheduler.class.getName());
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> taskHandle;

    @Override
    public void schedule(final Object object, final Long projectId, final Long testRunId) {
        Runnable beeper = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LOGGER.info(Messages.CHECK_FOR_TESTRUN_STATE(testRunId));
                if (APIDrivenTestFinishCheckScheduler.this.checkResult(projectId, testRunId)) {
                    Object object2 = object;
                    synchronized (object2) {
                        object.notify();
                    }
                }
            }
        };
        this.taskHandle = this.scheduler.scheduleAtFixedRate(beeper, 60L, 60L, TimeUnit.SECONDS);
    }

    @Override
    public void cancel(Long projectId, Long testRunId) {
        if (this.taskHandle != null) {
            this.taskHandle.cancel(true);
        }
    }

    private boolean checkResult(Long projectId, Long testRunId) {
        boolean result = false;
        try {
            APIUser user = TestdroidCloudSettings.descriptor().getUser();
            APITestRun testRun = user.getProject(projectId).getTestRun(testRunId);
            if (testRun.getState() == APITestRun.State.FINISHED) {
                result = true;
            }
        }
        catch (APIException exc) {
            LOGGER.log(Level.SEVERE, Messages.API_GET_TESTRUN_ERROR(testRunId), exc);
        }
        return result;
    }
}

