/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.IOException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import org.apache.tomcat.util.net.jsse.JSSESocketFactory;
import sun.security.provider.Sun;

public class JSSE13SocketFactory
extends JSSESocketFactory {
    protected boolean clientAuth = false;

    void init() throws IOException {
        try {
            KeyStore trustStore;
            String algorithm;
            String protocol;
            Security.addProvider(new Sun());
            Security.addProvider((java.security.Provider)new Provider());
            String clientAuthStr = (String)this.attributes.get("clientauth");
            if ("true".equalsIgnoreCase(clientAuthStr) || "yes".equalsIgnoreCase(clientAuthStr) || "want".equalsIgnoreCase(clientAuthStr)) {
                this.clientAuth = true;
            }
            if ((protocol = (String)this.attributes.get("protocol")) == null) {
                protocol = JSSESocketFactory.defaultProtocol;
            }
            if ((algorithm = (String)this.attributes.get("algorithm")) == null) {
                algorithm = JSSESocketFactory.defaultAlgorithm;
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance((String)algorithm);
            String keystoreType = (String)this.attributes.get("keystoreType");
            if (keystoreType == null) {
                keystoreType = JSSESocketFactory.defaultKeystoreType;
            }
            String keystorePass = this.getKeystorePassword();
            kmf.init(this.getKeystore(keystoreType, keystorePass), keystorePass.toCharArray());
            TrustManager[] tm = null;
            String truststoreType = (String)this.attributes.get("truststoreType");
            if (truststoreType == null) {
                truststoreType = keystoreType;
            }
            if ((trustStore = this.getTrustStore(truststoreType)) != null) {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance((String)"SunX509");
                tmf.init(trustStore);
                tm = tmf.getTrustManagers();
            }
            SSLContext context = SSLContext.getInstance((String)protocol);
            context.init(kmf.getKeyManagers(), tm, new SecureRandom());
            this.sslProxy = context.getServerSocketFactory();
            String requestedCiphers = (String)this.attributes.get("ciphers");
            if (requestedCiphers != null) {
                this.enabledCiphers = this.getEnabledCiphers(requestedCiphers, this.sslProxy.getSupportedCipherSuites());
            }
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage());
        }
    }

    protected String[] getEnabledProtocols(SSLServerSocket socket, String requestedProtocols) {
        return null;
    }

    protected void setEnabledProtocols(SSLServerSocket socket, String[] protocols) {
    }

    protected void configureClientAuth(SSLServerSocket socket) {
        socket.setNeedClientAuth(this.clientAuth);
    }

    protected void configureClientAuth(SSLSocket socket) {
        socket.setNeedClientAuth(this.clientAuth);
    }
}

