/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ext.sql;

import java.sql.Date;
import java.text.DateFormat;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.annotation.JacksonStdImpl;
import tools.jackson.databind.ser.jdk.DateTimeSerializerBase;

@JacksonStdImpl
public class JavaSqlDateSerializer
extends DateTimeSerializerBase<Date> {
    public static final JavaSqlDateSerializer instance = new JavaSqlDateSerializer();

    public JavaSqlDateSerializer() {
        this(null, null);
    }

    protected JavaSqlDateSerializer(Boolean useTimestamp, DateFormat customFormat) {
        super(Date.class, useTimestamp, customFormat);
    }

    public JavaSqlDateSerializer withFormat(Boolean timestamp, DateFormat customFormat) {
        return new JavaSqlDateSerializer(timestamp, customFormat);
    }

    @Override
    protected long _timestamp(Date value) {
        return value == null ? 0L : value.getTime();
    }

    @Override
    public void serialize(Date value, JsonGenerator g, SerializationContext provider) throws JacksonException {
        if (this._asTimestamp(provider)) {
            g.writeNumber(this._timestamp(value));
            return;
        }
        this._serializeAsString(value, g, provider);
    }
}

