/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.csv;

import tools.jackson.core.FormatFeature;

public enum CsvWriteFeature implements FormatFeature
{
    STRICT_CHECK_FOR_QUOTING(false),
    OMIT_MISSING_TAIL_COLUMNS(false),
    ALWAYS_QUOTE_STRINGS(false),
    ALWAYS_QUOTE_EMPTY_STRINGS(false),
    ALWAYS_QUOTE_NUMBERS(false),
    ESCAPE_QUOTE_CHAR_WITH_ESCAPE_CHAR(false),
    ESCAPE_CONTROL_CHARS_WITH_ESCAPE_CHAR(false),
    WRITE_LINEFEED_AFTER_LAST_ROW(true);

    private final boolean _defaultState;
    private final int _mask;

    public static int collectDefaults() {
        int flags = 0;
        for (CsvWriteFeature f : CsvWriteFeature.values()) {
            if (!f.enabledByDefault()) continue;
            flags |= f.getMask();
        }
        return flags;
    }

    private CsvWriteFeature(boolean defaultState) {
        this._defaultState = defaultState;
        this._mask = 1 << this.ordinal();
    }

    public boolean enabledIn(int flags) {
        return (flags & this._mask) != 0;
    }

    public boolean enabledByDefault() {
        return this._defaultState;
    }

    public int getMask() {
        return this._mask;
    }
}

