/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.modelassert.json.condition.tree;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Location {
    private List<String> path;

    public Location() {
        this.path = new LinkedList<String>();
    }

    private Location(List<String> pathSoFar, String child) {
        this.path = Stream.concat(pathSoFar.stream(), Stream.of(child)).collect(Collectors.toCollection(LinkedList::new));
    }

    private Location(List<String> path) {
        this.path = Collections.unmodifiableList(path);
    }

    public Location child(String child) {
        return new Location(this.path, child);
    }

    public Location peelOffFirst() {
        return new Location(this.path.subList(1, this.path.size()));
    }

    public String toString() {
        return this.path.stream().collect(Collectors.joining("/", "/", ""));
    }

    public boolean isEmpty() {
        return this.path.isEmpty();
    }

    public String first() {
        return !this.path.isEmpty() ? this.path.get(0) : null;
    }
}

