/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.modelassert.json.dsl.nodespecific;

import com.fasterxml.jackson.databind.JsonNode;
import uk.org.webcompere.modelassert.json.Condition;
import uk.org.webcompere.modelassert.json.condition.HasSize;
import uk.org.webcompere.modelassert.json.condition.Not;
import uk.org.webcompere.modelassert.json.condition.ObjectContainsKeys;
import uk.org.webcompere.modelassert.json.condition.PredicateWrappedCondition;
import uk.org.webcompere.modelassert.json.dsl.Satisfies;
import uk.org.webcompere.modelassert.json.dsl.nodespecific.Sizeable;

public interface ObjectNodeDsl<A>
extends Satisfies<A>,
Sizeable<A> {
    default public A satisfiesObjectCondition(Condition condition) {
        return this.satisfies(new PredicateWrappedCondition("Object", JsonNode::isObject, condition));
    }

    default public A containsKey(String key) {
        return this.satisfiesObjectCondition(new ObjectContainsKeys(key, new String[0]));
    }

    default public A doesNotContainKey(String key) {
        return this.satisfiesObjectCondition(Not.not(new ObjectContainsKeys(key, new String[0])));
    }

    default public A containsKeys(String key, String ... keys) {
        return this.satisfiesObjectCondition(new ObjectContainsKeys(key, keys));
    }

    default public A doesNotContainKeys(String key, String ... keys) {
        return this.satisfiesObjectCondition(Not.not(new ObjectContainsKeys(key, keys)));
    }

    default public A containsKeysExactly(String key, String ... keys) {
        return this.satisfiesObjectCondition(new ObjectContainsKeys(true, key, keys));
    }

    default public A containsKeysExactlyInAnyOrder(String key, String ... keys) {
        return this.satisfiesObjectCondition(new HasSize(1 + keys.length).and(new ObjectContainsKeys(key, keys)));
    }
}

