/*
 * Decompiled with CFR 0.152.
 */
package us.bryon.graphviz.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.components.io.filemappers.FileExtensionMapper;
import org.codehaus.plexus.components.io.filemappers.FileMapper;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;

public abstract class AbstractDotMojo
extends AbstractMojo {
    protected String excludes;
    protected String layout;
    protected String output;
    protected File destdir;
    protected String dot;
    protected FileMapper mapper;

    protected abstract File getBasedir();

    protected abstract String getIncludes();

    protected File transformInputFile(File input) throws MojoExecutionException {
        return input;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            List filenames = FileUtils.getFileNames((File)this.getBasedir(), (String)this.getIncludes(), (String)this.excludes, (boolean)false);
            FileExtensionMapper mapper = this.mapper == null ? this.createDefaultMapper() : this.mapper;
            for (String filename : filenames) {
                File from = new File(this.getBasedir(), filename);
                File to = new File(this.destdir, mapper.getMappedFileName(filename));
                this.getLog().debug((CharSequence)String.format("converting %s to %s", from, to));
                to.getParentFile().mkdirs();
                Commandline cli = new Commandline();
                cli.setExecutable(this.dot);
                cli.addArguments(new String[]{String.format("-K%s", this.layout), String.format("-T%s", this.output), this.transformInputFile(from).getAbsolutePath()});
                try {
                    Process process = cli.execute();
                    IOUtil.copy((InputStream)process.getInputStream(), (OutputStream)new FileOutputStream(to));
                }
                catch (CommandLineException e) {
                    throw new MojoExecutionException("error performing conversion", (Exception)((Object)e));
                    return;
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("error finding files from %s (includes = %s, excludes = %s)", this.getBasedir(), this.getIncludes(), this.excludes), (Exception)e);
        }
    }

    protected FileExtensionMapper createDefaultMapper() {
        FileExtensionMapper fileExtensionMapper = new FileExtensionMapper();
        fileExtensionMapper.setTargetExtension(this.output);
        return fileExtensionMapper;
    }
}

