/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.datasource;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.string.StringFormat;

abstract class AbstractDatabaseConnectionSource
implements DatabaseConnectionSource {
    private static final Logger LOGGER = Logger.getLogger(AbstractDatabaseConnectionSource.class.getName());
    protected Consumer<Connection> connectionInitializer = connection -> {};

    protected static Properties createConnectionProperties(String connectionUrl, Map<String, String> connectionProperties, String user, String password) {
        Properties jdbcConnectionProperties;
        List<String> skipProperties = Arrays.asList("server", "host", "port", "database", "urlx", "user", "password", "url");
        try {
            Driver jdbcDriver = AbstractDatabaseConnectionSource.getJdbcDriver(connectionUrl);
            DriverPropertyInfo[] propertyInfo = jdbcDriver.getPropertyInfo(connectionUrl, new Properties());
            HashMap<String, Boolean> jdbcDriverProperties = new HashMap<String, Boolean>();
            for (DriverPropertyInfo driverPropertyInfo : propertyInfo) {
                String jdbcPropertyName = driverPropertyInfo.name.toLowerCase();
                if (skipProperties.contains(jdbcPropertyName)) continue;
                jdbcDriverProperties.put(jdbcPropertyName, driverPropertyInfo.required);
            }
            jdbcConnectionProperties = new Properties();
            if (user != null) {
                jdbcConnectionProperties.put("user", user);
            }
            if (password != null) {
                jdbcConnectionProperties.put("password", password);
            }
            if (connectionProperties != null) {
                for (Map.Entry entry : connectionProperties.entrySet()) {
                    String property = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (!jdbcDriverProperties.containsKey(property.toLowerCase()) || value == null) continue;
                    jdbcConnectionProperties.put(property, value);
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not get connection properties", e);
        }
        return jdbcConnectionProperties;
    }

    protected static Connection getConnection(String connectionUrl, Properties jdbcConnectionProperties, Consumer<Connection> connectionInitializer) {
        String user = jdbcConnectionProperties.getProperty("user");
        String username = user != null ? String.format("user '%s'", user) : "unspecified user";
        try {
            LOGGER.log(Level.INFO, new StringFormat("Making connection to %s%nfor user '%s', with properties %s", connectionUrl, username, AbstractDatabaseConnectionSource.safeProperties(jdbcConnectionProperties)));
            Driver driver = AbstractDatabaseConnectionSource.getJdbcDriver(connectionUrl);
            Connection connection = driver.connect(connectionUrl, jdbcConnectionProperties);
            LOGGER.log(Level.INFO, new StringFormat("Opened database connection <%s>", connection));
            connectionInitializer.accept(connection);
            return connection;
        }
        catch (SQLException e) {
            throw new RuntimeException(String.format("Could not connect to <%s>, for <%s>, with properties <%s>", connectionUrl, username, AbstractDatabaseConnectionSource.safeProperties(jdbcConnectionProperties)), e);
        }
    }

    private static Driver getJdbcDriver(String connectionUrl) throws SQLException {
        try {
            return DriverManager.getDriver(connectionUrl);
        }
        catch (SQLException e) {
            throw new SQLException(String.format("Could not find a suitable JDBC driver for database connection URL <%s>", connectionUrl), e);
        }
    }

    private static Properties safeProperties(Properties properties) {
        Properties logProperties = new Properties(properties);
        logProperties.remove("password");
        return logProperties;
    }

    @Override
    public void setConnectionInitializer(Consumer<Connection> connectionInitializer) {
        this.connectionInitializer = connectionInitializer == null ? connection -> {} : connectionInitializer;
    }
}

