/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.regex.Pattern;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.DependantObject;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Schema;
import schemacrawler.schemacrawler.IdentifierQuotingStrategy;
import schemacrawler.schemacrawler.IdentifiersBuilder;
import schemacrawler.schemacrawler.Options;
import us.fatehi.utility.Utility;

public final class Identifiers
implements Options,
Serializable {
    private static final long serialVersionUID = -5108721215361312979L;
    public static final Identifiers STANDARD = IdentifiersBuilder.builder().toOptions();
    private static final Pattern isAllNumeric = Pattern.compile("^\\p{Nd}*$");
    private static final Pattern isIdentifier = Pattern.compile("^[\\p{Nd}\\p{L}\\p{M}_]*$");
    private final String identifierQuoteString;
    private final IdentifierQuotingStrategy identifierQuotingStrategy;
    private final boolean quoteMixedCaseIdentifiers;
    private final Collection<String> reservedWords;

    private static boolean isIdentifier(String name) {
        if (Utility.isBlank(name)) {
            return false;
        }
        return isIdentifier.matcher(name).matches() && !isAllNumeric.matcher(name).matches();
    }

    Identifiers(IdentifiersBuilder builder) {
        this.identifierQuoteString = builder.isIdentifierQuoteStringSet() ? builder.identifierQuoteString : "\"";
        this.identifierQuotingStrategy = builder.identifierQuotingStrategy;
        this.quoteMixedCaseIdentifiers = builder.quoteMixedCaseIdentifiers;
        this.reservedWords = builder.reservedWords;
    }

    public String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    public IdentifierQuotingStrategy getIdentifierQuotingStrategy() {
        return this.identifierQuotingStrategy;
    }

    public Collection<String> getReservedWords() {
        return new HashSet<String>(this.reservedWords);
    }

    public boolean isQuotedName(String name) {
        if (Utility.isBlank(name) || this.identifierQuoteString.isEmpty() || this.identifierQuotingStrategy == IdentifierQuotingStrategy.quote_none) {
            return false;
        }
        int quoteLength = this.identifierQuoteString.length();
        return name.startsWith(this.identifierQuoteString) && name.endsWith(this.identifierQuoteString) && name.length() >= quoteLength * 2;
    }

    public boolean isQuoteMixedCaseIdentifiers() {
        return this.quoteMixedCaseIdentifiers;
    }

    public boolean isReservedWord(String word) {
        return !Utility.isBlank(word) && this.reservedWords.contains(word.trim().toUpperCase());
    }

    public boolean isToBeQuoted(String name) {
        if (name == null || name.isEmpty() || this.isQuotedName(name)) {
            return false;
        }
        switch (this.identifierQuotingStrategy) {
            case quote_none: {
                return false;
            }
            case quote_all: {
                return true;
            }
            case quote_if_special_characters: {
                return !Identifiers.isIdentifier(name) || this.isMixedCase(name);
            }
        }
        return !Identifiers.isIdentifier(name) || this.isMixedCase(name) || this.isReservedWord(name);
    }

    public String quoteFullName(DatabaseObject databaseObject) {
        StringBuilder buffer = new StringBuilder(512);
        this.quoteFullName(buffer, databaseObject);
        return buffer.toString();
    }

    public <P extends DatabaseObject> String quoteFullName(DependantObject<P> dependantObject) {
        if (dependantObject == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(512);
        this.quoteFullName(buffer, (DatabaseObject)dependantObject.getParent(), dependantObject.getName());
        return buffer.toString();
    }

    public String quoteFullName(Schema schema) {
        StringBuilder buffer = new StringBuilder(512);
        this.quoteFullName(buffer, schema);
        return buffer.toString();
    }

    public String quoteName(NamedObject namedObject) {
        if (namedObject == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(512);
        this.quoteName(buffer, namedObject.getName());
        return buffer.toString();
    }

    public String quoteName(String name) {
        StringBuilder buffer = new StringBuilder(512);
        this.quoteName(buffer, name);
        return buffer.toString();
    }

    public <P extends DatabaseObject> String quoteShortName(DependantObject<P> dependantObject) {
        String parentName;
        if (dependantObject == null) {
            return "";
        }
        DatabaseObject parent = (DatabaseObject)dependantObject.getParent();
        StringBuilder buffer = new StringBuilder(64);
        if (parent != null && !Utility.isBlank(parentName = parent.getName())) {
            this.quoteName(buffer, parentName);
            buffer.append('.');
        }
        this.quoteName(buffer, dependantObject.getName());
        return buffer.toString();
    }

    public String unquoteName(String name) {
        if (this.isQuotedName(name)) {
            int quoteLength = this.identifierQuoteString.length();
            return name.substring(quoteLength, name.length() - quoteLength);
        }
        return name;
    }

    private boolean isMixedCase(String name) {
        if (!this.quoteMixedCaseIdentifiers) {
            return false;
        }
        if (Utility.isBlank(name)) {
            return false;
        }
        boolean hasUpperCase = false;
        boolean hasLowerCase = false;
        for (int i = 0; i < name.codePointCount(0, name.length()); ++i) {
            int c = name.codePointAt(i);
            if (Character.isUpperCase(c)) {
                hasUpperCase = true;
            } else if (Character.isLowerCase(c)) {
                hasLowerCase = true;
            }
            if (!hasUpperCase || !hasLowerCase) continue;
            return true;
        }
        return false;
    }

    private void quoteFullName(StringBuilder buffer, DatabaseObject databaseObject) {
        Objects.requireNonNull(buffer, "No buffer provided");
        if (databaseObject == null) {
            return;
        }
        Schema schema = databaseObject.getSchema();
        String name = databaseObject.getName();
        this.quoteFullName(buffer, schema);
        if (!Utility.isBlank(name)) {
            if (buffer.length() > 0) {
                buffer.append('.');
            }
            this.quoteName(buffer, name);
        }
    }

    private void quoteFullName(StringBuilder buffer, DatabaseObject parent, String name) {
        Objects.requireNonNull(buffer, "No buffer provided");
        this.quoteFullName(buffer, parent);
        if (!Utility.isBlank(name)) {
            if (buffer.length() > 0) {
                buffer.append('.');
            }
            this.quoteName(buffer, name);
        }
    }

    private void quoteFullName(StringBuilder buffer, Schema schema) {
        boolean hasSchemaName;
        Objects.requireNonNull(buffer, "No buffer provided");
        if (schema == null) {
            return;
        }
        String catalogName = schema.getCatalogName();
        String schemaName = schema.getName();
        boolean hasCatalogName = !Utility.isBlank(catalogName);
        boolean bl = hasSchemaName = !Utility.isBlank(schemaName);
        if (hasCatalogName) {
            this.quoteName(buffer, catalogName);
        }
        if (hasCatalogName && hasSchemaName) {
            buffer.append(".");
        }
        if (hasSchemaName) {
            this.quoteName(buffer, schemaName);
        }
    }

    private void quoteName(StringBuilder buffer, String name) {
        Objects.requireNonNull(buffer, "No buffer provided");
        if (Utility.isBlank(name)) {
            return;
        }
        if (this.isToBeQuoted(name)) {
            buffer.append(this.identifierQuoteString).append(name).append(this.identifierQuoteString);
        } else {
            buffer.append(name);
        }
    }
}

