/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.text.diagram;

import java.nio.file.Path;
import java.util.Objects;
import schemacrawler.schemacrawler.exceptions.IORuntimeException;
import schemacrawler.tools.command.text.diagram.GraphExecutor;
import schemacrawler.tools.command.text.diagram.options.DiagramOutputFormat;
import us.fatehi.utility.IOUtility;

abstract class AbstractGraphProcessExecutor
implements GraphExecutor {
    protected final Path dotFile;
    protected final Path outputFile;
    protected final DiagramOutputFormat diagramOutputFormat;

    protected AbstractGraphProcessExecutor(Path dotFile, Path outputFile, DiagramOutputFormat diagramOutputFormat) {
        Objects.requireNonNull(dotFile, "No DOT file provided");
        Objects.requireNonNull(outputFile, "No diagram output file provided");
        Objects.requireNonNull(diagramOutputFormat, "No diagram output format provided");
        this.dotFile = dotFile.normalize().toAbsolutePath();
        this.outputFile = outputFile.normalize().toAbsolutePath();
        this.diagramOutputFormat = diagramOutputFormat;
        if (!IOUtility.isFileReadable(this.dotFile)) {
            throw new IORuntimeException(String.format("Cannot read DOT file <%s>", this.dotFile));
        }
        if (!IOUtility.isFileWritable(this.outputFile)) {
            throw new IORuntimeException(String.format("Cannot write output file <%s>", this.outputFile));
        }
    }
}

