/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import us.fatehi.utility.PropertiesUtility;
import us.fatehi.utility.Utility;

public final class TemplatingUtility {
    private static final String DELIMITER_END = "}";
    private static final int DELIMITER_END_LENGTH = "}".length();
    private static final String DELIMITER_START = "${";
    private static final int DELIMITER_START_LENGTH = "${".length();

    public static String expandTemplate(String template) {
        return TemplatingUtility.expandTemplate(template, PropertiesUtility.propertiesMap(System.getProperties()));
    }

    public static String expandTemplate(String template, Map<String, String> variablesMap) {
        if (Utility.isBlank(template) || variablesMap == null) {
            return template;
        }
        StringBuilder buffer = new StringBuilder(template.length());
        int currentPosition = 0;
        while (true) {
            int delimiterStartPosition;
            if ((delimiterStartPosition = template.indexOf(DELIMITER_START, currentPosition)) == -1) {
                if (currentPosition == 0) {
                    return template;
                }
                buffer.append(template.substring(currentPosition));
                return buffer.toString();
            }
            buffer.append(template, currentPosition, delimiterStartPosition);
            int delimiterEndPosition = template.indexOf(DELIMITER_END, delimiterStartPosition);
            if (delimiterEndPosition > -1) {
                String key = Utility.trimToEmpty(template.substring(delimiterStartPosition += DELIMITER_START_LENGTH, delimiterEndPosition));
                String value = variablesMap.get(key);
                if (value != null) {
                    buffer.append(value);
                } else {
                    buffer.append(DELIMITER_START).append(template.substring(delimiterStartPosition, delimiterEndPosition)).append(DELIMITER_END);
                }
                currentPosition = delimiterEndPosition + DELIMITER_END_LENGTH;
                continue;
            }
            buffer.append(DELIMITER_START);
            currentPosition = delimiterStartPosition + DELIMITER_START_LENGTH;
        }
    }

    public static Set<String> extractTemplateVariables(String template) {
        int right;
        int left;
        if (Utility.isBlank(template)) {
            return Collections.emptySet();
        }
        String shrunkTemplate = template;
        HashSet<String> keys = new HashSet<String>();
        while ((left = shrunkTemplate.indexOf(DELIMITER_START)) >= 0 && (right = shrunkTemplate.indexOf(DELIMITER_END, left + 2)) >= 0) {
            String propertyKey = Utility.trimToEmpty(shrunkTemplate.substring(left + 2, right));
            keys.add(propertyKey);
            shrunkTemplate = shrunkTemplate.substring(0, left) + shrunkTemplate.substring(right + 1);
        }
        return keys;
    }

    public static void substituteVariables(Map<String, String> variablesMap) {
        if (variablesMap != null && !variablesMap.isEmpty()) {
            for (Map.Entry<String, String> entry : variablesMap.entrySet()) {
                variablesMap.put(entry.getKey(), TemplatingUtility.expandTemplate(entry.getValue(), variablesMap));
            }
        }
    }

    private TemplatingUtility() {
    }
}

