/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.runpaper.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.jpenilla.runpaper.Constants;
import xyz.jpenilla.runpaper.paperapi.BuildResponse;
import xyz.jpenilla.runpaper.paperapi.Download;
import xyz.jpenilla.runpaper.paperapi.DownloadsAPI;
import xyz.jpenilla.runpaper.service.PaperclipService;
import xyz.jpenilla.runpaper.service.PaperclipServiceImpl;
import xyz.jpenilla.runpaper.util.Downloader;
import xyz.jpenilla.runpaper.util.DurationsKt;
import xyz.jpenilla.runpaper.util.File_hashingKt;
import xyz.jpenilla.runpaper.util.FilesKt;
import xyz.jpenilla.runpaper.util.InvalidDurationException;
import xyz.jpenilla.runpaper.util.LoggingDownloadListener;
import xyz.jpenilla.runpaper.util.ProgressLoggerUtil;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b \u0018\u0000 /2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0005/0123B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0013H\u0002J\u0018\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\tH\u0002J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\tH\u0002J \u0010\"\u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020#2\u0006\u0010!\u001a\u00020$H\u0002J\u0010\u0010(\u001a\u00020#2\u0006\u0010!\u001a\u00020$H\u0002J \u0010)\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\t2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010!\u001a\u00020\tH\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010.\u001a\u00020\u0016H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lxyz/jpenilla/runpaper/service/PaperclipServiceImpl;", "Lorg/gradle/api/services/BuildService;", "Lxyz/jpenilla/runpaper/service/PaperclipServiceImpl$Parameters;", "Ljava/lang/AutoCloseable;", "Lxyz/jpenilla/runpaper/service/PaperclipService;", "()V", "api", "Lxyz/jpenilla/runpaper/paperapi/DownloadsAPI;", "displayName", "", "getDisplayName", "()Ljava/lang/String;", "mapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "paperclips", "Ljava/nio/file/Path;", "getPaperclips", "()Ljava/nio/file/Path;", "versions", "Lxyz/jpenilla/runpaper/service/PaperclipServiceImpl$Versions;", "versionsFile", "cleanLocalCache", "", "close", "createDownloadListener", "Lxyz/jpenilla/runpaper/util/Downloader$ProgressListener;", "project", "Lorg/gradle/api/Project;", "loadOrCreateVersions", "logExpectedActual", "expected", "actual", "paperclipsFor", "minecraftVersion", "resolveBuildNumber", "", "Lxyz/jpenilla/runpaper/service/PaperclipServiceImpl$Version;", "paperBuild", "Lxyz/jpenilla/runpaper/service/PaperclipService$Build;", "resolveLatestLocalBuild", "resolveLatestRemoteBuild", "resolvePaperclip", "unknownMinecraftVersion", "", "updateCheckFrequency", "Ljava/time/Duration;", "writeVersions", "Companion", "PaperclipJar", "Parameters", "Version", "Versions", "run-paper"})
public abstract class PaperclipServiceImpl
implements BuildService<Parameters>,
AutoCloseable,
PaperclipService {
    private final DownloadsAPI api;
    private final JsonMapper mapper;
    private final Path versionsFile;
    private Versions versions;
    private static final Logger LOGGER;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    private final void cleanLocalCache() {
        int perVersionCacheSize = 5;
        Object object = this.versions.getVersions();
        Iterator<Map.Entry<String, Version>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            String $this$filterNotTo$iv$iv;
            Map.Entry<String, Version> entry;
            Map.Entry<String, Version> entry2 = entry = iterator.next();
            object = entry2.getKey();
            entry2 = entry;
            Version version2 = entry2.getValue();
            Map<Integer, PaperclipJar> $this$filterNot$iv = version2.getKnownJars();
            boolean $i$f$filterNot2 = false;
            Map<Integer, PaperclipJar> map = $this$filterNot$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterNotTo = false;
            Iterator iterator2 = $this$filterNotTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator2.next();
                boolean bl = false;
                if (((PaperclipJar)it.getValue()).getKeep()) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map jars = MapsKt.toMutableMap((Map)destination$iv$iv);
            if (jars.isEmpty()) continue;
            while (jars.size() > perVersionCacheSize) {
                PaperclipJar removed;
                void versionName;
                Integer n = (Integer)CollectionsKt.minOrNull((Iterable)jars.keySet());
                if (n == null) {
                    String $i$f$filterNot2 = "Could not determine oldest build.";
                    throw new IllegalStateException($i$f$filterNot2.toString());
                }
                int oldestBuild = n;
                if ((PaperclipJar)jars.remove(oldestBuild) == null) {
                    $this$filterNotTo$iv$iv = "Build does not exist?";
                    throw new IllegalStateException($this$filterNotTo$iv$iv.toString());
                }
                version2.getKnownJars().remove(oldestBuild);
                Path oldPaperclipFile = this.paperclipsFor((String)versionName).resolve(removed.getFileName());
                try {
                    Intrinsics.checkNotNullExpressionValue((Object)oldPaperclipFile, (String)"oldPaperclipFile");
                    Files.deleteIfExists((Path)((Object)destination$iv$iv));
                }
                catch (IOException ex) {
                    Path path;
                    Intrinsics.checkNotNullExpressionValue((Object)oldPaperclipFile, (String)"oldPaperclipFile");
                    LOGGER.warn("Failed to delete Paperclip at {}", (Object)((Object)path.toAbsolutePath()).toString(), (Object)ex);
                }
                this.writeVersions();
            }
        }
    }

    private final Path paperclipsFor(String minecraftVersion) {
        Path path = this.getPaperclips().resolve(minecraftVersion);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"paperclips.resolve(minecraftVersion)");
        return path;
    }

    private final String getDisplayName() {
        Object object = ((Parameters)this.getParameters()).getDownloadProjectDisplayName().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.downloadProjectDisplayName.get()");
        return (String)object;
    }

    private final Path getPaperclips() {
        Path path = FilesKt.getPath((FileSystemLocationProperty)((Parameters)this.getParameters()).getCacheDirectory()).resolve("paperclips");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"parameters.cacheDirector\u2026ath.resolve(\"paperclips\")");
        return path;
    }

    @Override
    @NotNull
    public synchronized Path resolvePaperclip(@NotNull Project project, @NotNull String minecraftVersion, @NotNull PaperclipService.Build paperBuild) {
        Path paperclipsDir;
        Downloader.Result downloadResult;
        Object object;
        Object localPaperclip;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)minecraftVersion, (String)"minecraftVersion");
        Intrinsics.checkNotNullParameter((Object)paperBuild, (String)"paperBuild");
        this.versions = this.loadOrCreateVersions();
        Version version2 = this.versions.getVersions().computeIfAbsent(minecraftVersion, resolvePaperclip.version.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)version2, (String)"versions.versions.comput\u2026tVersion) { Version(it) }");
        Version version3 = version2;
        int build = this.resolveBuildNumber(project, version3, paperBuild);
        PaperclipJar possible = version3.getKnownJars().get(build);
        if (possible != null && !((Boolean)((Parameters)this.getParameters()).getRefreshDependencies().get()).booleanValue()) {
            LOGGER.lifecycle("Located {} {} build {} in local cache.", new Object[]{this.getDisplayName(), minecraftVersion, build});
            Object object2 = localPaperclip = this.paperclipsFor(minecraftVersion).resolve(possible.getFileName());
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"localPaperclip");
            String localBuildHash = File_hashingKt.sha256((Path)object2);
            if (Intrinsics.areEqual((Object)localBuildHash, (Object)possible.getSha256())) {
                if (paperBuild instanceof PaperclipService.Build.Specific) {
                    version3.getKnownJars().put(build, PaperclipJar.copy$default(possible, 0, null, null, true, 7, null));
                    this.writeVersions();
                }
                return localPaperclip;
            }
            version3.getKnownJars().remove(build);
            this.writeVersions();
            object = localPaperclip;
            Files.deleteIfExists((Path)object);
            LOGGER.lifecycle("Invalid SHA256 hash for locally cached {} {} build {}, invalidating and attempting to re-download.", new Object[]{this.getDisplayName(), minecraftVersion, build});
            this.logExpectedActual(possible.getSha256(), localBuildHash);
        }
        Object object3 = ((Parameters)this.getParameters()).getOfflineMode().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"parameters.offlineMode.get()");
        if (((Boolean)object3).booleanValue()) {
            localPaperclip = "Offline mode is enabled and Run Paper could not locate a locally cached build.";
            throw new IllegalStateException(localPaperclip.toString());
        }
        LOGGER.lifecycle("Downloading {} {} build {}...", new Object[]{this.getDisplayName(), minecraftVersion, build});
        Object object4 = ((Parameters)this.getParameters()).getDownloadProject().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"parameters.downloadProject.get()");
        BuildResponse buildResponse = this.api.build((String)object4, minecraftVersion, build);
        Download download2 = buildResponse.getDownloads().get("application");
        if (download2 == null) {
            object = "Could not find download.";
            throw new IllegalStateException(object.toString());
        }
        Download download3 = download2;
        Object object5 = ((Parameters)this.getParameters()).getDownloadProject().get();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"parameters.downloadProject.get()");
        String downloadLink = this.api.downloadURL((String)object5, minecraftVersion, build, download3);
        URL downloadURL = new URL(downloadLink);
        String string = "runpaper";
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path = Files.createTempDirectory(string, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(prefix, *attributes)");
        Path tempFile = path.resolve("paperclip-" + minecraftVersion + '-' + build + '-' + System.currentTimeMillis() + ".jar.tmp");
        long start = System.currentTimeMillis();
        Path path2 = tempFile;
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"tempFile");
        Downloader.Result result = downloadResult = new Downloader(downloadURL, path2).download(this.createDownloadListener(project));
        if (result instanceof Downloader.Result.Success) {
            Object[] objectArray = new Object[2];
            objectArray[0] = this.getDisplayName();
            Duration duration = Duration.ofMillis(System.currentTimeMillis() - start);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.ofMillis(System\u2026rentTimeMillis() - start)");
            objectArray[1] = DurationsKt.prettyPrint(duration);
            LOGGER.lifecycle("Done downloading {}, took {}.", objectArray);
        } else if (result instanceof Downloader.Result.Failure) {
            throw (Throwable)new IllegalStateException("Failed to download " + this.getDisplayName() + '.', ((Downloader.Result.Failure)downloadResult).getThrowable());
        }
        String downloadedFileHash = File_hashingKt.sha256(tempFile);
        if (Intrinsics.areEqual((Object)downloadedFileHash, (Object)download3.getSha256()) ^ true) {
            Object object6 = tempFile;
            Files.deleteIfExists((Path)object6);
            LOGGER.lifecycle("Invalid SHA256 hash for downloaded file: '{}', deleting.", new Object[]{download3.getName()});
            this.logExpectedActual(download3.getSha256(), downloadedFileHash);
            object6 = "Failed to verify SHA256 hash of downloaded file.";
            throw new IllegalStateException(object6.toString());
        }
        LOGGER.lifecycle("Verified SHA256 hash of downloaded jar.");
        Path path3 = paperclipsDir = this.paperclipsFor(minecraftVersion);
        FileAttribute[] fileAttributeArray2 = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path3, Arrays.copyOf(fileAttributeArray2, fileAttributeArray2.length)), (String)"createDirectories(this, *attributes)");
        String fileName = "paperclip-" + minecraftVersion + '-' + build + ".jar";
        Path destination = paperclipsDir.resolve(fileName);
        Path path4 = tempFile;
        Path path5 = destination;
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"destination");
        Path path6 = path5;
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Intrinsics.checkNotNullExpressionValue((Object)Files.move(path4, path6, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"move(this, target, *options)");
        version3.getKnownJars().put(build, new PaperclipJar(build, fileName, download3.getSha256(), paperBuild instanceof PaperclipService.Build.Specific));
        this.writeVersions();
        return destination;
    }

    private final int resolveBuildNumber(Project project, Version minecraftVersion, PaperclipService.Build paperBuild) {
        if (paperBuild instanceof PaperclipService.Build.Specific) {
            return ((PaperclipService.Build.Specific)paperBuild).getBuildNumber();
        }
        Object object = ((Parameters)this.getParameters()).getOfflineMode().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.offlineMode.get()");
        if (((Boolean)object).booleanValue()) {
            LOGGER.lifecycle("Offline mode enabled, attempting to use latest local build of {} for Minecraft {}.", new Object[]{this.getDisplayName(), minecraftVersion});
            return this.resolveLatestLocalBuild(minecraftVersion);
        }
        if (!((Boolean)((Parameters)this.getParameters()).getRefreshDependencies().get()).booleanValue()) {
            Duration checkFrequency = this.updateCheckFrequency(project);
            long timeSinceLastCheck = System.currentTimeMillis() - minecraftVersion.getLastUpdateCheck();
            if (timeSinceLastCheck <= checkFrequency.toMillis()) {
                return this.resolveLatestLocalBuild(minecraftVersion);
            }
        }
        return this.resolveLatestRemoteBuild(minecraftVersion);
    }

    private final int resolveLatestLocalBuild(Version minecraftVersion) {
        Integer n = (Integer)CollectionsKt.maxOrNull((Iterable)minecraftVersion.getKnownJars().keySet());
        if (n == null) {
            Void void_ = this.unknownMinecraftVersion(minecraftVersion.getName());
            throw new KotlinNothingValueException();
        }
        return n;
    }

    private final int resolveLatestRemoteBuild(Version minecraftVersion) {
        int n;
        try {
            LOGGER.lifecycle("Fetching {} builds for Minecraft {}...", new Object[]{this.getDisplayName(), minecraftVersion.getName()});
            Object object = ((Parameters)this.getParameters()).getDownloadProject().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.downloadProject.get()");
            Object object2 = CollectionsKt.last(this.api.version((String)object, minecraftVersion.getName()).getBuilds());
            int $this$apply = ((Number)object2).intValue();
            boolean bl = false;
            LOGGER.lifecycle("Latest build for {} is {}.", new Object[]{minecraftVersion.getName(), $this$apply});
            this.versions.getVersions().put(minecraftVersion.getName(), Version.copy$default(minecraftVersion, null, System.currentTimeMillis(), null, 5, null));
            this.writeVersions();
            n = ((Number)object2).intValue();
        }
        catch (Exception ex) {
            LOGGER.lifecycle("Failed to check for latest release, attempting to use latest local build.");
            n = this.resolveLatestLocalBuild(minecraftVersion);
        }
        return n;
    }

    private final Downloader.ProgressListener createDownloadListener(Project project) {
        ProgressLoggerUtil.ProgressLoggerWrapper progressLogger = ProgressLoggerUtil.INSTANCE.createProgressLogger(project, "RunPaper");
        return progressLogger != null ? (Downloader.ProgressListener)new LoggingDownloadListener<ProgressLoggerUtil.ProgressLoggerWrapper>(progressLogger, (Function2)new Function2<ProgressLoggerUtil.ProgressLoggerWrapper, String, Unit>(this){
            final /* synthetic */ PaperclipServiceImpl this$0;

            public final void invoke(@NotNull ProgressLoggerUtil.ProgressLoggerWrapper state, @NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                state.start("Downloading " + PaperclipServiceImpl.access$getDisplayName$p(this.this$0), message);
            }
            {
                this.this$0 = paperclipServiceImpl;
                super(2);
            }
        }, createDownloadListener.2.INSTANCE, createDownloadListener.3.INSTANCE, "Downloading Paperclip: ", 10L) : (Downloader.ProgressListener)new LoggingDownloadListener(LOGGER, null, createDownloadListener.4.INSTANCE, null, "Downloading Paperclip: ", 1000L, 10, null);
    }

    private final void logExpectedActual(String expected, String actual) {
        LOGGER.lifecycle(" > Expected: {}", new Object[]{expected});
        LOGGER.lifecycle(" > Actual: {}", new Object[]{actual});
    }

    private final Duration updateCheckFrequency(Project project) {
        Duration duration;
        Object object;
        Object $this$run = object = project.findProperty(Constants.Properties.INSTANCE.getUPDATE_CHECK_FREQUENCY());
        boolean bl = false;
        if ($this$run == null) {
            Duration duration2 = Duration.ofHours(1L);
            duration = duration2;
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"Duration.ofHours(1)");
        } else {
            Duration duration3;
            try {
                duration3 = DurationsKt.parseDuration((String)$this$run);
            }
            catch (InvalidDurationException ex) {
                throw (Throwable)new InvalidUserDataException("Unable to parse value for property '" + Constants.Properties.INSTANCE.getUPDATE_CHECK_FREQUENCY() + "'.\n" + ex.getMessage(), (Throwable)ex);
            }
            duration = duration3;
        }
        return duration;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Versions loadOrCreateVersions() {
        Versions versions;
        Object object = this.versionsFile;
        Object object2 = new LinkOption[0];
        if (!Files.isRegularFile((Path)object, Arrays.copyOf(object2, ((LinkOption[])object2).length))) {
            versions = new Versions(null, 1, null);
        } else {
            object = this.versionsFile;
            OpenOption[] openOptionArray = new OpenOption[]{};
            object2 = Charsets.UTF_8;
            int n = 8192;
            object = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object2), n);
            object2 = null;
            try {
                BufferedReader reader = (BufferedReader)object;
                boolean bl = false;
                ObjectMapper $this$readValue$iv = (ObjectMapper)this.mapper;
                boolean $i$f$readValue = false;
                boolean $i$f$jacksonTypeRef = false;
                Versions versions2 = (Versions)$this$readValue$iv.readValue((Reader)reader, (TypeReference)new TypeReference<Versions>(){});
                versions = versions2;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }
        return versions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeVersions() {
        Path path = this.versionsFile.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"versionsFile.parent");
        Object object = path;
        Object object2 = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object, Arrays.copyOf(object2, ((FileAttribute[])object2).length)), (String)"createDirectories(this, *attributes)");
        object = this.versionsFile;
        OpenOption[] openOptionArray = new OpenOption[]{};
        object2 = Charsets.UTF_8;
        int n = 8192;
        object = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object2), n);
        object2 = null;
        try {
            BufferedWriter writer = (BufferedWriter)object;
            boolean bl = false;
            this.mapper.writeValue((Writer)writer, (Object)this.versions);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    private final Void unknownMinecraftVersion(String minecraftVersion) {
        String string = "Unknown Minecraft Version: " + minecraftVersion;
        throw new IllegalStateException(string.toString());
    }

    public PaperclipServiceImpl() {
        Object object = ((Parameters)this.getParameters()).getDownloadsEndpoint().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.downloadsEndpoint.get()");
        this.api = new DownloadsAPI((String)object);
        ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT})).addModule((Module)ExtensionsKt.kotlinModule$default(null, (int)1, null))).build();
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"JsonMapper.builder()\n   \u2026linModule())\n    .build()");
        this.mapper = (JsonMapper)objectMapper;
        Provider provider = ((Parameters)this.getParameters()).getCacheDirectory().file("versions.json");
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"parameters.cacheDirectory.file(\"versions.json\")");
        this.versionsFile = FilesKt.getPath((Provider<? extends FileSystemLocation>)provider);
        this.versions = this.loadOrCreateVersions();
        this.cleanLocalCache();
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logging.getLogger(PaperclipServiceImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logging.getLogger(Paperc\u2026pServiceImpl::class.java)");
        LOGGER = logger;
    }

    public static final /* synthetic */ String access$getDisplayName$p(PaperclipServiceImpl $this) {
        return $this.getDisplayName();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\nR\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\n\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0014\u00c0\u0006\u0001"}, d2={"Lxyz/jpenilla/runpaper/service/PaperclipServiceImpl$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "cacheDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getCacheDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "downloadProject", "Lorg/gradle/api/provider/Property;", "", "getDownloadProject", "()Lorg/gradle/api/provider/Property;", "downloadProjectDisplayName", "getDownloadProjectDisplayName", "downloadsEndpoint", "getDownloadsEndpoint", "offlineMode", "", "getOfflineMode", "refreshDependencies", "getRefreshDependencies", "run-paper"})
    public static interface Parameters
    extends BuildServiceParameters {
        @NotNull
        public Property<String> getDownloadsEndpoint();

        @NotNull
        public Property<String> getDownloadProject();

        @NotNull
        public Property<String> getDownloadProjectDisplayName();

        @NotNull
        public DirectoryProperty getCacheDirectory();

        @NotNull
        public Property<Boolean> getRefreshDependencies();

        @NotNull
        public Property<Boolean> getOfflineMode();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0012\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u001a"}, d2={"Lxyz/jpenilla/runpaper/service/PaperclipServiceImpl$PaperclipJar;", "", "buildNumber", "", "fileName", "", "sha256", "keep", "", "(ILjava/lang/String;Ljava/lang/String;Z)V", "getBuildNumber", "()I", "getFileName", "()Ljava/lang/String;", "getKeep", "()Z", "getSha256", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "run-paper"})
    public static final class PaperclipJar {
        private final int buildNumber;
        @NotNull
        private final String fileName;
        @NotNull
        private final String sha256;
        private final boolean keep;

        public final int getBuildNumber() {
            return this.buildNumber;
        }

        @NotNull
        public final String getFileName() {
            return this.fileName;
        }

        @NotNull
        public final String getSha256() {
            return this.sha256;
        }

        public final boolean getKeep() {
            return this.keep;
        }

        public PaperclipJar(int buildNumber, @NotNull String fileName, @NotNull String sha256, boolean keep) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)sha256, (String)"sha256");
            this.buildNumber = buildNumber;
            this.fileName = fileName;
            this.sha256 = sha256;
            this.keep = keep;
        }

        public /* synthetic */ PaperclipJar(int n, String string, String string2, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                bl = false;
            }
            this(n, string, string2, bl);
        }

        public final int component1() {
            return this.buildNumber;
        }

        @NotNull
        public final String component2() {
            return this.fileName;
        }

        @NotNull
        public final String component3() {
            return this.sha256;
        }

        public final boolean component4() {
            return this.keep;
        }

        @NotNull
        public final PaperclipJar copy(int buildNumber, @NotNull String fileName, @NotNull String sha256, boolean keep) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)sha256, (String)"sha256");
            return new PaperclipJar(buildNumber, fileName, sha256, keep);
        }

        public static /* synthetic */ PaperclipJar copy$default(PaperclipJar paperclipJar, int n, String string, String string2, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = paperclipJar.buildNumber;
            }
            if ((n2 & 2) != 0) {
                string = paperclipJar.fileName;
            }
            if ((n2 & 4) != 0) {
                string2 = paperclipJar.sha256;
            }
            if ((n2 & 8) != 0) {
                bl = paperclipJar.keep;
            }
            return paperclipJar.copy(n, string, string2, bl);
        }

        @NotNull
        public String toString() {
            return "PaperclipJar(buildNumber=" + this.buildNumber + ", fileName=" + this.fileName + ", sha256=" + this.sha256 + ", keep=" + this.keep + ")";
        }

        public int hashCode() {
            String string = this.fileName;
            String string2 = this.sha256;
            int n = ((Integer.hashCode(this.buildNumber) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31;
            int n2 = this.keep ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PaperclipJar)) break block3;
                    PaperclipJar paperclipJar = (PaperclipJar)object;
                    if (this.buildNumber != paperclipJar.buildNumber || !Intrinsics.areEqual((Object)this.fileName, (Object)paperclipJar.fileName) || !Intrinsics.areEqual((Object)this.sha256, (Object)paperclipJar.sha256) || this.keep != paperclipJar.keep) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u001f\u0010\n\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lxyz/jpenilla/runpaper/service/PaperclipServiceImpl$Versions;", "", "versions", "", "", "Lxyz/jpenilla/runpaper/service/PaperclipServiceImpl$Version;", "(Ljava/util/Map;)V", "getVersions", "()Ljava/util/Map;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "run-paper"})
    public static final class Versions {
        @NotNull
        private final Map<String, Version> versions;

        @NotNull
        public final Map<String, Version> getVersions() {
            return this.versions;
        }

        public Versions(@NotNull Map<String, Version> versions) {
            Intrinsics.checkNotNullParameter(versions, (String)"versions");
            this.versions = versions;
        }

        public /* synthetic */ Versions(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = new HashMap();
            }
            this(map);
        }

        public Versions() {
            this(null, 1, null);
        }

        @NotNull
        public final Map<String, Version> component1() {
            return this.versions;
        }

        @NotNull
        public final Versions copy(@NotNull Map<String, Version> versions) {
            Intrinsics.checkNotNullParameter(versions, (String)"versions");
            return new Versions(versions);
        }

        public static /* synthetic */ Versions copy$default(Versions versions, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                map = versions.versions;
            }
            return versions.copy(map);
        }

        @NotNull
        public String toString() {
            return "Versions(versions=" + this.versions + ")";
        }

        public int hashCode() {
            Map<String, Version> map = this.versions;
            return map != null ? ((Object)map).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Versions)) break block3;
                    Versions versions = (Versions)object;
                    if (!Intrinsics.areEqual(this.versions, versions.versions)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0003J3\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lxyz/jpenilla/runpaper/service/PaperclipServiceImpl$Version;", "", "name", "", "lastUpdateCheck", "", "knownJars", "", "", "Lxyz/jpenilla/runpaper/service/PaperclipServiceImpl$PaperclipJar;", "(Ljava/lang/String;JLjava/util/Map;)V", "getKnownJars", "()Ljava/util/Map;", "getLastUpdateCheck", "()J", "getName", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "run-paper"})
    public static final class Version {
        @NotNull
        private final String name;
        private final long lastUpdateCheck;
        @NotNull
        private final Map<Integer, PaperclipJar> knownJars;

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final long getLastUpdateCheck() {
            return this.lastUpdateCheck;
        }

        @NotNull
        public final Map<Integer, PaperclipJar> getKnownJars() {
            return this.knownJars;
        }

        public Version(@NotNull String name, long lastUpdateCheck, @NotNull Map<Integer, PaperclipJar> knownJars) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(knownJars, (String)"knownJars");
            this.name = name;
            this.lastUpdateCheck = lastUpdateCheck;
            this.knownJars = knownJars;
        }

        public /* synthetic */ Version(String string, long l, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                l = 0L;
            }
            if ((n & 4) != 0) {
                map = new HashMap();
            }
            this(string, l, map);
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final long component2() {
            return this.lastUpdateCheck;
        }

        @NotNull
        public final Map<Integer, PaperclipJar> component3() {
            return this.knownJars;
        }

        @NotNull
        public final Version copy(@NotNull String name, long lastUpdateCheck, @NotNull Map<Integer, PaperclipJar> knownJars) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(knownJars, (String)"knownJars");
            return new Version(name, lastUpdateCheck, knownJars);
        }

        public static /* synthetic */ Version copy$default(Version version2, String string, long l, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                string = version2.name;
            }
            if ((n & 2) != 0) {
                l = version2.lastUpdateCheck;
            }
            if ((n & 4) != 0) {
                map = version2.knownJars;
            }
            return version2.copy(string, l, map);
        }

        @NotNull
        public String toString() {
            return "Version(name=" + this.name + ", lastUpdateCheck=" + this.lastUpdateCheck + ", knownJars=" + this.knownJars + ")";
        }

        public int hashCode() {
            String string = this.name;
            Map<Integer, PaperclipJar> map = this.knownJars;
            return ((string != null ? string.hashCode() : 0) * 31 + Long.hashCode(this.lastUpdateCheck)) * 31 + (map != null ? ((Object)map).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Version)) break block3;
                    Version version2 = (Version)object;
                    if (!Intrinsics.areEqual((Object)this.name, (Object)version2.name) || this.lastUpdateCheck != version2.lastUpdateCheck || !Intrinsics.areEqual(this.knownJars, version2.knownJars)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lxyz/jpenilla/runpaper/service/PaperclipServiceImpl$Companion;", "", "()V", "LOGGER", "Lorg/gradle/api/logging/Logger;", "run-paper"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

