/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.runpaper.util;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import xyz.jpenilla.runpaper.util.HashingAlgorithm;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\u0004\u001a\u00020\u0003*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\u0004\u001a\u00020\u0003*\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\f\u0010\t\u001a\u00020\u0001*\u00020\bH\u0000\u00a8\u0006\n"}, d2={"toHexString", "", "hash", "", "calculateHash", "Ljava/io/InputStream;", "algorithm", "Lxyz/jpenilla/runpaper/util/HashingAlgorithm;", "Ljava/nio/file/Path;", "sha256", "run-paper"})
public final class File_hashingKt {
    @NotNull
    public static final String sha256(@NotNull Path $this$sha256) {
        Intrinsics.checkNotNullParameter((Object)$this$sha256, (String)"$this$sha256");
        return File_hashingKt.toHexString(File_hashingKt.calculateHash($this$sha256, HashingAlgorithm.SHA256));
    }

    private static final byte[] calculateHash(Path $this$calculateHash, HashingAlgorithm algorithm) {
        InputStream inputStream = Files.newInputStream($this$calculateHash, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"Files.newInputStream(this)");
        return File_hashingKt.calculateHash(inputStream, algorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] calculateHash(InputStream $this$calculateHash, HashingAlgorithm algorithm) {
        Closeable closeable = $this$calculateHash;
        Throwable throwable = null;
        try {
            InputStream inputStream = (InputStream)closeable;
            boolean bl = false;
            DigestInputStream stream = new DigestInputStream(inputStream, algorithm.digest());
            Closeable closeable2 = stream;
            Throwable throwable2 = null;
            try {
                DigestInputStream digestStream = (DigestInputStream)closeable2;
                boolean bl2 = false;
                byte[] buffer = new byte[1024];
                while (digestStream.read(buffer) != -1) {
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            byte[] byArray = stream.getMessageDigest().digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"stream.messageDigest.digest()");
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final String toHexString(byte[] hash) {
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (byte by : hash) {
            String hex = Integer.toHexString(0xFF & by);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        String string = hexString.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"hexString.toString()");
        return string;
    }
}

