/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.runpaper.util;

import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lxyz/jpenilla/runpaper/util/ProgressLoggerUtil;", "", "()V", "createProgressLogger", "Lxyz/jpenilla/runpaper/util/ProgressLoggerUtil$ProgressLoggerWrapper;", "project", "Lorg/gradle/api/Project;", "operationName", "", "ProgressLoggerWrapper", "run-paper"})
public final class ProgressLoggerUtil {
    @NotNull
    public static final ProgressLoggerUtil INSTANCE;

    @Nullable
    public final ProgressLoggerWrapper createProgressLogger(@NotNull Project project, @NotNull String operationName) {
        ProgressLoggerWrapper progressLoggerWrapper;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        try {
            Object serviceFactory = project.getClass().getMethod("getServices", new Class[0]).invoke((Object)project, new Object[0]);
            Method get = serviceFactory.getClass().getMethod("get", Class.class);
            Class<?> progressLoggerFactoryClass = Class.forName("org.gradle.internal.logging.progress.ProgressLoggerFactory");
            Object factory = get.invoke(serviceFactory, progressLoggerFactoryClass);
            Method newOperation = progressLoggerFactoryClass.getMethod("newOperation", String.class);
            Class<?> progressLoggerClass = Class.forName("org.gradle.internal.logging.progress.ProgressLogger");
            Method start = progressLoggerClass.getMethod("start", String.class, String.class);
            Method progress = progressLoggerClass.getMethod("progress", String.class);
            Method completed = progressLoggerClass.getMethod("completed", new Class[0]);
            Object object = newOperation.invoke(factory, operationName);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newOperation(factory, operationName)");
            Method method = start;
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"start");
            Method method2 = progress;
            Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"progress");
            Method method3 = completed;
            Intrinsics.checkNotNullExpressionValue((Object)method3, (String)"completed");
            progressLoggerWrapper = new ProgressLoggerWrapper(object, method, method2, method3);
        }
        catch (ReflectiveOperationException ex) {
            progressLoggerWrapper = null;
        }
        return progressLoggerWrapper;
    }

    private ProgressLoggerUtil() {
    }

    static {
        ProgressLoggerUtil progressLoggerUtil;
        INSTANCE = progressLoggerUtil = new ProgressLoggerUtil();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0006\u001a\u00020\bJ\u000e\u0010\u0005\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0003\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lxyz/jpenilla/runpaper/util/ProgressLoggerUtil$ProgressLoggerWrapper;", "", "logger", "start", "Ljava/lang/reflect/Method;", "progress", "completed", "(Ljava/lang/Object;Ljava/lang/reflect/Method;Ljava/lang/reflect/Method;Ljava/lang/reflect/Method;)V", "", "status", "", "description", "run-paper"})
    public static final class ProgressLoggerWrapper {
        private final Object logger;
        private final Method start;
        private final Method progress;
        private final Method completed;

        public final void start(@NotNull String description, @NotNull String status) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            this.start.invoke(this.logger, description, status);
        }

        public final void progress(@NotNull String status) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            this.progress.invoke(this.logger, status);
        }

        public final void completed() {
            this.completed.invoke(this.logger, new Object[0]);
        }

        public ProgressLoggerWrapper(@NotNull Object logger, @NotNull Method start, @NotNull Method progress, @NotNull Method completed) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
            Intrinsics.checkNotNullParameter((Object)completed, (String)"completed");
            this.logger = logger;
            this.start = start;
            this.progress = progress;
            this.completed = completed;
        }
    }
}

