/*
 * Decompiled with CFR 0.152.
 */
package xyz.urbanmatrix.mavlink.generator;

import com.squareup.kotlinpoet.ClassName;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import xyz.urbanmatrix.mavlink.generator.models.EnumModel;
import xyz.urbanmatrix.mavlink.generator.models.MavlinkModel;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\r\u001a\u00020\u0003H\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0003J\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lxyz/urbanmatrix/mavlink/generator/EnumHelper;", "", "basePackage", "", "mavlinkModels", "", "Lxyz/urbanmatrix/mavlink/generator/models/MavlinkModel;", "(Ljava/lang/String;Ljava/util/List;)V", "nameToModels", "", "Lkotlin/Pair;", "Lxyz/urbanmatrix/mavlink/generator/models/EnumModel;", "getModel", "enumType", "isBitmask", "", "resolveClassName", "Lcom/squareup/kotlinpoet/ClassName;", "resolveModel", "generator"})
public final class EnumHelper {
    @NotNull
    private final String basePackage;
    @NotNull
    private final Map<String, Pair<EnumModel, MavlinkModel>> nameToModels;

    public EnumHelper(@NotNull String basePackage, @NotNull List<MavlinkModel> mavlinkModels) {
        Intrinsics.checkNotNullParameter((Object)basePackage, (String)"basePackage");
        Intrinsics.checkNotNullParameter(mavlinkModels, (String)"mavlinkModels");
        this.basePackage = basePackage;
        this.nameToModels = new LinkedHashMap();
        for (MavlinkModel mavlinkModel : mavlinkModels) {
            for (EnumModel enumModel : mavlinkModel.getEnums()) {
                this.nameToModels.putIfAbsent(enumModel.getName(), (Pair<EnumModel, MavlinkModel>)TuplesKt.to((Object)enumModel, (Object)mavlinkModel));
            }
        }
    }

    @NotNull
    public final EnumModel resolveModel(@NotNull String enumType) {
        Intrinsics.checkNotNullParameter((Object)enumType, (String)"enumType");
        return (EnumModel)this.getModel(enumType).getFirst();
    }

    @NotNull
    public final ClassName resolveClassName(@NotNull String enumType) {
        Pair<EnumModel, MavlinkModel> pair;
        Intrinsics.checkNotNullParameter((Object)enumType, (String)"enumType");
        Pair<EnumModel, MavlinkModel> $this$resolveClassName_u24lambda_u240 = pair = this.getModel(enumType);
        boolean bl = false;
        String[] stringArray = new String[]{((EnumModel)$this$resolveClassName_u24lambda_u240.getFirst()).getFormattedName()};
        return new ClassName(this.basePackage + '.' + ((MavlinkModel)$this$resolveClassName_u24lambda_u240.getSecond()).getSubPackageName(), stringArray);
    }

    public final boolean isBitmask(@NotNull String enumType) {
        Intrinsics.checkNotNullParameter((Object)enumType, (String)"enumType");
        return ((EnumModel)this.getModel(enumType).getFirst()).getBitmask();
    }

    private final Pair<EnumModel, MavlinkModel> getModel(String enumType) {
        Pair<EnumModel, MavlinkModel> pair;
        Pair<EnumModel, MavlinkModel> pair2 = pair = this.nameToModels.get(enumType);
        if (pair2 == null) {
            boolean bl = false;
            String string = enumType + " not defined in available mavlink schema";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return pair2;
    }
}

