/*
 * Decompiled with CFR 0.152.
 */
package xyz.urbanmatrix.mavlink.generator;

import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.MemberName;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import xyz.urbanmatrix.mavlink.api.GeneratedMavField;
import xyz.urbanmatrix.mavlink.api.MavBitmaskValue;
import xyz.urbanmatrix.mavlink.api.MavEnumValue;
import xyz.urbanmatrix.mavlink.generator.CaseFormat;
import xyz.urbanmatrix.mavlink.generator.EnumHelper;
import xyz.urbanmatrix.mavlink.generator.models.FieldModel;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0014\u0010\n\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0014\u0010\u000b\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0014\u0010\f\u001a\u00020\r*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u001c\u0010\u0010\u001a\u00020\u0011*\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0007H\u0002\u001a\u0014\u0010\u0015\u001a\u00020\r*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u001c\u0010\u0016\u001a\u00020\u0011*\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0014\u0010\u0018\u001a\u00020\u0003*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"SERIALIZATION_PACKAGE", "", "resolveKotlinPrimitiveType", "Lcom/squareup/kotlinpoet/TypeName;", "primitiveType", "decodeMethodName", "Lcom/squareup/kotlinpoet/MemberName;", "Lxyz/urbanmatrix/mavlink/generator/models/FieldModel;", "enumHelper", "Lxyz/urbanmatrix/mavlink/generator/EnumHelper;", "defaultKotlinValue", "encodeMethodName", "generateBuilderProperty", "Lcom/squareup/kotlinpoet/PropertySpec;", "generateConstructorParameter", "Lcom/squareup/kotlinpoet/ParameterSpec;", "generateDeserializeStatement", "Lcom/squareup/kotlinpoet/CodeBlock;", "inputName", "generateGeneratedAnnotation", "Lcom/squareup/kotlinpoet/AnnotationSpec;", "generateProperty", "generateSerializeStatement", "outputName", "resolveKotlinType", "generator"})
public final class FieldGenKt {
    @NotNull
    private static final String SERIALIZATION_PACKAGE = "xyz.urbanmatrix.mavlink.serialization";

    @NotNull
    public static final ParameterSpec generateConstructorParameter(@NotNull FieldModel $this$generateConstructorParameter, @NotNull EnumHelper enumHelper) {
        ParameterSpec.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$generateConstructorParameter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)enumHelper, (String)"enumHelper");
        ParameterSpec.Builder $this$generateConstructorParameter_u24lambda_u240 = builder = ParameterSpec.Companion.builder($this$generateConstructorParameter.getFormattedName(), FieldGenKt.resolveKotlinType($this$generateConstructorParameter, enumHelper), new KModifier[0]).defaultValue(FieldGenKt.defaultKotlinValue($this$generateConstructorParameter, enumHelper), new Object[0]);
        boolean bl = false;
        if ($this$generateConstructorParameter.getContent() != null) {
            String string = $this$generateConstructorParameter.getContent();
            Intrinsics.checkNotNull((Object)string);
            $this$generateConstructorParameter_u24lambda_u240.addKdoc(StringsKt.replace$default((String)string, (String)"%", (String)"%%", (boolean)false, (int)4, null), new Object[0]);
        }
        return builder.build();
    }

    @NotNull
    public static final PropertySpec generateProperty(@NotNull FieldModel $this$generateProperty, @NotNull EnumHelper enumHelper) {
        Intrinsics.checkNotNullParameter((Object)$this$generateProperty, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)enumHelper, (String)"enumHelper");
        return PropertySpec.Companion.builder($this$generateProperty.getFormattedName(), FieldGenKt.resolveKotlinType($this$generateProperty, enumHelper), new KModifier[0]).initializer($this$generateProperty.getFormattedName(), new Object[0]).addAnnotation(FieldGenKt.generateGeneratedAnnotation($this$generateProperty)).build();
    }

    @NotNull
    public static final PropertySpec generateBuilderProperty(@NotNull FieldModel $this$generateBuilderProperty, @NotNull EnumHelper enumHelper) {
        Intrinsics.checkNotNullParameter((Object)$this$generateBuilderProperty, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)enumHelper, (String)"enumHelper");
        return PropertySpec.Builder.mutable$default((PropertySpec.Builder)PropertySpec.Companion.builder($this$generateBuilderProperty.getFormattedName(), FieldGenKt.resolveKotlinType($this$generateBuilderProperty, enumHelper), new KModifier[0]), (boolean)false, (int)1, null).initializer(FieldGenKt.defaultKotlinValue($this$generateBuilderProperty, enumHelper), new Object[0]).build();
    }

    private static final AnnotationSpec generateGeneratedAnnotation(FieldModel $this$generateGeneratedAnnotation) {
        Object[] objectArray = new Object[]{$this$generateGeneratedAnnotation.getType()};
        Object[] $this$generateGeneratedAnnotation_u24lambda_u241 = objectArray = AnnotationSpec.Companion.builder(Reflection.getOrCreateKotlinClass(GeneratedMavField.class)).addMember("type = %S", objectArray);
        boolean bl = false;
        if ($this$generateGeneratedAnnotation.getExtension()) {
            Object[] objectArray2 = new Object[]{true};
            $this$generateGeneratedAnnotation_u24lambda_u241.addMember("extension = %L", objectArray2);
        }
        return objectArray.build();
    }

    private static final TypeName resolveKotlinType(FieldModel $this$resolveKotlinType, EnumHelper enumHelper) {
        TypeName typeName;
        FieldModel fieldModel = $this$resolveKotlinType;
        if (fieldModel instanceof FieldModel.Primitive) {
            typeName = FieldGenKt.resolveKotlinPrimitiveType($this$resolveKotlinType.getType());
        } else if (fieldModel instanceof FieldModel.PrimitiveArray) {
            if (Intrinsics.areEqual((Object)((FieldModel.PrimitiveArray)$this$resolveKotlinType).getPrimitiveType(), (Object)"char")) {
                typeName = (TypeName)TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(String.class));
            } else {
                TypeName[] typeNameArray = new TypeName[]{FieldGenKt.resolveKotlinPrimitiveType(((FieldModel.PrimitiveArray)$this$resolveKotlinType).getPrimitiveType())};
                typeName = (TypeName)ParameterizedTypeName.Companion.get(TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(List.class)), typeNameArray);
            }
        } else if (fieldModel instanceof FieldModel.Enum) {
            KClass clazz = enumHelper.isBitmask(((FieldModel.Enum)$this$resolveKotlinType).getEnumType()) ? Reflection.getOrCreateKotlinClass(MavBitmaskValue.class) : Reflection.getOrCreateKotlinClass(MavEnumValue.class);
            TypeName[] typeNameArray = new TypeName[]{(TypeName)enumHelper.resolveClassName(((FieldModel.Enum)$this$resolveKotlinType).getEnumType())};
            typeName = (TypeName)ParameterizedTypeName.Companion.get(TypeNames.get((KClass)clazz), typeNameArray);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return typeName;
    }

    @NotNull
    public static final CodeBlock generateSerializeStatement(@NotNull FieldModel $this$generateSerializeStatement, @NotNull String outputName, @NotNull EnumHelper enumHelper) {
        Intrinsics.checkNotNullParameter((Object)$this$generateSerializeStatement, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)outputName, (String)"outputName");
        Intrinsics.checkNotNullParameter((Object)enumHelper, (String)"enumHelper");
        CodeBlock.Builder encode = CodeBlock.Companion.builder();
        FieldModel fieldModel = $this$generateSerializeStatement;
        if (fieldModel instanceof FieldModel.Enum) {
            Object[] objectArray = new Object[]{FieldGenKt.encodeMethodName($this$generateSerializeStatement, enumHelper)};
            encode.addStatement(outputName + ".%M(" + $this$generateSerializeStatement.getFormattedName() + ".value, " + $this$generateSerializeStatement.getSize() + ')', objectArray);
        } else if (fieldModel instanceof FieldModel.Primitive) {
            Object[] objectArray = new Object[]{FieldGenKt.encodeMethodName($this$generateSerializeStatement, enumHelper)};
            encode.addStatement(outputName + ".%M(" + $this$generateSerializeStatement.getFormattedName() + ')', objectArray);
        } else if (fieldModel instanceof FieldModel.PrimitiveArray) {
            Object[] objectArray = new Object[]{FieldGenKt.encodeMethodName($this$generateSerializeStatement, enumHelper)};
            encode.addStatement(outputName + ".%M(" + $this$generateSerializeStatement.getFormattedName() + ", " + $this$generateSerializeStatement.getSize() + ')', objectArray);
        }
        return encode.build();
    }

    @NotNull
    public static final CodeBlock generateDeserializeStatement(@NotNull FieldModel $this$generateDeserializeStatement, @NotNull String inputName, @NotNull EnumHelper enumHelper) {
        Intrinsics.checkNotNullParameter((Object)$this$generateDeserializeStatement, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)inputName, (String)"inputName");
        Intrinsics.checkNotNullParameter((Object)enumHelper, (String)"enumHelper");
        CodeBlock.Builder decode = CodeBlock.Companion.builder();
        FieldModel fieldModel = $this$generateDeserializeStatement;
        if (fieldModel instanceof FieldModel.Enum) {
            if (enumHelper.isBitmask(((FieldModel.Enum)$this$generateDeserializeStatement).getEnumType())) {
                Object[] objectArray = new Object[]{FieldGenKt.decodeMethodName($this$generateDeserializeStatement, enumHelper)};
                decode.beginControlFlow("val " + $this$generateDeserializeStatement.getFormattedName() + " = " + inputName + ".%M(" + $this$generateDeserializeStatement.getSize() + ").let { value ->", objectArray);
                decode.addStatement("val flags = " + CaseFormat.Companion.fromSnake(((FieldModel.Enum)$this$generateDeserializeStatement).getEnumType()).toUpperCamel() + ".getFlagsFromValue(value)", new Object[0]);
                objectArray = new Object[]{Reflection.getOrCreateKotlinClass(MavBitmaskValue.class)};
                decode.addStatement("if (flags.isNotEmpty()) %1T.of(flags) else %1T.fromValue(value)", objectArray);
                decode.endControlFlow();
            } else {
                Object[] objectArray = new Object[]{FieldGenKt.decodeMethodName($this$generateDeserializeStatement, enumHelper)};
                decode.beginControlFlow("val " + $this$generateDeserializeStatement.getFormattedName() + " = " + inputName + ".%M(" + $this$generateDeserializeStatement.getSize() + ").let { value ->", objectArray);
                decode.addStatement("val entry = " + CaseFormat.Companion.fromSnake(((FieldModel.Enum)$this$generateDeserializeStatement).getEnumType()).toUpperCamel() + ".getEntryFromValueOrNull(value)", new Object[0]);
                objectArray = new Object[]{Reflection.getOrCreateKotlinClass(MavEnumValue.class)};
                decode.addStatement("if (entry != null) %1T.of(entry) else %1T.fromValue(value)", objectArray);
                decode.endControlFlow();
            }
        } else if (fieldModel instanceof FieldModel.Primitive) {
            Object[] objectArray = new Object[]{FieldGenKt.decodeMethodName($this$generateDeserializeStatement, enumHelper)};
            decode.addStatement("val " + $this$generateDeserializeStatement.getFormattedName() + " = " + inputName + ".%M()", objectArray);
        } else if (fieldModel instanceof FieldModel.PrimitiveArray) {
            Object[] objectArray = new Object[]{FieldGenKt.decodeMethodName($this$generateDeserializeStatement, enumHelper)};
            decode.addStatement("val " + $this$generateDeserializeStatement.getFormattedName() + " = " + inputName + ".%M(" + $this$generateDeserializeStatement.getSize() + ')', objectArray);
        }
        return decode.build();
    }

    private static final TypeName resolveKotlinPrimitiveType(String primitiveType) {
        TypeName typeName;
        switch (primitiveType) {
            case "int8_t": {
                typeName = (TypeName)TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(Byte.TYPE));
                break;
            }
            case "uint8_t_mavlink_version": 
            case "uint8_t": {
                typeName = (TypeName)TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(UByte.class));
                break;
            }
            case "int16_t": {
                typeName = (TypeName)TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(Short.TYPE));
                break;
            }
            case "uint16_t": {
                typeName = (TypeName)TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(UShort.class));
                break;
            }
            case "int32_t": {
                typeName = (TypeName)TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(Integer.TYPE));
                break;
            }
            case "uint32_t": {
                typeName = (TypeName)TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(UInt.class));
                break;
            }
            case "int64_t": {
                typeName = (TypeName)TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(Long.TYPE));
                break;
            }
            case "uint64_t": {
                typeName = (TypeName)TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(ULong.class));
                break;
            }
            case "float": {
                typeName = (TypeName)TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(Float.TYPE));
                break;
            }
            case "double": {
                typeName = (TypeName)TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(Double.TYPE));
                break;
            }
            case "char": {
                typeName = (TypeName)TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(Character.TYPE));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown field type: " + primitiveType);
            }
        }
        return typeName;
    }

    private static final String defaultKotlinValue(FieldModel $this$defaultKotlinValue, EnumHelper enumHelper) {
        String string;
        block45: {
            FieldModel fieldModel;
            block43: {
                fieldModel = $this$defaultKotlinValue;
                if (!(fieldModel instanceof FieldModel.Primitive)) break block43;
                switch ($this$defaultKotlinValue.getType()) {
                    case "int8_t": {
                        string = "0";
                        break block45;
                    }
                    case "uint8_t_mavlink_version": 
                    case "uint8_t": {
                        string = "0u";
                        break block45;
                    }
                    case "int16_t": {
                        string = "0";
                        break block45;
                    }
                    case "uint16_t": {
                        string = "0u";
                        break block45;
                    }
                    case "int32_t": {
                        string = "0";
                        break block45;
                    }
                    case "uint32_t": {
                        string = "0u";
                        break block45;
                    }
                    case "int64_t": {
                        string = "0L";
                        break block45;
                    }
                    case "uint64_t": {
                        string = "0uL";
                        break block45;
                    }
                    case "float": {
                        string = "0F";
                        break block45;
                    }
                    case "double": {
                        string = "0.0";
                        break block45;
                    }
                    case "char": {
                        string = "'\\u0000'";
                        break block45;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown field type: " + $this$defaultKotlinValue.getType());
                    }
                }
            }
            if (fieldModel instanceof FieldModel.PrimitiveArray) {
                string = Intrinsics.areEqual((Object)((FieldModel.PrimitiveArray)$this$defaultKotlinValue).getPrimitiveType(), (Object)"char") ? "\"\"" : "emptyList()";
            } else if (fieldModel instanceof FieldModel.Enum) {
                string = enumHelper.isBitmask(((FieldModel.Enum)$this$defaultKotlinValue).getEnumType()) ? Reflection.getOrCreateKotlinClass(MavBitmaskValue.class).getSimpleName() + ".fromValue(0u)" : Reflection.getOrCreateKotlinClass(MavEnumValue.class).getSimpleName() + ".fromValue(0u)";
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private static final MemberName encodeMethodName(FieldModel $this$encodeMethodName, EnumHelper enumHelper) {
        MemberName memberName;
        block77: {
            block80: {
                FieldModel fieldModel;
                block78: {
                    block76: {
                        fieldModel = $this$encodeMethodName;
                        if (!(fieldModel instanceof FieldModel.Enum)) break block76;
                        memberName = new MemberName(SERIALIZATION_PACKAGE, enumHelper.isBitmask(((FieldModel.Enum)$this$encodeMethodName).getEnumType()) ? "encodeBitmaskValue" : "encodeEnumValue");
                        break block77;
                    }
                    if (!(fieldModel instanceof FieldModel.Primitive)) break block78;
                    switch ($this$encodeMethodName.getType()) {
                        case "int8_t": {
                            memberName = new MemberName(SERIALIZATION_PACKAGE, "encodeInt8");
                            break block77;
                        }
                        case "uint8_t_mavlink_version": 
                        case "uint8_t": {
                            memberName = new MemberName(SERIALIZATION_PACKAGE, "encodeUInt8");
                            break block77;
                        }
                        case "int16_t": {
                            memberName = new MemberName(SERIALIZATION_PACKAGE, "encodeInt16");
                            break block77;
                        }
                        case "uint16_t": {
                            memberName = new MemberName(SERIALIZATION_PACKAGE, "encodeUInt16");
                            break block77;
                        }
                        case "int32_t": {
                            memberName = new MemberName(SERIALIZATION_PACKAGE, "encodeInt32");
                            break block77;
                        }
                        case "uint32_t": {
                            memberName = new MemberName(SERIALIZATION_PACKAGE, "encodeUInt32");
                            break block77;
                        }
                        case "int64_t": {
                            memberName = new MemberName(SERIALIZATION_PACKAGE, "encodeInt64");
                            break block77;
                        }
                        case "uint64_t": {
                            memberName = new MemberName(SERIALIZATION_PACKAGE, "encodeUInt64");
                            break block77;
                        }
                        case "float": {
                            memberName = new MemberName(SERIALIZATION_PACKAGE, "encodeFloat");
                            break block77;
                        }
                        case "double": {
                            memberName = new MemberName(SERIALIZATION_PACKAGE, "encodeDouble");
                            break block77;
                        }
                        case "char": {
                            memberName = new MemberName(SERIALIZATION_PACKAGE, "encodeChar");
                            break block77;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown type: " + $this$encodeMethodName.getType());
                        }
                    }
                }
                if (!(fieldModel instanceof FieldModel.PrimitiveArray)) break block80;
                switch (((FieldModel.PrimitiveArray)$this$encodeMethodName).getPrimitiveType()) {
                    case "int8_t": {
                        memberName = new MemberName(SERIALIZATION_PACKAGE, "encodeInt8Array");
                        break block77;
                    }
                    case "uint8_t": {
                        memberName = new MemberName(SERIALIZATION_PACKAGE, "encodeUInt8Array");
                        break block77;
                    }
                    case "int16_t": {
                        memberName = new MemberName(SERIALIZATION_PACKAGE, "encodeInt16Array");
                        break block77;
                    }
                    case "uint16_t": {
                        memberName = new MemberName(SERIALIZATION_PACKAGE, "encodeUInt16Array");
                        break block77;
                    }
                    case "int32_t": {
                        memberName = new MemberName(SERIALIZATION_PACKAGE, "encodeInt32Array");
                        break block77;
                    }
                    case "uint32_t": {
                        memberName = new MemberName(SERIALIZATION_PACKAGE, "encodeUInt32Array");
                        break block77;
                    }
                    case "int64_t": {
                        memberName = new MemberName(SERIALIZATION_PACKAGE, "encodeInt64Array");
                        break block77;
                    }
                    case "uint64_t": {
                        memberName = new MemberName(SERIALIZATION_PACKAGE, "encodeUInt64Array");
                        break block77;
                    }
                    case "float": {
                        memberName = new MemberName(SERIALIZATION_PACKAGE, "encodeFloatArray");
                        break block77;
                    }
                    case "double": {
                        memberName = new MemberName(SERIALIZATION_PACKAGE, "encodeDoubleArray");
                        break block77;
                    }
                    case "char": {
                        memberName = new MemberName(SERIALIZATION_PACKAGE, "encodeString");
                        break block77;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown type: " + ((FieldModel.PrimitiveArray)$this$encodeMethodName).getPrimitiveType());
                    }
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        return memberName;
    }

    private static final MemberName decodeMethodName(FieldModel $this$decodeMethodName, EnumHelper enumHelper) {
        MemberName memberName;
        block77: {
            block80: {
                FieldModel fieldModel;
                block78: {
                    block76: {
                        fieldModel = $this$decodeMethodName;
                        if (!(fieldModel instanceof FieldModel.Enum)) break block76;
                        memberName = new MemberName(SERIALIZATION_PACKAGE, enumHelper.isBitmask(((FieldModel.Enum)$this$decodeMethodName).getEnumType()) ? "decodeBitmaskValue" : "decodeEnumValue");
                        break block77;
                    }
                    if (!(fieldModel instanceof FieldModel.Primitive)) break block78;
                    switch ($this$decodeMethodName.getType()) {
                        case "int8_t": {
                            memberName = new MemberName(SERIALIZATION_PACKAGE, "decodeInt8");
                            break block77;
                        }
                        case "uint8_t_mavlink_version": 
                        case "uint8_t": {
                            memberName = new MemberName(SERIALIZATION_PACKAGE, "decodeUInt8");
                            break block77;
                        }
                        case "int16_t": {
                            memberName = new MemberName(SERIALIZATION_PACKAGE, "decodeInt16");
                            break block77;
                        }
                        case "uint16_t": {
                            memberName = new MemberName(SERIALIZATION_PACKAGE, "decodeUInt16");
                            break block77;
                        }
                        case "int32_t": {
                            memberName = new MemberName(SERIALIZATION_PACKAGE, "decodeInt32");
                            break block77;
                        }
                        case "uint32_t": {
                            memberName = new MemberName(SERIALIZATION_PACKAGE, "decodeUInt32");
                            break block77;
                        }
                        case "int64_t": {
                            memberName = new MemberName(SERIALIZATION_PACKAGE, "decodeInt64");
                            break block77;
                        }
                        case "uint64_t": {
                            memberName = new MemberName(SERIALIZATION_PACKAGE, "decodeUInt64");
                            break block77;
                        }
                        case "float": {
                            memberName = new MemberName(SERIALIZATION_PACKAGE, "decodeFloat");
                            break block77;
                        }
                        case "double": {
                            memberName = new MemberName(SERIALIZATION_PACKAGE, "decodeDouble");
                            break block77;
                        }
                        case "char": {
                            memberName = new MemberName(SERIALIZATION_PACKAGE, "decodeChar");
                            break block77;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown type: " + $this$decodeMethodName.getType());
                        }
                    }
                }
                if (!(fieldModel instanceof FieldModel.PrimitiveArray)) break block80;
                switch (((FieldModel.PrimitiveArray)$this$decodeMethodName).getPrimitiveType()) {
                    case "int8_t": {
                        memberName = new MemberName(SERIALIZATION_PACKAGE, "decodeInt8Array");
                        break block77;
                    }
                    case "uint8_t": {
                        memberName = new MemberName(SERIALIZATION_PACKAGE, "decodeUInt8Array");
                        break block77;
                    }
                    case "int16_t": {
                        memberName = new MemberName(SERIALIZATION_PACKAGE, "decodeInt16Array");
                        break block77;
                    }
                    case "uint16_t": {
                        memberName = new MemberName(SERIALIZATION_PACKAGE, "decodeUInt16Array");
                        break block77;
                    }
                    case "int32_t": {
                        memberName = new MemberName(SERIALIZATION_PACKAGE, "decodeInt32Array");
                        break block77;
                    }
                    case "uint32_t": {
                        memberName = new MemberName(SERIALIZATION_PACKAGE, "decodeUInt32Array");
                        break block77;
                    }
                    case "int64_t": {
                        memberName = new MemberName(SERIALIZATION_PACKAGE, "decodeInt64Array");
                        break block77;
                    }
                    case "uint64_t": {
                        memberName = new MemberName(SERIALIZATION_PACKAGE, "decodeUInt64Array");
                        break block77;
                    }
                    case "float": {
                        memberName = new MemberName(SERIALIZATION_PACKAGE, "decodeFloatArray");
                        break block77;
                    }
                    case "double": {
                        memberName = new MemberName(SERIALIZATION_PACKAGE, "decodeDoubleArray");
                        break block77;
                    }
                    case "char": {
                        memberName = new MemberName(SERIALIZATION_PACKAGE, "decodeString");
                        break block77;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown type: " + ((FieldModel.PrimitiveArray)$this$decodeMethodName).getPrimitiveType());
                    }
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        return memberName;
    }
}

