/*
 * Decompiled with CFR 0.152.
 */
package xyz.urbanmatrix.mavlink.generator.models;

import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.urbanmatrix.mavlink.generator.CaseFormat;
import xyz.urbanmatrix.mavlink.generator.models.EnumModel;
import xyz.urbanmatrix.mavlink.generator.models.MessageModel;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0080\b\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\u0002\u0010\rJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0\u0005H\u00c6\u0003J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u0005H\u00c6\u0003JW\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005H\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020\u0007H\u00d6\u0001J\t\u0010&\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u0011\u0010\u0018\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000f\u00a8\u0006'"}, d2={"Lxyz/urbanmatrix/mavlink/generator/models/MavlinkModel;", "", "name", "", "includes", "", "version", "", "dialect", "enums", "Lxyz/urbanmatrix/mavlink/generator/models/EnumModel;", "messages", "Lxyz/urbanmatrix/mavlink/generator/models/MessageModel;", "(Ljava/lang/String;Ljava/util/List;IILjava/util/List;Ljava/util/List;)V", "getDialect", "()I", "dialectObjectName", "getDialectObjectName", "()Ljava/lang/String;", "getEnums", "()Ljava/util/List;", "getIncludes", "getMessages", "getName", "subPackageName", "getSubPackageName", "getVersion", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "generator"})
public final class MavlinkModel {
    @NotNull
    private final String name;
    @NotNull
    private final List<String> includes;
    private final int version;
    private final int dialect;
    @NotNull
    private final List<EnumModel> enums;
    @NotNull
    private final List<MessageModel> messages;
    @NotNull
    private final String dialectObjectName;
    @NotNull
    private final String subPackageName;

    public MavlinkModel(@NotNull String name, @NotNull List<String> includes, int version, int dialect, @NotNull List<EnumModel> enums, @NotNull List<MessageModel> messages) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(includes, (String)"includes");
        Intrinsics.checkNotNullParameter(enums, (String)"enums");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        this.name = name;
        this.includes = includes;
        this.version = version;
        this.dialect = dialect;
        this.enums = enums;
        this.messages = messages;
        this.dialectObjectName = CaseFormat.Companion.fromSnake(this.name).toUpperCamel() + "Dialect";
        String string = this.name;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        this.subPackageName = string2;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<String> getIncludes() {
        return this.includes;
    }

    public final int getVersion() {
        return this.version;
    }

    public final int getDialect() {
        return this.dialect;
    }

    @NotNull
    public final List<EnumModel> getEnums() {
        return this.enums;
    }

    @NotNull
    public final List<MessageModel> getMessages() {
        return this.messages;
    }

    @NotNull
    public final String getDialectObjectName() {
        return this.dialectObjectName;
    }

    @NotNull
    public final String getSubPackageName() {
        return this.subPackageName;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final List<String> component2() {
        return this.includes;
    }

    public final int component3() {
        return this.version;
    }

    public final int component4() {
        return this.dialect;
    }

    @NotNull
    public final List<EnumModel> component5() {
        return this.enums;
    }

    @NotNull
    public final List<MessageModel> component6() {
        return this.messages;
    }

    @NotNull
    public final MavlinkModel copy(@NotNull String name, @NotNull List<String> includes, int version, int dialect, @NotNull List<EnumModel> enums, @NotNull List<MessageModel> messages) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(includes, (String)"includes");
        Intrinsics.checkNotNullParameter(enums, (String)"enums");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        return new MavlinkModel(name, includes, version, dialect, enums, messages);
    }

    public static /* synthetic */ MavlinkModel copy$default(MavlinkModel mavlinkModel, String string, List list, int n, int n2, List list2, List list3, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = mavlinkModel.name;
        }
        if ((n3 & 2) != 0) {
            list = mavlinkModel.includes;
        }
        if ((n3 & 4) != 0) {
            n = mavlinkModel.version;
        }
        if ((n3 & 8) != 0) {
            n2 = mavlinkModel.dialect;
        }
        if ((n3 & 0x10) != 0) {
            list2 = mavlinkModel.enums;
        }
        if ((n3 & 0x20) != 0) {
            list3 = mavlinkModel.messages;
        }
        return mavlinkModel.copy(string, list, n, n2, list2, list3);
    }

    @NotNull
    public String toString() {
        return "MavlinkModel(name=" + this.name + ", includes=" + this.includes + ", version=" + this.version + ", dialect=" + this.dialect + ", enums=" + this.enums + ", messages=" + this.messages + ')';
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + ((Object)this.includes).hashCode();
        result = result * 31 + Integer.hashCode(this.version);
        result = result * 31 + Integer.hashCode(this.dialect);
        result = result * 31 + ((Object)this.enums).hashCode();
        result = result * 31 + ((Object)this.messages).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MavlinkModel)) {
            return false;
        }
        MavlinkModel mavlinkModel = (MavlinkModel)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)mavlinkModel.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.includes, mavlinkModel.includes)) {
            return false;
        }
        if (this.version != mavlinkModel.version) {
            return false;
        }
        if (this.dialect != mavlinkModel.dialect) {
            return false;
        }
        if (!Intrinsics.areEqual(this.enums, mavlinkModel.enums)) {
            return false;
        }
        return Intrinsics.areEqual(this.messages, mavlinkModel.messages);
    }
}

