/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.hbase;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.TableOutputFormat;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.Logging;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.execution.datasources.hbase.Field;
import org.apache.spark.sql.execution.datasources.hbase.HBaseRelation$;
import org.apache.spark.sql.execution.datasources.hbase.HBaseTableCatalog;
import org.apache.spark.sql.execution.datasources.hbase.HBaseTableCatalog$;
import org.apache.spark.sql.execution.datasources.hbase.HBaseTableScanRDD;
import org.apache.spark.sql.execution.datasources.hbase.RowKey;
import org.apache.spark.sql.execution.datasources.hbase.SerializableConfiguration;
import org.apache.spark.sql.execution.datasources.hbase.SparkHBaseConf$;
import org.apache.spark.sql.execution.datasources.hbase.Utils$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.InsertableRelation;
import org.apache.spark.sql.sources.PrunedFilteredScan;
import org.apache.spark.sql.types.StructType;
import org.json4s.DefaultFormats$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\rMb\u0001B\u0001\u0003\u0001F\u0011Q\u0002\u0013\"bg\u0016\u0014V\r\\1uS>t'BA\u0002\u0005\u0003\u0015A'-Y:f\u0015\t)a!A\u0006eCR\f7o\\;sG\u0016\u001c(BA\u0004\t\u0003%)\u00070Z2vi&|gN\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0004\u0001%aYbD\t\u0015\u0011\u0005M1R\"\u0001\u000b\u000b\u0005UA\u0011aB:pkJ\u001cWm]\u0005\u0003/Q\u0011ABQ1tKJ+G.\u0019;j_:\u0004\"aE\r\n\u0005i!\"A\u0005)sk:,GMR5mi\u0016\u0014X\rZ*dC:\u0004\"a\u0005\u000f\n\u0005u!\"AE%og\u0016\u0014H/\u00192mKJ+G.\u0019;j_:\u0004\"a\b\u0011\u000e\u0003)I!!\t\u0006\u0003\u000f1{wmZ5oOB\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t9\u0001K]8ek\u000e$\bCA\u0012*\u0013\tQCE\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005-\u0001\tU\r\u0011\"\u0001.\u0003)\u0001\u0018M]1nKR,'o]\u000b\u0002]A!qFM\u001b6\u001d\t\u0019\u0003'\u0003\u00022I\u00051\u0001K]3eK\u001aL!a\r\u001b\u0003\u00075\u000b\u0007O\u0003\u00022IA\u0011qFN\u0005\u0003oQ\u0012aa\u0015;sS:<\u0007\u0002C\u001d\u0001\u0005#\u0005\u000b\u0011\u0002\u0018\u0002\u0017A\f'/Y7fi\u0016\u00148\u000f\t\u0005\tw\u0001\u0011)\u001a!C\u0001y\u0005\u0019Ro]3s'B,7-\u001b4jK\u0012\u001c8\r[3nCV\tQ\bE\u0002$}\u0001K!a\u0010\u0013\u0003\r=\u0003H/[8o!\t\tE)D\u0001C\u0015\t\u0019\u0005\"A\u0003usB,7/\u0003\u0002F\u0005\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u0011\u001d\u0003!\u0011#Q\u0001\nu\nA#^:feN\u0003XmY5gS\u0016$7o\u00195f[\u0006\u0004\u0003\u0002C%\u0001\u0005\u000b\u0007I\u0011\u0001&\u0002\u0015M\fHnQ8oi\u0016DH/F\u0001L!\taU*D\u0001\t\u0013\tq\u0005B\u0001\u0006T#2\u001buN\u001c;fqRD\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006IaS\u0001\fgFd7i\u001c8uKb$\b\u0005\u000b\u0002P%B\u00111eU\u0005\u0003)\u0012\u0012\u0011\u0002\u001e:b]NLWM\u001c;\t\u000bY\u0003A\u0011A,\u0002\rqJg.\u001b;?)\rAF,\u0018\u000b\u00033n\u0003\"A\u0017\u0001\u000e\u0003\tAQ!S+A\u0002-CQ\u0001L+A\u00029BQaO+A\u0002uBqa\u0018\u0001C\u0002\u0013\u0005\u0001-A\u0005uS6,7\u000f^1naV\t\u0011\rE\u0002$}\t\u0004\"aI2\n\u0005\u0011$#\u0001\u0002'p]\u001eDaA\u001a\u0001!\u0002\u0013\t\u0017A\u0003;j[\u0016\u001cH/Y7qA!9\u0001\u000e\u0001b\u0001\n\u0003\u0001\u0017\u0001C7j]N#\u0018-\u001c9\t\r)\u0004\u0001\u0015!\u0003b\u0003%i\u0017N\\*uC6\u0004\b\u0005C\u0004m\u0001\t\u0007I\u0011\u00011\u0002\u00115\f\u0007p\u0015;b[BDaA\u001c\u0001!\u0002\u0013\t\u0017!C7bqN#\u0018-\u001c9!\u0011\u001d\u0001\bA1A\u0005\u0002E\f1\"\\1y-\u0016\u00148/[8ogV\t!\u000fE\u0002$}M\u0004\"a\t;\n\u0005U$#aA%oi\"1q\u000f\u0001Q\u0001\nI\fA\"\\1y-\u0016\u00148/[8og\u0002Bq!\u001f\u0001C\u0002\u0013\r!0A\u0004g_Jl\u0017\r^:\u0016\u0003mt!\u0001`@\u000e\u0003uT!A \b\u0002\r)\u001cxN\u001c\u001bt\u0013\r\t\t!`\u0001\u000f\t\u00164\u0017-\u001e7u\r>\u0014X.\u0019;t\u0011\u001d\t)\u0001\u0001Q\u0001\nm\f\u0001BZ8s[\u0006$8\u000f\t\u0015\u0004\u0003\u0007\u0011\u0006\"CA\u0006\u0001\t\u0007I\u0011AA\u0007\u0003IA')Y:f\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0016\u0005\u0005=\u0001cA\u0012?]!A\u00111\u0003\u0001!\u0002\u0013\ty!A\ni\u0005\u0006\u001cXmQ8oM&<WO]1uS>t\u0007\u0005C\u0004\u0002\u0018\u0001!\t!!\u0007\u0002\u0017\r\u0014X-\u0019;f)\u0006\u0014G.\u001a\u000b\u0003\u00037\u00012aIA\u000f\u0013\r\ty\u0002\n\u0002\u0005+:LG\u000fC\u0004\u0002$\u0001!\t%!\n\u0002\r%t7/\u001a:u)\u0019\tY\"a\n\u00022!A\u0011\u0011FA\u0011\u0001\u0004\tY#\u0001\u0003eCR\f\u0007c\u0001'\u0002.%\u0019\u0011q\u0006\u0005\u0003\u0013\u0011\u000bG/\u0019$sC6,\u0007\u0002CA\u001a\u0003C\u0001\r!!\u000e\u0002\u0013=4XM]<sSR,\u0007cA\u0012\u00028%\u0019\u0011\u0011\b\u0013\u0003\u000f\t{w\u000e\\3b]\"I\u0011Q\b\u0001C\u0002\u0013\u0005\u0011qH\u0001\bG\u0006$\u0018\r\\8h+\t\t\t\u0005E\u0002[\u0003\u0007J1!!\u0012\u0003\u0005EA%)Y:f)\u0006\u0014G.Z\"bi\u0006dwn\u001a\u0005\t\u0003\u0013\u0002\u0001\u0015!\u0003\u0002B\u0005A1-\u0019;bY><\u0007\u0005C\u0005\u0002N\u0001\u0011\r\u0011\"\u0001\u0002P\u0005\u0011AMZ\u000b\u0003\u0003WA\u0001\"a\u0015\u0001A\u0003%\u00111F\u0001\u0004I\u001a\u0004\u0003\"CA,\u0001\t\u0007I\u0011AA-\u0003!!Xm\u001d;D_:4WCAA\u001b\u0011!\ti\u0006\u0001Q\u0001\n\u0005U\u0012!\u0003;fgR\u001cuN\u001c4!\u0011%\t\t\u0007\u0001b\u0001\n\u0003\t\u0019'A\u0003i\u0007>tg-\u0006\u0002\u0002fA!\u0011qMA9\u001b\t\tIG\u0003\u0003\u0002l\u00055\u0014\u0001B2p]\u001aT1!a\u001c\r\u0003\u0019A\u0017\rZ8pa&!\u00111OA5\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"A\u0011q\u000f\u0001!\u0002\u0013\t)'\u0001\u0004i\u0007>tg\r\t\u0015\u0004\u0003k\u0012\u0006\"CA?\u0001\t\u0007I\u0011AA@\u0003-9(/\u00199qK\u0012\u001cuN\u001c4\u0016\u0005\u0005\u0005\u0005CBAB\u0003\u0013\u000bi)\u0004\u0002\u0002\u0006*\u0019\u0011q\u0011\u0006\u0002\u0013\t\u0014x.\u00193dCN$\u0018\u0002BAF\u0003\u000b\u0013\u0011B\u0011:pC\u0012\u001c\u0017m\u001d;\u0011\u0007i\u000by)C\u0002\u0002\u0012\n\u0011\u0011dU3sS\u0006d\u0017N_1cY\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]\"A\u0011Q\u0013\u0001!\u0002\u0013\t\t)\u0001\u0007xe\u0006\u0004\b/\u001a3D_:4\u0007\u0005C\u0004\u0002\u001a\u0002!\t!a\u0019\u0002\u0013!\u0014\u0017m]3D_:4\u0007bBAO\u0001\u0011\u0005\u0011qT\u0001\u0005e><8/\u0006\u0002\u0002\"B\u0019!,a)\n\u0007\u0005\u0015&A\u0001\u0004S_^\\U-\u001f\u0005\b\u0003S\u0003A\u0011AA-\u0003%\u0019\u0018N\\4mK.+\u0017\u0010C\u0004\u0002.\u0002!\t!a,\u0002\u0011\u001d,GOR5fY\u0012$B!!-\u00028B\u0019!,a-\n\u0007\u0005U&AA\u0003GS\u0016dG\rC\u0004\u0002:\u0006-\u0006\u0019A\u001b\u0002\t9\fW.\u001a\u0005\b\u0003{\u0003A\u0011AA`\u00031I7\u000f\u0015:j[\u0006\u0014\u0018pS3z)\u0011\t)$!1\t\u000f\u0005\r\u00171\u0018a\u0001k\u0005\t1\rC\u0004\u0002H\u0002!\t!!3\u0002\u0017%\u001c8i\\7q_NLG/\u001a\u000b\u0003\u0003kAq!!4\u0001\t\u0003\ty-\u0001\u0005jg\u000e{G.^7o)\u0011\t)$!5\t\u000f\u0005\r\u00171\u001aa\u0001k!9\u0011Q\u001b\u0001\u0005\u0002\u0005]\u0017!D4fiJ{woQ8mk6t7\u000f\u0006\u0003\u0002Z\u0006E\bCBAn\u0003W\f\tL\u0004\u0003\u0002^\u0006\u001dh\u0002BAp\u0003Kl!!!9\u000b\u0007\u0005\r\b#\u0001\u0004=e>|GOP\u0005\u0002K%\u0019\u0011\u0011\u001e\u0013\u0002\u000fA\f7m[1hK&!\u0011Q^Ax\u0005\r\u0019V-\u001d\u0006\u0004\u0003S$\u0003\u0002CAb\u0003'\u0004\r!!7\t\u000f\u0005U\b\u0001\"\u0001\u0002x\u0006)r-\u001a;J]\u0012,\u00070\u001a3Qe>TWm\u0019;j_:\u001cH\u0003BA}\u0005\u0003\u0001b!a7\u0002l\u0006m\bCB\u0012\u0002~\u0006E6/C\u0002\u0002\u0000\u0012\u0012a\u0001V;qY\u0016\u0014\u0004\u0002\u0003B\u0002\u0003g\u0004\rA!\u0002\u0002\u001fI,\u0017/^5sK\u0012\u001cu\u000e\\;n]N\u0004Ba\tB\u0004k%\u0019!\u0011\u0002\u0013\u0003\u000b\u0005\u0013(/Y=\t\u000f\t5\u0001\u0001\"\u0001\u0003\u0010\u0005\u00112\u000f\u001d7jiJ{woS3z\u0007>dW/\u001c8t)\u0011\u0011\tBa\u0005\u0011\u000f\r\ni0!7\u0002Z\"A!1\u0001B\u0006\u0001\u0004\u0011)\u0001C\u0005\u0003\u0018\u0001\u0011\r\u0011\"\u0011\u0003\u001a\u000511o\u00195f[\u0006,\u0012\u0001\u0011\u0005\b\u0005;\u0001\u0001\u0015!\u0003A\u0003\u001d\u00198\r[3nC\u0002BqA!\t\u0001\t\u0003\u0011\u0019#A\u0005ck&dGmU2b]R1!Q\u0005B\u001c\u0005s\u0001bAa\n\u0003.\tERB\u0001B\u0015\u0015\r\u0011YCC\u0001\u0004e\u0012$\u0017\u0002\u0002B\u0018\u0005S\u00111A\u0015#E!\ra%1G\u0005\u0004\u0005kA!a\u0001*po\"A!1\u0001B\u0010\u0001\u0004\u0011)\u0001\u0003\u0005\u0003<\t}\u0001\u0019\u0001B\u001f\u0003\u001d1\u0017\u000e\u001c;feN\u0004Ra\tB\u0004\u0005\u007f\u00012a\u0005B!\u0013\r\u0011\u0019\u0005\u0006\u0002\u0007\r&dG/\u001a:\t\u0013\t\u001d\u0003!!A\u0005\u0002\t%\u0013\u0001B2paf$bAa\u0013\u0003P\tECcA-\u0003N!1\u0011J!\u0012A\u0002-C\u0001\u0002\fB#!\u0003\u0005\rA\f\u0005\tw\t\u0015\u0003\u0013!a\u0001{!I!Q\u000b\u0001\u0012\u0002\u0013\u0005!qK\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011IFK\u0002/\u00057Z#A!\u0018\u0011\t\t}#\u0011N\u0007\u0003\u0005CRAAa\u0019\u0003f\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005O\"\u0013AC1o]>$\u0018\r^5p]&!!1\u000eB1\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0005_\u0002\u0011\u0013!C\u0001\u0005c\nabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003t)\u001aQHa\u0017\t\u0013\t]\u0004!!A\u0005B\te\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003|A!!Q\u0010BD\u001b\t\u0011yH\u0003\u0003\u0003\u0002\n\r\u0015\u0001\u00027b]\u001eT!A!\"\u0002\t)\fg/Y\u0005\u0004o\t}\u0004\"\u0003BF\u0001\u0005\u0005I\u0011\u0001BG\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\u0005\u0019\b\"\u0003BI\u0001\u0005\u0005I\u0011\u0001BJ\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!&\u0003\u001cB\u00191Ea&\n\u0007\teEEA\u0002B]fD\u0011B!(\u0003\u0010\u0006\u0005\t\u0019A:\u0002\u0007a$\u0013\u0007C\u0005\u0003\"\u0002\t\t\u0011\"\u0011\u0003$\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003&B1!q\u0015BW\u0005+k!A!+\u000b\u0007\t-F%\u0001\u0006d_2dWm\u0019;j_:LAAa,\u0003*\nA\u0011\n^3sCR|'\u000fC\u0005\u00034\u0002\t\t\u0011\"\u0001\u00036\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u00026\t]\u0006B\u0003BO\u0005c\u000b\t\u00111\u0001\u0003\u0016\"I!1\u0018\u0001\u0002\u0002\u0013\u0005#QX\u0001\tQ\u0006\u001c\bnQ8eKR\t1\u000fC\u0005\u0003B\u0002\t\t\u0011\"\u0011\u0003D\u0006AAo\\*ue&tw\r\u0006\u0002\u0003|!I!q\u0019\u0001\u0002\u0002\u0013\u0005#\u0011Z\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005U\"1\u001a\u0005\u000b\u0005;\u0013)-!AA\u0002\tUua\u0002Bh\u0005!\u0005!\u0011[\u0001\u000e\u0011\n\u000b7/\u001a*fY\u0006$\u0018n\u001c8\u0011\u0007i\u0013\u0019N\u0002\u0004\u0002\u0005!\u0005!Q[\n\u0006\u0005'\u00149\u000e\u000b\t\u0004G\te\u0017b\u0001BnI\t1\u0011I\\=SK\u001aDqA\u0016Bj\t\u0003\u0011y\u000e\u0006\u0002\u0003R\"Q!1\u001dBj\u0005\u0004%\tA!\u001f\u0002\u0013QKU*R*U\u00036\u0003\u0006\"\u0003Bt\u0005'\u0004\u000b\u0011\u0002B>\u0003)!\u0016*T#T)\u0006k\u0005\u000b\t\u0005\u000b\u0005W\u0014\u0019N1A\u0005\u0002\te\u0014!C'J\u001d~\u001bF+Q'Q\u0011%\u0011yOa5!\u0002\u0013\u0011Y(\u0001\u0006N\u0013:{6\u000bV!N!\u0002B!Ba=\u0003T\n\u0007I\u0011\u0001B=\u0003%i\u0015\tW0T)\u0006k\u0005\u000bC\u0005\u0003x\nM\u0007\u0015!\u0003\u0003|\u0005QQ*\u0011-`'R\u000bU\n\u0015\u0011\t\u0015\tm(1\u001bb\u0001\n\u0003\u0011I(\u0001\u0007N\u0003b{f+\u0012*T\u0013>s5\u000bC\u0005\u0003\u0000\nM\u0007\u0015!\u0003\u0003|\u0005iQ*\u0011-`-\u0016\u00136+S(O'\u0002B!ba\u0001\u0003T\n\u0007I\u0011\u0001B=\u0003MA%)Q*F?\u000e{eJR%H+J\u000bE+S(O\u0011%\u00199Aa5!\u0002\u0013\u0011Y(\u0001\u000bI\u0005\u0006\u001bViX\"P\u001d\u001aKu)\u0016*B)&{e\n\t\u0005\u000b\u0007\u0017\u0011\u0019.!A\u0005\u0002\u000e5\u0011!B1qa2LHCBB\b\u0007+\u00199\u0002F\u0002Z\u0007#Aa!SB\u0005\u0001\u0004Y\u0005fAB\t%\"1Af!\u0003A\u00029BaaOB\u0005\u0001\u0004i\u0004BCB\u000e\u0005'\f\t\u0011\"!\u0004\u001e\u00059QO\\1qa2LH\u0003BB\u0010\u0007G\u0001Ba\t \u0004\"A)1%!@/{!I1QEB\r\u0003\u0003\u0005\r!W\u0001\u0004q\u0012\u0002\u0004BCB\u0015\u0005'\f\t\u0011\"\u0003\u0004,\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0019i\u0003\u0005\u0003\u0003~\r=\u0012\u0002BB\u0019\u0005\u007f\u0012aa\u00142kK\u000e$\b")
public class HBaseRelation
extends BaseRelation
implements PrunedFilteredScan,
InsertableRelation,
Logging,
Product,
Serializable {
    private final Map<String, String> parameters;
    private final Option<StructType> userSpecifiedschema;
    private final transient SQLContext sqlContext;
    private final Option<Object> timestamp;
    private final Option<Object> minStamp;
    private final Option<Object> maxStamp;
    private final Option<Object> maxVersions;
    private final transient DefaultFormats$ formats;
    private final Option<Map<String, String>> hBaseConfiguration;
    private final HBaseTableCatalog catalog;
    private final DataFrame df;
    private final boolean testConf;
    private final transient Configuration hConf;
    private final Broadcast<SerializableConfiguration> wrappedConf;
    private final StructType schema;
    private transient Logger org$apache$spark$Logging$$log_;

    public static String HBASE_CONFIGURATION() {
        return HBaseRelation$.MODULE$.HBASE_CONFIGURATION();
    }

    public static String MAX_VERSIONS() {
        return HBaseRelation$.MODULE$.MAX_VERSIONS();
    }

    public static String MAX_STAMP() {
        return HBaseRelation$.MODULE$.MAX_STAMP();
    }

    public static String MIN_STAMP() {
        return HBaseRelation$.MODULE$.MIN_STAMP();
    }

    public static String TIMESTAMP() {
        return HBaseRelation$.MODULE$.TIMESTAMP();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public Option<StructType> userSpecifiedschema() {
        return this.userSpecifiedschema;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public Option<Object> timestamp() {
        return this.timestamp;
    }

    public Option<Object> minStamp() {
        return this.minStamp;
    }

    public Option<Object> maxStamp() {
        return this.maxStamp;
    }

    public Option<Object> maxVersions() {
        return this.maxVersions;
    }

    public DefaultFormats$ formats() {
        return this.formats;
    }

    public Option<Map<String, String>> hBaseConfiguration() {
        return this.hBaseConfiguration;
    }

    public void createTable() {
        if (this.catalog().numReg() > 3) {
            TableName tName = TableName.valueOf((String)this.catalog().name());
            Iterable<String> cfs = this.catalog().getColumnFamilies();
            Connection connection = ConnectionFactory.createConnection((Configuration)this.hbaseConf());
            Admin admin = connection.getAdmin();
            if (admin.isTableAvailable(tName) && tName.toString().startsWith("shcExample")) {
                admin.disableTable(tName);
                admin.deleteTable(tName);
            }
            if (!admin.isTableAvailable(tName)) {
                HTableDescriptor tableDesc = new HTableDescriptor(tName);
                cfs.foreach((Function1)new Serializable(this, tableDesc){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HBaseRelation $outer;
                    private final HTableDescriptor tableDesc$1;

                    public final HTableDescriptor apply(String x) {
                        HColumnDescriptor cf = new HColumnDescriptor(x.getBytes());
                        this.$outer.logDebug((Function0<String>)new Serializable(this, x){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$createTable$1 $outer;
                            private final String x$16;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"add family ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x$16, this.$outer.org$apache$spark$sql$execution$datasources$hbase$HBaseRelation$$anonfun$$$outer().catalog().name()}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.x$16 = x$16;
                            }
                        });
                        return this.tableDesc$1.addFamily(cf);
                    }

                    public /* synthetic */ HBaseRelation org$apache$spark$sql$execution$datasources$hbase$HBaseRelation$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.tableDesc$1 = tableDesc$1;
                    }
                });
                byte[] startKey = Bytes.toBytes((String)"aaaaaaa");
                byte[] endKey = Bytes.toBytes((String)"zzzzzzz");
                byte[][] splitKeys = Bytes.split((byte[])startKey, (byte[])endKey, (int)(this.catalog().numReg() - 3));
                admin.createTable(tableDesc, splitKeys);
                List r = connection.getRegionLocator(TableName.valueOf((String)this.catalog().name())).getAllRegionLocations();
                while (r == null || r.size() == 0) {
                    this.logDebug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"region not allocated"})).s((Seq)Nil$.MODULE$);
                        }
                    });
                    Thread.sleep(1000L);
                }
                this.logDebug((Function0<String>)new Serializable(this, r){
                    public static final long serialVersionUID = 0L;
                    private final List r$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"region allocated ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.r$1}));
                    }
                    {
                        this.r$1 = r$1;
                    }
                });
            }
            admin.close();
            connection.close();
        }
    }

    public void insert(DataFrame data, boolean overwrite) {
        JobConf jobConfig = new JobConf(this.hbaseConf(), ((Object)((Object)this)).getClass());
        jobConfig.setOutputFormat(TableOutputFormat.class);
        jobConfig.set("hbase.mapred.outputtable", this.catalog().name());
        IntRef count = new IntRef(0);
        Seq<Field> rkFields = this.catalog().getRowKey();
        Seq rkIdxedFields = (Seq)rkFields.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;

            public final Tuple2<Object, Field> apply(Field x0$1) {
                Field field = x0$1;
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)this.$outer.schema().fieldIndex(field.colName())), (Object)field);
                return tuple2;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Tuple2[] colsIdxedFields = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.schema().fieldNames()).partition((Function1)new Serializable(this, rkFields){
            public static final long serialVersionUID = 0L;
            private final Seq rkFields$1;

            public final boolean apply(String x) {
                return ((SeqLike)this.rkFields$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Field x$6) {
                        return x$6.colName();
                    }
                }, Seq$.MODULE$.canBuildFrom())).contains((Object)x);
            }
            {
                this.rkFields$1 = rkFields$1;
            }
        })._2()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;

            public final Tuple2<Object, Field> apply(String x) {
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)this.$outer.schema().fieldIndex(x)), (Object)this.$outer.catalog().getField(x));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        RDD rdd = data.rdd();
        RDD$.MODULE$.rddToPairRDDFunctions(rdd.map((Function1)new Serializable(this, count, rkIdxedFields, colsIdxedFields){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;
            private final IntRef count$1;
            private final Seq rkIdxedFields$1;
            private final Tuple2[] colsIdxedFields$1;

            public final Tuple2<ImmutableBytesWritable, Put> apply(Row x$8) {
                return this.$outer.org$apache$spark$sql$execution$datasources$hbase$HBaseRelation$$convertToPut$1(x$8, this.count$1, this.rkIdxedFields$1, this.colsIdxedFields$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.count$1 = count$1;
                this.rkIdxedFields$1 = rkIdxedFields$1;
                this.colsIdxedFields$1 = colsIdxedFields$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(ImmutableBytesWritable.class), ClassTag$.MODULE$.apply(Put.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms())).saveAsHadoopDataset(jobConfig);
    }

    public HBaseTableCatalog catalog() {
        return this.catalog;
    }

    public DataFrame df() {
        return this.df;
    }

    public boolean testConf() {
        return this.testConf;
    }

    public Configuration hConf() {
        return this.hConf;
    }

    public Broadcast<SerializableConfiguration> wrappedConf() {
        return this.wrappedConf;
    }

    public Configuration hbaseConf() {
        return ((SerializableConfiguration)this.wrappedConf().value()).value();
    }

    public RowKey rows() {
        return this.catalog().row();
    }

    public boolean singleKey() {
        return this.rows().fields().size() == 1;
    }

    public Field getField(String name) {
        return this.catalog().getField(name);
    }

    public boolean isPrimaryKey(String c) {
        Field f1 = (Field)this.catalog().getRowKey().apply(0);
        Field f2 = this.getField(c);
        Field field = f1;
        Field field2 = f2;
        return !(field != null ? !((Object)field).equals(field2) : field2 != null);
    }

    public boolean isComposite() {
        return this.catalog().getRowKey().size() > 1;
    }

    public boolean isColumn(String c) {
        return !((SeqLike)this.catalog().getRowKey().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Field x$10) {
                return x$10.colName();
            }
        }, Seq$.MODULE$.canBuildFrom())).contains((Object)c);
    }

    public Seq<Field> getRowColumns(Seq<Field> c) {
        return (Seq)((TraversableLike)((TraversableLike)((IterableLike)((TraversableLike)this.catalog().getRowKey().zipWithIndex(Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, c){
            public static final long serialVersionUID = 0L;
            private final Seq c$1;

            public final boolean apply(Tuple2<Field, Object> x) {
                return this.c$1.contains(x._1());
            }
            {
                this.c$1 = c$1;
            }
        })).zipWithIndex(Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Tuple2<Field, Object>, Object> x) {
                return ((Tuple2)x._1())._2$mcI$sp() == x._2$mcI$sp();
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Field apply(Tuple2<Tuple2<Field, Object>, Object> x$11) {
                return (Field)((Tuple2)x$11._1())._1();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Tuple2<Field, Object>> getIndexedProjections(String[] requiredColumns) {
        return (Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])requiredColumns).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;

            public final Field apply(String x$12) {
                return this.$outer.catalog().sMap().getField(x$12);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Field.class)))).zipWithIndex(Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public Tuple2<Seq<Field>, Seq<Field>> splitRowKeyColumns(String[] requiredColumns) {
        Tuple2 tuple2 = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])requiredColumns).map((Function1)new $anonfun$14(this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Field.class)))).partition((Function1)new $anonfun$15(this));
        if (tuple2 != null) {
            Tuple2 tuple22;
            Field[] l = (Field[])tuple2._1();
            Field[] r = (Field[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)l, (Object)r);
            Field[] l2 = (Field[])tuple23._1();
            Field[] r2 = (Field[])tuple23._2();
            return new Tuple2((Object)Predef$.MODULE$.wrapRefArray((Object[])l2), (Object)Predef$.MODULE$.wrapRefArray((Object[])r2));
        }
        throw new MatchError((Object)tuple2);
    }

    public StructType schema() {
        return this.schema;
    }

    public RDD<Row> buildScan(String[] requiredColumns, Filter[] filters) {
        return new HBaseTableScanRDD(this, requiredColumns, filters);
    }

    public HBaseRelation copy(Map<String, String> parameters, Option<StructType> userSpecifiedschema, SQLContext sqlContext) {
        return new HBaseRelation(parameters, userSpecifiedschema, sqlContext);
    }

    public Map<String, String> copy$default$1() {
        return this.parameters();
    }

    public Option<StructType> copy$default$2() {
        return this.userSpecifiedschema();
    }

    public String productPrefix() {
        return "HBaseRelation";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Option<StructType> option;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                option = this.userSpecifiedschema();
                break;
            }
            case 0: {
                option = this.parameters();
            }
        }
        return option;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HBaseRelation;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HBaseRelation)) return false;
        boolean bl = true;
        if (!bl) return false;
        HBaseRelation hBaseRelation = (HBaseRelation)((Object)x$1);
        Map<String, String> map = this.parameters();
        Map<String, String> map2 = hBaseRelation.parameters();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Option<StructType> option = this.userSpecifiedschema();
        Option<StructType> option2 = hBaseRelation.userSpecifiedschema();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!hBaseRelation.canEqual((Object)this)) return false;
        return true;
    }

    public final Tuple2 org$apache$spark$sql$execution$datasources$hbase$HBaseRelation$$convertToPut$1(Row row, IntRef count$1, Seq rkIdxedFields$1, Tuple2[] colsIdxedFields$1) {
        Seq rowBytes = (Seq)rkIdxedFields$1.map((Function1)new Serializable(this, row){
            public static final long serialVersionUID = 0L;
            private final Row row$1;

            public final byte[] apply(Tuple2<Object, Field> x0$2) {
                Tuple2<Object, Field> tuple2 = x0$2;
                if (tuple2 != null) {
                    int x = tuple2._1$mcI$sp();
                    Field y = (Field)tuple2._2();
                    byte[] byArray = Utils$.MODULE$.toBytes(this.row$1.apply(x), y);
                    return byArray;
                }
                throw new MatchError(tuple2);
            }
            {
                this.row$1 = row$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        int rLen = BoxesRunTime.unboxToInt((Object)rowBytes.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int x0$3, byte[] x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$3), (Object)x1$1);
                if (tuple2 != null) {
                    int x = tuple2._1$mcI$sp();
                    byte[] y = (byte[])tuple2._2();
                    int n = x + y.length;
                    return n;
                }
                throw new MatchError((Object)tuple2);
            }
        }));
        byte[] rBytes = new byte[rLen];
        IntRef offset = new IntRef(0);
        rowBytes.foreach((Function1)new Serializable(this, rBytes, offset){
            public static final long serialVersionUID = 0L;
            private final byte[] rBytes$1;
            private final IntRef offset$1;

            public final void apply(byte[] x) {
                System.arraycopy(x, 0, this.rBytes$1, this.offset$1.elem, x.length);
                this.offset$1.elem += x.length;
            }
            {
                this.rBytes$1 = rBytes$1;
                this.offset$1 = offset$1;
            }
        });
        Put put = (Put)this.timestamp().fold((Function0)new Serializable(this, rBytes){
            public static final long serialVersionUID = 0L;
            private final byte[] rBytes$1;

            public final Put apply() {
                return new Put(this.rBytes$1);
            }
            {
                this.rBytes$1 = rBytes$1;
            }
        }, (Function1)new Serializable(this, rBytes){
            public static final long serialVersionUID = 0L;
            private final byte[] rBytes$1;

            public final Put apply(long x$7) {
                return new Put(this.rBytes$1, x$7);
            }
            {
                this.rBytes$1 = rBytes$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])colsIdxedFields$1).foreach((Function1)new Serializable(this, row, put){
            public static final long serialVersionUID = 0L;
            private final Row row$1;
            private final Put put$1;

            public final Put apply(Tuple2<Object, Field> x0$4) {
                Tuple2<Object, Field> tuple2 = x0$4;
                if (tuple2 != null) {
                    int x = tuple2._1$mcI$sp();
                    Field y = (Field)tuple2._2();
                    byte[] b = Utils$.MODULE$.toBytes(this.row$1.apply(x), y);
                    Put put = this.put$1.addColumn(Bytes.toBytes((String)y.cf()), Bytes.toBytes((String)y.col()), b);
                    return put;
                }
                throw new MatchError(tuple2);
            }
            {
                this.row$1 = row$1;
                this.put$1 = put$1;
            }
        });
        ++count$1.elem;
        return new Tuple2((Object)new ImmutableBytesWritable(), (Object)put);
    }

    public HBaseRelation(Map<String, String> parameters, Option<StructType> userSpecifiedschema, SQLContext sqlContext) {
        Configuration configuration;
        this.parameters = parameters;
        this.userSpecifiedschema = userSpecifiedschema;
        this.sqlContext = sqlContext;
        Logging.class.$init$((Logging)this);
        Product.class.$init$((Product)this);
        this.timestamp = parameters.get((Object)HBaseRelation$.MODULE$.TIMESTAMP()).map((Function1)new $anonfun$1(this));
        this.minStamp = parameters.get((Object)HBaseRelation$.MODULE$.MIN_STAMP()).map((Function1)new $anonfun$2(this));
        this.maxStamp = parameters.get((Object)HBaseRelation$.MODULE$.MAX_STAMP()).map((Function1)new $anonfun$3(this));
        this.maxVersions = parameters.get((Object)HBaseRelation$.MODULE$.MAX_VERSIONS()).map((Function1)new $anonfun$4(this));
        this.formats = DefaultFormats$.MODULE$;
        this.hBaseConfiguration = parameters.get((Object)HBaseRelation$.MODULE$.HBASE_CONFIGURATION()).map((Function1)new $anonfun$5(this));
        this.catalog = HBaseTableCatalog$.MODULE$.apply(parameters);
        this.df = null;
        this.testConf = sqlContext.sparkContext().conf().getBoolean(SparkHBaseConf$.MODULE$.testConf(), false);
        if (this.testConf()) {
            configuration = SparkHBaseConf$.MODULE$.conf();
        } else {
            Configuration conf = HBaseConfiguration.create();
            this.hBaseConfiguration().foreach((Function1)new $anonfun$13(this, conf));
            configuration = conf;
        }
        this.hConf = configuration;
        this.wrappedConf = sqlContext.sparkContext().broadcast((Object)new SerializableConfiguration(this.hConf()), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        this.schema = (StructType)userSpecifiedschema.getOrElse((Function0)new $anonfun$16(this));
    }
}

