/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.nlp.preprocess;

import ai.djl.modality.nlp.preprocess.TextProcessor;
import java.util.ArrayList;
import java.util.List;

public class SentenceLengthNormalizer
implements TextProcessor {
    private static final int DEFAULT_SENTENCE_LENGTH = 10;
    private static final String DEFAULT_PADDING_TOKEN = "<pad>";
    private static final String DEFAULT_EOS_TOKEN = "<eos>";
    private static final String DEFAULT_BOS_TOKEN = "<bos>";
    private int sentenceLength;
    private boolean addEosBosTokens;
    private String paddingToken;
    private String eosToken;
    private String bosToken;
    private int lastValidLength = -1;

    public SentenceLengthNormalizer() {
        this(10, false);
    }

    public SentenceLengthNormalizer(int sentenceLength, boolean addEosBosTokens) {
        this(sentenceLength, addEosBosTokens, DEFAULT_PADDING_TOKEN, DEFAULT_EOS_TOKEN, DEFAULT_BOS_TOKEN);
    }

    public SentenceLengthNormalizer(int sentenceLength, boolean addEosBosTokens, String paddingToken, String eosToken, String bosToken) {
        this.sentenceLength = sentenceLength;
        this.addEosBosTokens = addEosBosTokens;
        this.paddingToken = paddingToken;
        this.eosToken = eosToken;
        this.bosToken = bosToken;
    }

    @Override
    public List<String> preprocess(List<String> tokens) {
        int size;
        ArrayList<String> list = new ArrayList<String>(this.sentenceLength);
        if (this.addEosBosTokens) {
            list.add(this.bosToken);
        }
        list.addAll(tokens);
        if (this.addEosBosTokens) {
            list.add(this.eosToken);
        }
        if (this.sentenceLength < (size = list.size())) {
            this.lastValidLength = this.sentenceLength;
            if (this.addEosBosTokens) {
                list.set(this.sentenceLength - 1, this.eosToken);
            }
            return list.subList(0, this.sentenceLength);
        }
        this.lastValidLength = size;
        for (int i = size; i < this.sentenceLength; ++i) {
            list.add(this.paddingToken);
        }
        return list;
    }

    public int getLastValidLength() {
        return this.lastValidLength;
    }
}

