/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.nn;

import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.nn.AbstractBlock;
import ai.djl.nn.BlockList;
import ai.djl.nn.Parameter;
import ai.djl.util.PairList;

public abstract class ParameterBlock
extends AbstractBlock {
    @Override
    public Shape[] initialize(NDManager manager, DataType dataType, Shape ... inputShapes) {
        this.beforeInitialize(inputShapes);
        for (Parameter parameter : this.getDirectParameters()) {
            parameter.initialize(manager, dataType, inputShapes);
        }
        return this.getOutputShapes(manager, inputShapes);
    }

    @Override
    public final BlockList getChildren() {
        return new BlockList();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        String className = this.getClass().getSimpleName();
        if (className.endsWith("Block")) {
            className = className.substring(0, className.length() - 5);
        }
        sb.append(className).append('(');
        if (this.isInitialized()) {
            PairList<String, Shape> inputShapes = this.describeInput();
            this.appendShape(sb, inputShapes.values().toArray(new Shape[0]));
            sb.append(" -> ");
            Shape[] outputShapes = this.getOutputShapes(null, inputShapes.values().toArray(new Shape[0]));
            this.appendShape(sb, outputShapes);
        } else {
            sb.append("Uninitialized");
        }
        sb.append(')');
        return sb.toString();
    }

    private void appendShape(StringBuilder sb, Shape[] shapes) {
        boolean first = true;
        for (Shape shape : shapes) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            long[] sh = shape.getShape();
            int length = sh.length;
            if (length == 0) {
                sb.append("()");
                continue;
            }
            int index = 0;
            if (sh[0] == -1L) {
                --length;
                index = 1;
            }
            if (length == 0) {
                sb.append("()");
                continue;
            }
            if (length == 1) {
                sb.append(sh[index]);
                continue;
            }
            sb.append('(');
            for (int i = index; i < sh.length; ++i) {
                if (i > index) {
                    sb.append(", ");
                }
                sb.append(sh[i]);
            }
            sb.append(')');
        }
    }
}

