/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.domain.valuerange;

import ai.timefold.solver.core.api.domain.valuerange.CountableValueRange;
import ai.timefold.solver.core.api.domain.valuerange.ValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.buildin.bigdecimal.BigDecimalValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.buildin.biginteger.BigIntegerValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.buildin.primboolean.BooleanValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.buildin.primdouble.DoubleValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.buildin.primint.IntValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.buildin.primlong.LongValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.buildin.temporal.TemporalValueRange;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import org.jspecify.annotations.NonNull;

public final class ValueRangeFactory {
    public static @NonNull CountableValueRange<Boolean> createBooleanValueRange() {
        return new BooleanValueRange();
    }

    public static @NonNull CountableValueRange<Integer> createIntValueRange(int from, int to) {
        return new IntValueRange(from, to);
    }

    public static @NonNull CountableValueRange<Integer> createIntValueRange(int from, int to, int incrementUnit) {
        return new IntValueRange(from, to, incrementUnit);
    }

    public static @NonNull CountableValueRange<Long> createLongValueRange(long from, long to) {
        return new LongValueRange(from, to);
    }

    public static @NonNull CountableValueRange<Long> createLongValueRange(long from, long to, long incrementUnit) {
        return new LongValueRange(from, to, incrementUnit);
    }

    @Deprecated(forRemoval=true, since="1.1.0")
    public static @NonNull ValueRange<Double> createDoubleValueRange(double from, double to) {
        return new DoubleValueRange(from, to);
    }

    public static @NonNull CountableValueRange<BigInteger> createBigIntegerValueRange(@NonNull BigInteger from, @NonNull BigInteger to) {
        return new BigIntegerValueRange(from, to);
    }

    public static @NonNull CountableValueRange<BigInteger> createBigIntegerValueRange(@NonNull BigInteger from, @NonNull BigInteger to, @NonNull BigInteger incrementUnit) {
        return new BigIntegerValueRange(from, to, incrementUnit);
    }

    public static @NonNull CountableValueRange<BigDecimal> createBigDecimalValueRange(@NonNull BigDecimal from, @NonNull BigDecimal to) {
        return new BigDecimalValueRange(from, to);
    }

    public static @NonNull CountableValueRange<BigDecimal> createBigDecimalValueRange(@NonNull BigDecimal from, @NonNull BigDecimal to, @NonNull BigDecimal incrementUnit) {
        return new BigDecimalValueRange(from, to, incrementUnit);
    }

    public static @NonNull CountableValueRange<LocalDate> createLocalDateValueRange(@NonNull LocalDate from, @NonNull LocalDate to, long incrementUnitAmount, @NonNull TemporalUnit incrementUnitType) {
        return ValueRangeFactory.createTemporalValueRange(from, to, incrementUnitAmount, incrementUnitType);
    }

    public static CountableValueRange<LocalTime> createLocalTimeValueRange(@NonNull LocalTime from, @NonNull LocalTime to, long incrementUnitAmount, @NonNull TemporalUnit incrementUnitType) {
        return ValueRangeFactory.createTemporalValueRange(from, to, incrementUnitAmount, incrementUnitType);
    }

    public static CountableValueRange<LocalDateTime> createLocalDateTimeValueRange(@NonNull LocalDateTime from, @NonNull LocalDateTime to, long incrementUnitAmount, @NonNull TemporalUnit incrementUnitType) {
        return ValueRangeFactory.createTemporalValueRange(from, to, incrementUnitAmount, incrementUnitType);
    }

    public static <Temporal_ extends Temporal & Comparable<? super Temporal_>> @NonNull CountableValueRange<Temporal_> createTemporalValueRange(@NonNull Temporal_ from, @NonNull Temporal_ to, long incrementUnitAmount, @NonNull TemporalUnit incrementUnitType) {
        return new TemporalValueRange<Temporal_>(from, to, incrementUnitAmount, incrementUnitType);
    }
}

