/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.score.analysis;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.analysis.ConstraintAnalysis;
import ai.timefold.solver.core.api.score.analysis.MatchAnalysis;
import ai.timefold.solver.core.api.score.constraint.ConstraintRef;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public record ScoreAnalysis<Score_ extends Score<Score_>>(@NonNull Score_ score, @NonNull Map<ConstraintRef, ConstraintAnalysis<Score_>> constraintMap, boolean isSolutionInitialized) {
    private static final Comparator<ConstraintAnalysis<?>> REVERSED_WEIGHT_COMPARATOR = Comparator.comparing(ConstraintAnalysis::weight).reversed();
    private static final Comparator<ConstraintAnalysis<?>> MAP_COMPARATOR = REVERSED_WEIGHT_COMPARATOR.thenComparing(ConstraintAnalysis::constraintRef);
    static final int DEFAULT_SUMMARY_CONSTRAINT_MATCH_LIMIT = 3;

    public ScoreAnalysis(@NonNull Score_ score, @NonNull Map<ConstraintRef, ConstraintAnalysis<Score_>> constraintMap) {
        this(score, constraintMap, true);
    }

    public ScoreAnalysis(@NonNull Score_ score, @NonNull Map<ConstraintRef, ConstraintAnalysis<Score_>> constraintMap, boolean isSolutionInitialized) {
        Objects.requireNonNull(score, "score");
        Objects.requireNonNull(constraintMap, "constraintMap");
        constraintMap = Collections.unmodifiableMap(constraintMap.values().stream().sorted(MAP_COMPARATOR).collect(Collectors.toMap(ConstraintAnalysis::constraintRef, Function.identity(), (constraintAnalysis, otherConstraintAnalysis) -> constraintAnalysis, LinkedHashMap::new)));
    }

    public @Nullable ConstraintAnalysis<Score_> getConstraintAnalysis(@NonNull ConstraintRef constraintRef) {
        return this.constraintMap.get(constraintRef);
    }

    @Deprecated(forRemoval=true, since="1.13.0")
    public @Nullable ConstraintAnalysis<Score_> getConstraintAnalysis(@NonNull String constraintPackage, @NonNull String constraintName) {
        return this.getConstraintAnalysis(ConstraintRef.of(constraintPackage, constraintName));
    }

    public @Nullable ConstraintAnalysis<Score_> getConstraintAnalysis(@NonNull String constraintName) {
        List<ConstraintAnalysis> constraintAnalysisList = this.constraintMap.entrySet().stream().filter(entry -> ((ConstraintRef)entry.getKey()).constraintName().equals(constraintName)).map(Map.Entry::getValue).toList();
        return switch (constraintAnalysisList.size()) {
            case 0 -> null;
            case 1 -> constraintAnalysisList.get(0);
            default -> throw new IllegalStateException("Multiple constraints with the same name (%s) are present in the score analysis.\nThis may be caused by the use of multiple constraint packages, a deprecated feature.\nPlease avoid using constraint packages and keep constraint names unique.".formatted(constraintName));
        };
    }

    public @NonNull ScoreAnalysis<Score_> diff(@NonNull ScoreAnalysis<Score_> other) {
        HashMap result = Stream.concat(this.constraintMap.keySet().stream(), other.constraintMap.keySet().stream()).distinct().flatMap(constraintRef -> {
            ConstraintAnalysis<Score_> otherConstraintAnalysis;
            ConstraintAnalysis<Score_> constraintAnalysis = this.getConstraintAnalysis((ConstraintRef)constraintRef);
            ConstraintAnalysis<Score_> diff = ConstraintAnalysis.diff(constraintRef, constraintAnalysis, otherConstraintAnalysis = other.getConstraintAnalysis((ConstraintRef)constraintRef));
            if (!diff.weight().isZero() || !diff.score().isZero()) {
                return Stream.of(diff);
            }
            if (diff.matches() == null) {
                if (diff.matchCount() == 0) {
                    return Stream.empty();
                }
                return Stream.of(diff);
            }
            if (!diff.matches().isEmpty()) {
                return Stream.of(diff);
            }
            return Stream.empty();
        }).collect(Collectors.toMap(ConstraintAnalysis::constraintRef, Function.identity(), (constraintRef, otherConstraintRef) -> constraintRef, HashMap::new));
        return new ScoreAnalysis<Score_>(this.score.subtract(other.score()), result, this.isSolutionInitialized);
    }

    public Collection<ConstraintAnalysis<Score_>> constraintAnalyses() {
        return this.constraintMap.values();
    }

    public @NonNull String summarize() {
        return this.buildSummary(3);
    }

    public @NonNull String summarize(int topLimit) {
        if (topLimit < 1) {
            throw new IllegalArgumentException("The topLimit (%d) must be at least 1.".formatted(topLimit));
        }
        return this.buildSummary(topLimit);
    }

    private @NonNull String buildSummary(int topLimit) {
        StringBuilder summary = new StringBuilder();
        summary.append("Explanation of score (%s):\n    Constraint matches:\n".formatted(this.score));
        Comparator<ConstraintAnalysis> constraintsScoreComparator = Comparator.comparing(ConstraintAnalysis::score);
        Comparator<MatchAnalysis> matchScoreComparator = Comparator.comparing(MatchAnalysis::score);
        this.constraintAnalyses().stream().sorted(constraintsScoreComparator).forEach(constraint -> {
            List matches = constraint.matches();
            if (matches == null) {
                throw new IllegalArgumentException("The constraint matches must be non-null.\nMaybe use ScoreAnalysisFetchPolicy.FETCH_ALL to request the score analysis\n");
            }
            if (matches.isEmpty()) {
                summary.append("%8s%s: constraint (%s) has no matches.\n".formatted(" ", constraint.score().toShortString(), constraint.constraintRef().constraintName()));
            } else {
                summary.append("%8s%s: constraint (%s) has %s matches:\n".formatted(" ", constraint.score().toShortString(), constraint.constraintRef().constraintName(), matches.size()));
            }
            matches.stream().sorted(matchScoreComparator).limit(topLimit).forEach(match -> summary.append("%12s%s: justified with (%s)\n".formatted(" ", match.score().toShortString(), match.justification())));
            if (matches.size() > topLimit) {
                summary.append("%12s... and %d more matches\n".formatted(" ", matches.size() - topLimit));
            }
        });
        return summary.toString();
    }

    @Override
    public String toString() {
        return "Score analysis of score %s with %d constraints.".formatted(this.score, this.constraintMap.size());
    }
}

