/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.score.buildin.bendablelong;

import ai.timefold.solver.core.api.score.IBendableScore;
import ai.timefold.solver.core.impl.score.ScoreUtil;
import java.util.Arrays;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class BendableLongScore
implements IBendableScore<BendableLongScore> {
    private final long[] hardScores;
    private final long[] softScores;

    public static BendableLongScore parseScore(String scoreString) {
        String[][] scoreTokens = ScoreUtil.parseBendableScoreTokens(BendableLongScore.class, scoreString);
        long[] hardScores = new long[scoreTokens[0].length];
        for (int i = 0; i < hardScores.length; ++i) {
            hardScores[i] = ScoreUtil.parseLevelAsLong(BendableLongScore.class, scoreString, scoreTokens[0][i]);
        }
        long[] softScores = new long[scoreTokens[1].length];
        for (int i = 0; i < softScores.length; ++i) {
            softScores[i] = ScoreUtil.parseLevelAsLong(BendableLongScore.class, scoreString, scoreTokens[1][i]);
        }
        return BendableLongScore.of(hardScores, softScores);
    }

    @Deprecated(forRemoval=true, since="1.22.0")
    public static BendableLongScore ofUninitialized(int initScore, long[] hardScores, long[] softScores) {
        return BendableLongScore.of(hardScores, softScores);
    }

    public static BendableLongScore of(long[] hardScores, long[] softScores) {
        return new BendableLongScore(hardScores, softScores);
    }

    public static BendableLongScore zero(int hardLevelsSize, int softLevelsSize) {
        return new BendableLongScore(new long[hardLevelsSize], new long[softLevelsSize]);
    }

    public static BendableLongScore ofHard(int hardLevelsSize, int softLevelsSize, int hardLevel, long hardScore) {
        long[] hardScores = new long[hardLevelsSize];
        hardScores[hardLevel] = hardScore;
        return new BendableLongScore(hardScores, new long[softLevelsSize]);
    }

    public static BendableLongScore ofSoft(int hardLevelsSize, int softLevelsSize, int softLevel, long softScore) {
        long[] softScores = new long[softLevelsSize];
        softScores[softLevel] = softScore;
        return new BendableLongScore(new long[hardLevelsSize], softScores);
    }

    private BendableLongScore() {
        this(new long[0], new long[0]);
    }

    private BendableLongScore(long[] hardScores, long[] softScores) {
        this.hardScores = hardScores;
        this.softScores = softScores;
    }

    public long[] hardScores() {
        return Arrays.copyOf(this.hardScores, this.hardScores.length);
    }

    @Deprecated(forRemoval=true)
    public long[] getHardScores() {
        return this.hardScores();
    }

    public long[] softScores() {
        return Arrays.copyOf(this.softScores, this.softScores.length);
    }

    @Deprecated(forRemoval=true)
    public long[] getSoftScores() {
        return this.softScores();
    }

    @Override
    public int hardLevelsSize() {
        return this.hardScores.length;
    }

    public long hardScore(int index) {
        return this.hardScores[index];
    }

    @Deprecated(forRemoval=true)
    public long getHardScore(int index) {
        return this.hardScore(index);
    }

    @Override
    public int softLevelsSize() {
        return this.softScores.length;
    }

    public long softScore(int index) {
        return this.softScores[index];
    }

    @Deprecated(forRemoval=true)
    public long getSoftScore(int index) {
        return this.softScore(index);
    }

    public long hardOrSoftScore(int index) {
        if (index < this.hardScores.length) {
            return this.hardScores[index];
        }
        return this.softScores[index - this.hardScores.length];
    }

    @Deprecated(forRemoval=true)
    public long getHardOrSoftScore(int index) {
        return this.hardOrSoftScore(index);
    }

    @Override
    public boolean isFeasible() {
        for (long hardScore : this.hardScores) {
            if (hardScore >= 0L) continue;
            return false;
        }
        return true;
    }

    @Override
    public BendableLongScore add(BendableLongScore addend) {
        int i;
        this.validateCompatible(addend);
        long[] newHardScores = new long[this.hardScores.length];
        long[] newSoftScores = new long[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = this.hardScores[i] + addend.hardScore(i);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = this.softScores[i] + addend.softScore(i);
        }
        return new BendableLongScore(newHardScores, newSoftScores);
    }

    @Override
    public BendableLongScore subtract(BendableLongScore subtrahend) {
        int i;
        this.validateCompatible(subtrahend);
        long[] newHardScores = new long[this.hardScores.length];
        long[] newSoftScores = new long[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = this.hardScores[i] - subtrahend.hardScore(i);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = this.softScores[i] - subtrahend.softScore(i);
        }
        return new BendableLongScore(newHardScores, newSoftScores);
    }

    @Override
    public BendableLongScore multiply(double multiplicand) {
        int i;
        long[] newHardScores = new long[this.hardScores.length];
        long[] newSoftScores = new long[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = (long)Math.floor((double)this.hardScores[i] * multiplicand);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = (long)Math.floor((double)this.softScores[i] * multiplicand);
        }
        return new BendableLongScore(newHardScores, newSoftScores);
    }

    @Override
    public BendableLongScore divide(double divisor) {
        int i;
        long[] newHardScores = new long[this.hardScores.length];
        long[] newSoftScores = new long[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = (long)Math.floor((double)this.hardScores[i] / divisor);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = (long)Math.floor((double)this.softScores[i] / divisor);
        }
        return new BendableLongScore(newHardScores, newSoftScores);
    }

    @Override
    public BendableLongScore power(double exponent) {
        int i;
        long[] newHardScores = new long[this.hardScores.length];
        long[] newSoftScores = new long[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = (long)Math.floor(Math.pow(this.hardScores[i], exponent));
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = (long)Math.floor(Math.pow(this.softScores[i], exponent));
        }
        return new BendableLongScore(newHardScores, newSoftScores);
    }

    @Override
    public BendableLongScore negate() {
        int i;
        long[] newHardScores = new long[this.hardScores.length];
        long[] newSoftScores = new long[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = -this.hardScores[i];
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = -this.softScores[i];
        }
        return new BendableLongScore(newHardScores, newSoftScores);
    }

    @Override
    public BendableLongScore abs() {
        int i;
        long[] newHardScores = new long[this.hardScores.length];
        long[] newSoftScores = new long[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = Math.abs(this.hardScores[i]);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = Math.abs(this.softScores[i]);
        }
        return new BendableLongScore(newHardScores, newSoftScores);
    }

    @Override
    public BendableLongScore zero() {
        return BendableLongScore.zero(this.hardLevelsSize(), this.softLevelsSize());
    }

    @Override
    public Number[] toLevelNumbers() {
        int i;
        Number[] levelNumbers = new Number[this.hardScores.length + this.softScores.length];
        for (i = 0; i < this.hardScores.length; ++i) {
            levelNumbers[i] = this.hardScores[i];
        }
        for (i = 0; i < this.softScores.length; ++i) {
            levelNumbers[this.hardScores.length + i] = this.softScores[i];
        }
        return levelNumbers;
    }

    public boolean equals(Object o) {
        if (o instanceof BendableLongScore) {
            int i;
            BendableLongScore other = (BendableLongScore)o;
            if (this.hardLevelsSize() != other.hardLevelsSize() || this.softLevelsSize() != other.softLevelsSize()) {
                return false;
            }
            for (i = 0; i < this.hardScores.length; ++i) {
                if (this.hardScores[i] == other.hardScore(i)) continue;
                return false;
            }
            for (i = 0; i < this.softScores.length; ++i) {
                if (this.softScores[i] == other.softScore(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.hardScores), Arrays.hashCode(this.softScores));
    }

    @Override
    public int compareTo(BendableLongScore other) {
        int i;
        this.validateCompatible(other);
        for (i = 0; i < this.hardScores.length; ++i) {
            if (this.hardScores[i] == other.hardScore(i)) continue;
            return Long.compare(this.hardScores[i], other.hardScore(i));
        }
        for (i = 0; i < this.softScores.length; ++i) {
            if (this.softScores[i] == other.softScore(i)) continue;
            return Long.compare(this.softScores[i], other.softScore(i));
        }
        return 0;
    }

    @Override
    public String toShortString() {
        return ScoreUtil.buildBendableShortString(this, n -> n.longValue() != 0L);
    }

    public String toString() {
        StringBuilder s = new StringBuilder((this.hardScores.length + this.softScores.length) * 4 + 7);
        s.append("[");
        boolean first = true;
        for (long hardScore : this.hardScores) {
            if (first) {
                first = false;
            } else {
                s.append("/");
            }
            s.append(hardScore);
        }
        s.append("]hard/[");
        first = true;
        for (long softScore : this.softScores) {
            if (first) {
                first = false;
            } else {
                s.append("/");
            }
            s.append(softScore);
        }
        s.append("]soft");
        return s.toString();
    }

    public void validateCompatible(BendableLongScore other) {
        if (this.hardLevelsSize() != other.hardLevelsSize()) {
            throw new IllegalArgumentException("The score (" + String.valueOf(this) + ") with hardScoreSize (" + this.hardLevelsSize() + ") is not compatible with the other score (" + String.valueOf(other) + ") with hardScoreSize (" + other.hardLevelsSize() + ").");
        }
        if (this.softLevelsSize() != other.softLevelsSize()) {
            throw new IllegalArgumentException("The score (" + String.valueOf(this) + ") with softScoreSize (" + this.softLevelsSize() + ") is not compatible with the other score (" + String.valueOf(other) + ") with softScoreSize (" + other.softLevelsSize() + ").");
        }
    }
}

