/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.score.buildin.hardsoftlong;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.score.ScoreUtil;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class HardSoftLongScore
implements Score<HardSoftLongScore> {
    public static final HardSoftLongScore ZERO = new HardSoftLongScore(0L, 0L);
    public static final HardSoftLongScore ONE_HARD = new HardSoftLongScore(1L, 0L);
    public static final HardSoftLongScore ONE_SOFT = new HardSoftLongScore(0L, 1L);
    private static final HardSoftLongScore MINUS_ONE_SOFT = new HardSoftLongScore(0L, -1L);
    private static final HardSoftLongScore MINUS_ONE_HARD = new HardSoftLongScore(-1L, 0L);
    private final long hardScore;
    private final long softScore;

    public static HardSoftLongScore parseScore(String scoreString) {
        String[] scoreTokens = ScoreUtil.parseScoreTokens(HardSoftLongScore.class, scoreString, "hard", "soft");
        long hardScore = ScoreUtil.parseLevelAsLong(HardSoftLongScore.class, scoreString, scoreTokens[0]);
        long softScore = ScoreUtil.parseLevelAsLong(HardSoftLongScore.class, scoreString, scoreTokens[1]);
        return HardSoftLongScore.of(hardScore, softScore);
    }

    @Deprecated(forRemoval=true, since="1.22.0")
    public static HardSoftLongScore ofUninitialized(int initScore, long hardScore, long softScore) {
        return HardSoftLongScore.of(hardScore, softScore);
    }

    public static HardSoftLongScore of(long hardScore, long softScore) {
        if (hardScore == 0L) {
            if (softScore == -1L) {
                return MINUS_ONE_SOFT;
            }
            if (softScore == 0L) {
                return ZERO;
            }
            if (softScore == 1L) {
                return ONE_SOFT;
            }
        } else if (softScore == 0L) {
            if (hardScore == 1L) {
                return ONE_HARD;
            }
            if (hardScore == -1L) {
                return MINUS_ONE_HARD;
            }
        }
        return new HardSoftLongScore(hardScore, softScore);
    }

    public static HardSoftLongScore ofHard(long hardScore) {
        if (hardScore == -1L) {
            return MINUS_ONE_HARD;
        }
        if (hardScore == 0L) {
            return ZERO;
        }
        if (hardScore == 1L) {
            return ONE_HARD;
        }
        return new HardSoftLongScore(hardScore, 0L);
    }

    public static HardSoftLongScore ofSoft(long softScore) {
        if (softScore == -1L) {
            return MINUS_ONE_SOFT;
        }
        if (softScore == 0L) {
            return ZERO;
        }
        if (softScore == 1L) {
            return ONE_SOFT;
        }
        return new HardSoftLongScore(0L, softScore);
    }

    private HardSoftLongScore() {
        this(Long.MIN_VALUE, Long.MIN_VALUE);
    }

    private HardSoftLongScore(long hardScore, long softScore) {
        this.hardScore = hardScore;
        this.softScore = softScore;
    }

    public long hardScore() {
        return this.hardScore;
    }

    @Deprecated(forRemoval=true)
    public long getHardScore() {
        return this.hardScore;
    }

    public long softScore() {
        return this.softScore;
    }

    @Deprecated(forRemoval=true)
    public long getSoftScore() {
        return this.softScore;
    }

    @Override
    public boolean isFeasible() {
        return this.hardScore >= 0L;
    }

    @Override
    public HardSoftLongScore add(HardSoftLongScore addend) {
        return HardSoftLongScore.of(this.hardScore + addend.hardScore(), this.softScore + addend.softScore());
    }

    @Override
    public HardSoftLongScore subtract(HardSoftLongScore subtrahend) {
        return HardSoftLongScore.of(this.hardScore - subtrahend.hardScore(), this.softScore - subtrahend.softScore());
    }

    @Override
    public HardSoftLongScore multiply(double multiplicand) {
        return HardSoftLongScore.of((long)Math.floor((double)this.hardScore * multiplicand), (long)Math.floor((double)this.softScore * multiplicand));
    }

    @Override
    public HardSoftLongScore divide(double divisor) {
        return HardSoftLongScore.of((long)Math.floor((double)this.hardScore / divisor), (long)Math.floor((double)this.softScore / divisor));
    }

    @Override
    public HardSoftLongScore power(double exponent) {
        return HardSoftLongScore.of((long)Math.floor(Math.pow(this.hardScore, exponent)), (long)Math.floor(Math.pow(this.softScore, exponent)));
    }

    @Override
    public HardSoftLongScore abs() {
        return HardSoftLongScore.of(Math.abs(this.hardScore), Math.abs(this.softScore));
    }

    @Override
    public HardSoftLongScore zero() {
        return ZERO;
    }

    @Override
    public Number[] toLevelNumbers() {
        return new Number[]{this.hardScore, this.softScore};
    }

    public boolean equals(Object o) {
        if (o instanceof HardSoftLongScore) {
            HardSoftLongScore other = (HardSoftLongScore)o;
            return this.hardScore == other.hardScore() && this.softScore == other.softScore();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.hardScore, this.softScore);
    }

    @Override
    public int compareTo(HardSoftLongScore other) {
        if (this.hardScore != other.hardScore()) {
            return Long.compare(this.hardScore, other.hardScore());
        }
        return Long.compare(this.softScore, other.softScore());
    }

    @Override
    public String toShortString() {
        return ScoreUtil.buildShortString(this, n -> n.longValue() != 0L, "hard", "soft");
    }

    public String toString() {
        return this.hardScore + "hard/" + this.softScore + "soft";
    }
}

