/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.score.buildin.simplelong;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.score.ScoreUtil;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class SimpleLongScore
implements Score<SimpleLongScore> {
    public static final SimpleLongScore ZERO = new SimpleLongScore(0L);
    public static final SimpleLongScore ONE = new SimpleLongScore(1L);
    public static final SimpleLongScore MINUS_ONE = new SimpleLongScore(-1L);
    private final long score;

    public static SimpleLongScore parseScore(String scoreString) {
        String[] scoreTokens = ScoreUtil.parseScoreTokens(SimpleLongScore.class, scoreString, "");
        long score = ScoreUtil.parseLevelAsLong(SimpleLongScore.class, scoreString, scoreTokens[0]);
        return SimpleLongScore.of(score);
    }

    @Deprecated(forRemoval=true, since="1.22.0")
    public static SimpleLongScore ofUninitialized(int initScore, long score) {
        return SimpleLongScore.of(score);
    }

    public static SimpleLongScore of(long score) {
        if (score == -1L) {
            return MINUS_ONE;
        }
        if (score == 0L) {
            return ZERO;
        }
        if (score == 1L) {
            return ONE;
        }
        return new SimpleLongScore(score);
    }

    private SimpleLongScore() {
        this(Long.MIN_VALUE);
    }

    private SimpleLongScore(long score) {
        this.score = score;
    }

    public long score() {
        return this.score;
    }

    @Deprecated(forRemoval=true)
    public long getScore() {
        return this.score;
    }

    @Override
    public SimpleLongScore add(SimpleLongScore addend) {
        return SimpleLongScore.of(this.score + addend.score());
    }

    @Override
    public SimpleLongScore subtract(SimpleLongScore subtrahend) {
        return SimpleLongScore.of(this.score - subtrahend.score());
    }

    @Override
    public SimpleLongScore multiply(double multiplicand) {
        return SimpleLongScore.of((long)Math.floor((double)this.score * multiplicand));
    }

    @Override
    public SimpleLongScore divide(double divisor) {
        return SimpleLongScore.of((long)Math.floor((double)this.score / divisor));
    }

    @Override
    public SimpleLongScore power(double exponent) {
        return SimpleLongScore.of((long)Math.floor(Math.pow(this.score, exponent)));
    }

    @Override
    public SimpleLongScore abs() {
        return SimpleLongScore.of(Math.abs(this.score));
    }

    @Override
    public SimpleLongScore zero() {
        return ZERO;
    }

    @Override
    public boolean isFeasible() {
        return true;
    }

    @Override
    public Number[] toLevelNumbers() {
        return new Number[]{this.score};
    }

    public boolean equals(Object o) {
        if (o instanceof SimpleLongScore) {
            SimpleLongScore other = (SimpleLongScore)o;
            return this.score == other.score();
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(this.score);
    }

    @Override
    public int compareTo(SimpleLongScore other) {
        return Long.compare(this.score, other.score());
    }

    @Override
    public String toShortString() {
        return ScoreUtil.buildShortString(this, n -> n.longValue() != 0L, "");
    }

    public String toString() {
        return Long.toString(this.score);
    }
}

