/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.score.constraint;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.constraint.ConstraintRef;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.api.score.stream.ConstraintJustification;
import ai.timefold.solver.core.api.score.stream.DefaultConstraintJustification;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class ConstraintMatch<Score_ extends Score<Score_>>
implements Comparable<ConstraintMatch<Score_>> {
    private final ConstraintRef constraintRef;
    private final ConstraintJustification justification;
    private final List<Object> indictedObjectList;
    private final Score_ score;

    @Deprecated(forRemoval=true)
    public ConstraintMatch(String constraintPackage, String constraintName, List<Object> justificationList, Score_ score) {
        this(constraintPackage, constraintName, DefaultConstraintJustification.of(score, justificationList), justificationList, score);
    }

    @Deprecated(forRemoval=true, since="1.4.0")
    public ConstraintMatch(String constraintPackage, String constraintName, ConstraintJustification justification, Collection<Object> indictedObjectList, Score_ score) {
        this(ConstraintRef.of(constraintPackage, constraintName), justification, indictedObjectList, score);
    }

    @Deprecated(forRemoval=true, since="1.4.0")
    public ConstraintMatch(Constraint constraint, ConstraintJustification justification, Collection<Object> indictedObjectList, Score_ score) {
        this(constraint.getConstraintRef(), justification, indictedObjectList, score);
    }

    @Deprecated(forRemoval=true, since="1.4.0")
    public ConstraintMatch(String constraintId, String constraintPackage, String constraintName, ConstraintJustification justification, Collection<Object> indictedObjectList, Score_ score) {
        this(new ConstraintRef(constraintPackage, constraintName, constraintId), justification, indictedObjectList, score);
    }

    public ConstraintMatch(@NonNull ConstraintRef constraintRef, @Nullable ConstraintJustification justification, @NonNull Collection<Object> indictedObjectList, @NonNull Score_ score) {
        List list;
        this.constraintRef = Objects.requireNonNull(constraintRef);
        this.justification = justification;
        Collection<Object> collection = Objects.requireNonNull(indictedObjectList);
        this.indictedObjectList = collection instanceof List ? (list = (List)collection) : List.copyOf(indictedObjectList);
        this.score = (Score)Objects.requireNonNull(score);
    }

    public @NonNull ConstraintRef getConstraintRef() {
        return this.constraintRef;
    }

    @Deprecated(forRemoval=true, since="1.4.0")
    public String getConstraintPackage() {
        return this.constraintRef.packageName();
    }

    @Deprecated(forRemoval=true, since="1.4.0")
    public String getConstraintName() {
        return this.constraintRef.constraintName();
    }

    @Deprecated(forRemoval=true, since="1.4.0")
    public String getConstraintId() {
        return this.constraintRef.constraintId();
    }

    @Deprecated(forRemoval=true)
    public List<Object> getJustificationList() {
        ConstraintJustification constraintJustification = this.justification;
        if (constraintJustification instanceof DefaultConstraintJustification) {
            DefaultConstraintJustification constraintJustification2 = (DefaultConstraintJustification)constraintJustification;
            return constraintJustification2.getFacts();
        }
        throw new IllegalStateException("Cannot retrieve list of facts from a custom constraint justification (" + String.valueOf(this.justification) + ").\nUse ConstraintMatch#getJustification() method instead.");
    }

    public <Justification_ extends ConstraintJustification> @Nullable Justification_ getJustification() {
        return (Justification_)this.justification;
    }

    public @NonNull List<Object> getIndictedObjectList() {
        return this.indictedObjectList;
    }

    public @NonNull Score_ getScore() {
        return this.score;
    }

    public String getIdentificationString() {
        return this.getConstraintRef().constraintId() + "/" + String.valueOf(this.justification);
    }

    @Override
    public int compareTo(ConstraintMatch<Score_> other) {
        if (!this.constraintRef.equals(other.constraintRef)) {
            return this.constraintRef.compareTo(other.constraintRef);
        }
        if (!this.score.equals(other.score)) {
            return this.score.compareTo(other.score);
        }
        if (this.justification == null) {
            return other.justification == null ? 0 : -1;
        }
        if (other.justification == null) {
            return 1;
        }
        ConstraintJustification constraintJustification = this.justification;
        if (constraintJustification instanceof Comparable) {
            Comparable comparable = (Comparable)((Object)constraintJustification);
            return comparable.compareTo(other.justification);
        }
        return Integer.compare(System.identityHashCode(this.justification), System.identityHashCode(other.justification));
    }

    public String toString() {
        return this.getIdentificationString() + "=" + String.valueOf(this.score);
    }
}

