/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.config.solver;

import ai.timefold.solver.core.api.domain.common.DomainAccessType;
import ai.timefold.solver.core.api.domain.solution.cloner.SolutionCloner;
import ai.timefold.solver.core.api.score.calculator.EasyScoreCalculator;
import ai.timefold.solver.core.api.score.stream.ConstraintProvider;
import ai.timefold.solver.core.api.score.stream.ConstraintStreamImplType;
import ai.timefold.solver.core.config.AbstractConfig;
import ai.timefold.solver.core.config.constructionheuristic.ConstructionHeuristicPhaseConfig;
import ai.timefold.solver.core.config.exhaustivesearch.ExhaustiveSearchPhaseConfig;
import ai.timefold.solver.core.config.localsearch.LocalSearchPhaseConfig;
import ai.timefold.solver.core.config.partitionedsearch.PartitionedSearchPhaseConfig;
import ai.timefold.solver.core.config.phase.NoChangePhaseConfig;
import ai.timefold.solver.core.config.phase.PhaseConfig;
import ai.timefold.solver.core.config.phase.custom.CustomPhaseConfig;
import ai.timefold.solver.core.config.score.director.ScoreDirectorFactoryConfig;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.config.solver.PreviewFeature;
import ai.timefold.solver.core.config.solver.monitoring.MonitoringConfig;
import ai.timefold.solver.core.config.solver.monitoring.SolverMetric;
import ai.timefold.solver.core.config.solver.random.RandomType;
import ai.timefold.solver.core.config.solver.termination.TerminationConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import ai.timefold.solver.core.impl.io.jaxb.SolverConfigIO;
import ai.timefold.solver.core.impl.io.jaxb.TimefoldXmlSerializationException;
import ai.timefold.solver.core.impl.phase.PhaseFactory;
import ai.timefold.solver.core.impl.solver.random.RandomFactory;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.time.Duration;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@XmlRootElement(name="solver")
@XmlType(name="solverConfig", propOrder={"enablePreviewFeatureSet", "environmentMode", "daemon", "randomType", "randomSeed", "randomFactoryClass", "moveThreadCount", "moveThreadBufferSize", "threadFactoryClass", "monitoringConfig", "solutionClass", "entityClassList", "domainAccessType", "scoreDirectorFactoryConfig", "terminationConfig", "nearbyDistanceMeterClass", "phaseConfigList"})
public class SolverConfig
extends AbstractConfig<SolverConfig> {
    public static final String XML_ELEMENT_NAME = "solver";
    public static final String XML_NAMESPACE = "https://timefold.ai/xsd/solver";
    public static final String XML_TYPE_NAME = "solverConfig";
    public static final String MOVE_THREAD_COUNT_NONE = "NONE";
    public static final String MOVE_THREAD_COUNT_AUTO = "AUTO";
    @XmlTransient
    private Clock clock = null;
    @XmlTransient
    private ClassLoader classLoader = null;
    @XmlElement(name="enablePreviewFeature")
    protected Set<PreviewFeature> enablePreviewFeatureSet = null;
    protected EnvironmentMode environmentMode = null;
    protected Boolean daemon = null;
    protected RandomType randomType = null;
    protected Long randomSeed = null;
    protected Class<? extends RandomFactory> randomFactoryClass = null;
    protected String moveThreadCount = null;
    protected Integer moveThreadBufferSize = null;
    protected Class<? extends ThreadFactory> threadFactoryClass = null;
    protected Class<?> solutionClass = null;
    @XmlElement(name="entityClass")
    protected List<Class<?>> entityClassList = null;
    protected DomainAccessType domainAccessType = null;
    @XmlTransient
    protected Map<String, MemberAccessor> gizmoMemberAccessorMap = null;
    @XmlTransient
    protected Map<String, SolutionCloner> gizmoSolutionClonerMap = null;
    @XmlElement(name="scoreDirectorFactory")
    protected ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = null;
    @XmlElement(name="termination")
    private TerminationConfig terminationConfig;
    protected Class<? extends NearbyDistanceMeter<?, ?>> nearbyDistanceMeterClass = null;
    @XmlElements(value={@XmlElement(name="constructionHeuristic", type=ConstructionHeuristicPhaseConfig.class), @XmlElement(name="customPhase", type=CustomPhaseConfig.class), @XmlElement(name="exhaustiveSearch", type=ExhaustiveSearchPhaseConfig.class), @XmlElement(name="localSearch", type=LocalSearchPhaseConfig.class), @XmlElement(name="noChangePhase", type=NoChangePhaseConfig.class), @XmlElement(name="partitionedSearch", type=PartitionedSearchPhaseConfig.class)})
    protected List<PhaseConfig> phaseConfigList = null;
    @XmlElement(name="monitoring")
    protected MonitoringConfig monitoringConfig = null;

    public static @NonNull SolverConfig createFromXmlResource(@NonNull String solverConfigResource) {
        return SolverConfig.createFromXmlResource(solverConfigResource, null);
    }

    public static @NonNull SolverConfig createFromXmlResource(@NonNull String solverConfigResource, @Nullable ClassLoader classLoader) {
        SolverConfig solverConfig;
        block11: {
            ClassLoader actualClassLoader = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
            InputStream in = actualClassLoader.getResourceAsStream(solverConfigResource);
            try {
                if (in == null) {
                    String errorMessage = "The solverConfigResource (" + solverConfigResource + ") does not exist as a classpath resource in the classLoader (" + String.valueOf(actualClassLoader) + ").";
                    if (solverConfigResource.startsWith("/")) {
                        errorMessage = errorMessage + "\nA classpath resource should not start with a slash (/). A solverConfigResource adheres to ClassLoader.getResource(String). Maybe remove the leading slash from the solverConfigResource.";
                    }
                    throw new IllegalArgumentException(errorMessage);
                }
                solverConfig = SolverConfig.createFromXmlInputStream(in, classLoader);
                if (in == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (TimefoldXmlSerializationException e) {
                    throw new IllegalArgumentException("Unmarshalling of solverConfigResource (" + solverConfigResource + ") fails.", e);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Reading the solverConfigResource (" + solverConfigResource + ") fails.", e);
                }
            }
            in.close();
        }
        return solverConfig;
    }

    public static @NonNull SolverConfig createFromXmlFile(@NonNull File solverConfigFile) {
        return SolverConfig.createFromXmlFile(solverConfigFile, null);
    }

    public static @NonNull SolverConfig createFromXmlFile(@NonNull File solverConfigFile, @Nullable ClassLoader classLoader) {
        SolverConfig solverConfig;
        FileInputStream in = new FileInputStream(solverConfigFile);
        try {
            solverConfig = SolverConfig.createFromXmlInputStream(in, classLoader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (TimefoldXmlSerializationException e) {
                throw new IllegalArgumentException("Unmarshalling the solverConfigFile (" + String.valueOf(solverConfigFile) + ") fails.", e);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("The solverConfigFile (" + String.valueOf(solverConfigFile) + ") was not found.", e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Reading the solverConfigFile (" + String.valueOf(solverConfigFile) + ") fails.", e);
            }
        }
        ((InputStream)in).close();
        return solverConfig;
    }

    public static @NonNull SolverConfig createFromXmlInputStream(@NonNull InputStream in) {
        return SolverConfig.createFromXmlInputStream(in, null);
    }

    public static @NonNull SolverConfig createFromXmlInputStream(@NonNull InputStream in, @Nullable ClassLoader classLoader) {
        SolverConfig solverConfig;
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        try {
            solverConfig = SolverConfig.createFromXmlReader(reader, classLoader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("This vm does not support the charset (" + String.valueOf(StandardCharsets.UTF_8) + ").", e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Reading solverConfigInputStream fails.", e);
            }
        }
        ((Reader)reader).close();
        return solverConfig;
    }

    public static @NonNull SolverConfig createFromXmlReader(@NonNull Reader reader) {
        return SolverConfig.createFromXmlReader(reader, null);
    }

    public static @NonNull SolverConfig createFromXmlReader(@NonNull Reader reader, @Nullable ClassLoader classLoader) {
        SolverConfigIO solverConfigIO = new SolverConfigIO();
        SolverConfig solverConfig = solverConfigIO.read(reader);
        solverConfig.setClassLoader(classLoader);
        return solverConfig;
    }

    public SolverConfig() {
    }

    public SolverConfig(@NonNull Clock clock) {
        this.clock = Objects.requireNonNull(clock);
    }

    public SolverConfig(@Nullable ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public SolverConfig(@NonNull SolverConfig inheritedConfig) {
        this.inherit(inheritedConfig);
    }

    public @Nullable Clock getClock() {
        return this.clock;
    }

    public void setClock(@Nullable Clock clock) {
        this.clock = clock;
    }

    public @Nullable ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(@Nullable ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public @Nullable Set<PreviewFeature> getEnablePreviewFeatureSet() {
        return this.enablePreviewFeatureSet;
    }

    public void setEnablePreviewFeatureSet(@Nullable Set<PreviewFeature> enablePreviewFeatureSet) {
        this.enablePreviewFeatureSet = enablePreviewFeatureSet;
    }

    public @Nullable EnvironmentMode getEnvironmentMode() {
        return this.environmentMode;
    }

    public void setEnvironmentMode(@Nullable EnvironmentMode environmentMode) {
        this.environmentMode = environmentMode;
    }

    public @Nullable Boolean getDaemon() {
        return this.daemon;
    }

    public void setDaemon(@Nullable Boolean daemon) {
        this.daemon = daemon;
    }

    public @Nullable RandomType getRandomType() {
        return this.randomType;
    }

    public void setRandomType(@Nullable RandomType randomType) {
        this.randomType = randomType;
    }

    public @Nullable Long getRandomSeed() {
        return this.randomSeed;
    }

    public void setRandomSeed(@Nullable Long randomSeed) {
        this.randomSeed = randomSeed;
    }

    public @Nullable Class<? extends RandomFactory> getRandomFactoryClass() {
        return this.randomFactoryClass;
    }

    public void setRandomFactoryClass(@Nullable Class<? extends RandomFactory> randomFactoryClass) {
        this.randomFactoryClass = randomFactoryClass;
    }

    public @Nullable String getMoveThreadCount() {
        return this.moveThreadCount;
    }

    public void setMoveThreadCount(@Nullable String moveThreadCount) {
        this.moveThreadCount = moveThreadCount;
    }

    public @Nullable Integer getMoveThreadBufferSize() {
        return this.moveThreadBufferSize;
    }

    public void setMoveThreadBufferSize(@Nullable Integer moveThreadBufferSize) {
        this.moveThreadBufferSize = moveThreadBufferSize;
    }

    public @Nullable Class<? extends ThreadFactory> getThreadFactoryClass() {
        return this.threadFactoryClass;
    }

    public void setThreadFactoryClass(@Nullable Class<? extends ThreadFactory> threadFactoryClass) {
        this.threadFactoryClass = threadFactoryClass;
    }

    public @Nullable Class<?> getSolutionClass() {
        return this.solutionClass;
    }

    public void setSolutionClass(@Nullable Class<?> solutionClass) {
        this.solutionClass = solutionClass;
    }

    public @Nullable List<Class<?>> getEntityClassList() {
        return this.entityClassList;
    }

    public void setEntityClassList(@Nullable List<Class<?>> entityClassList) {
        this.entityClassList = entityClassList;
    }

    public @Nullable DomainAccessType getDomainAccessType() {
        return this.domainAccessType;
    }

    public void setDomainAccessType(@Nullable DomainAccessType domainAccessType) {
        this.domainAccessType = domainAccessType;
    }

    public @Nullable Map<@NonNull String, @NonNull MemberAccessor> getGizmoMemberAccessorMap() {
        return this.gizmoMemberAccessorMap;
    }

    public void setGizmoMemberAccessorMap(@Nullable Map<@NonNull String, @NonNull MemberAccessor> gizmoMemberAccessorMap) {
        this.gizmoMemberAccessorMap = gizmoMemberAccessorMap;
    }

    public @Nullable Map<@NonNull String, @NonNull SolutionCloner> getGizmoSolutionClonerMap() {
        return this.gizmoSolutionClonerMap;
    }

    public void setGizmoSolutionClonerMap(@Nullable Map<@NonNull String, @NonNull SolutionCloner> gizmoSolutionClonerMap) {
        this.gizmoSolutionClonerMap = gizmoSolutionClonerMap;
    }

    public @Nullable ScoreDirectorFactoryConfig getScoreDirectorFactoryConfig() {
        return this.scoreDirectorFactoryConfig;
    }

    public void setScoreDirectorFactoryConfig(@Nullable ScoreDirectorFactoryConfig scoreDirectorFactoryConfig) {
        this.scoreDirectorFactoryConfig = scoreDirectorFactoryConfig;
    }

    public @Nullable TerminationConfig getTerminationConfig() {
        return this.terminationConfig;
    }

    public void setTerminationConfig(@Nullable TerminationConfig terminationConfig) {
        this.terminationConfig = terminationConfig;
    }

    public @Nullable Class<? extends NearbyDistanceMeter<?, ?>> getNearbyDistanceMeterClass() {
        return this.nearbyDistanceMeterClass;
    }

    public void setNearbyDistanceMeterClass(@Nullable Class<? extends NearbyDistanceMeter<?, ?>> nearbyDistanceMeterClass) {
        this.nearbyDistanceMeterClass = nearbyDistanceMeterClass;
    }

    public @Nullable List<@NonNull PhaseConfig> getPhaseConfigList() {
        return this.phaseConfigList;
    }

    public void setPhaseConfigList(@Nullable List<@NonNull PhaseConfig> phaseConfigList) {
        this.phaseConfigList = phaseConfigList;
    }

    public @Nullable MonitoringConfig getMonitoringConfig() {
        return this.monitoringConfig;
    }

    public void setMonitoringConfig(@Nullable MonitoringConfig monitoringConfig) {
        this.monitoringConfig = monitoringConfig;
    }

    public @NonNull SolverConfig withPreviewFeature(PreviewFeature ... previewFeature) {
        this.enablePreviewFeatureSet = EnumSet.copyOf(Arrays.asList(previewFeature));
        return this;
    }

    public @NonNull SolverConfig withEnvironmentMode(@NonNull EnvironmentMode environmentMode) {
        this.environmentMode = environmentMode;
        return this;
    }

    public @NonNull SolverConfig withDaemon(@NonNull Boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public @NonNull SolverConfig withRandomType(@NonNull RandomType randomType) {
        this.randomType = randomType;
        return this;
    }

    public @NonNull SolverConfig withRandomSeed(@NonNull Long randomSeed) {
        this.randomSeed = randomSeed;
        return this;
    }

    public @NonNull SolverConfig withRandomFactoryClass(@NonNull Class<? extends RandomFactory> randomFactoryClass) {
        this.randomFactoryClass = randomFactoryClass;
        return this;
    }

    public @NonNull SolverConfig withMoveThreadCount(@NonNull String moveThreadCount) {
        this.moveThreadCount = moveThreadCount;
        return this;
    }

    public @NonNull SolverConfig withMoveThreadBufferSize(@NonNull Integer moveThreadBufferSize) {
        this.moveThreadBufferSize = moveThreadBufferSize;
        return this;
    }

    public @NonNull SolverConfig withThreadFactoryClass(@NonNull Class<? extends ThreadFactory> threadFactoryClass) {
        this.threadFactoryClass = threadFactoryClass;
        return this;
    }

    public @NonNull SolverConfig withSolutionClass(@NonNull Class<?> solutionClass) {
        this.solutionClass = solutionClass;
        return this;
    }

    public @NonNull SolverConfig withEntityClassList(@NonNull List<Class<?>> entityClassList) {
        this.entityClassList = entityClassList;
        return this;
    }

    public @NonNull SolverConfig withEntityClasses(Class<?> ... entityClasses) {
        this.entityClassList = Arrays.asList(entityClasses);
        return this;
    }

    public @NonNull SolverConfig withDomainAccessType(@NonNull DomainAccessType domainAccessType) {
        this.domainAccessType = domainAccessType;
        return this;
    }

    public @NonNull SolverConfig withGizmoMemberAccessorMap(@NonNull Map<@NonNull String, @NonNull MemberAccessor> memberAccessorMap) {
        this.gizmoMemberAccessorMap = memberAccessorMap;
        return this;
    }

    public @NonNull SolverConfig withGizmoSolutionClonerMap(@NonNull Map<@NonNull String, @NonNull SolutionCloner> solutionClonerMap) {
        this.gizmoSolutionClonerMap = solutionClonerMap;
        return this;
    }

    public @NonNull SolverConfig withScoreDirectorFactory(@NonNull ScoreDirectorFactoryConfig scoreDirectorFactoryConfig) {
        this.scoreDirectorFactoryConfig = scoreDirectorFactoryConfig;
        return this;
    }

    public @NonNull SolverConfig withClassLoader(@NonNull ClassLoader classLoader) {
        this.setClassLoader(classLoader);
        return this;
    }

    public @NonNull SolverConfig withEasyScoreCalculatorClass(@NonNull Class<? extends EasyScoreCalculator> easyScoreCalculatorClass) {
        if (this.scoreDirectorFactoryConfig == null) {
            this.scoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig();
        }
        this.scoreDirectorFactoryConfig.setEasyScoreCalculatorClass(easyScoreCalculatorClass);
        return this;
    }

    public @NonNull SolverConfig withConstraintProviderClass(@NonNull Class<? extends ConstraintProvider> constraintProviderClass) {
        if (this.scoreDirectorFactoryConfig == null) {
            this.scoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig();
        }
        this.scoreDirectorFactoryConfig.setConstraintProviderClass(constraintProviderClass);
        return this;
    }

    public @NonNull SolverConfig withConstraintStreamImplType(@NonNull ConstraintStreamImplType constraintStreamImplType) {
        if (this.scoreDirectorFactoryConfig == null) {
            this.scoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig();
        }
        this.scoreDirectorFactoryConfig.setConstraintStreamImplType(constraintStreamImplType);
        return this;
    }

    public @NonNull SolverConfig withTerminationConfig(@NonNull TerminationConfig terminationConfig) {
        this.terminationConfig = terminationConfig;
        return this;
    }

    public @NonNull SolverConfig withTerminationSpentLimit(@NonNull Duration spentLimit) {
        if (this.terminationConfig == null) {
            this.terminationConfig = new TerminationConfig();
        }
        this.terminationConfig.setSpentLimit(spentLimit);
        return this;
    }

    public @NonNull SolverConfig withTerminationUnimprovedSpentLimit(@NonNull Duration unimprovedSpentLimit) {
        if (this.terminationConfig == null) {
            this.terminationConfig = new TerminationConfig();
        }
        this.terminationConfig.setUnimprovedSpentLimit(unimprovedSpentLimit);
        return this;
    }

    public @NonNull SolverConfig withNearbyDistanceMeterClass(@NonNull Class<? extends NearbyDistanceMeter<?, ?>> distanceMeterClass) {
        this.nearbyDistanceMeterClass = distanceMeterClass;
        return this;
    }

    public @NonNull SolverConfig withPhaseList(@NonNull List<@NonNull PhaseConfig> phaseConfigList) {
        this.phaseConfigList = phaseConfigList;
        return this;
    }

    public @NonNull SolverConfig withPhases(PhaseConfig ... phaseConfigs) {
        this.phaseConfigList = Arrays.asList(phaseConfigs);
        return this;
    }

    public @NonNull SolverConfig withMonitoringConfig(@NonNull MonitoringConfig monitoringConfig) {
        this.monitoringConfig = monitoringConfig;
        return this;
    }

    public boolean canTerminate() {
        if (this.terminationConfig != null && this.terminationConfig.isConfigured()) {
            return true;
        }
        List<PhaseConfig> configList = this.getPhaseConfigList();
        if (configList == null) {
            return true;
        }
        return configList.stream().allMatch(PhaseFactory::canTerminate);
    }

    public @NonNull EnvironmentMode determineEnvironmentMode() {
        return Objects.requireNonNullElse(this.environmentMode, EnvironmentMode.PHASE_ASSERT);
    }

    public @NonNull DomainAccessType determineDomainAccessType() {
        return Objects.requireNonNullElse(this.domainAccessType, DomainAccessType.REFLECTION);
    }

    public @NonNull MonitoringConfig determineMetricConfig() {
        return Objects.requireNonNullElse(this.monitoringConfig, new MonitoringConfig().withSolverMetricList(Arrays.asList(SolverMetric.SOLVE_DURATION, SolverMetric.ERROR_COUNT, SolverMetric.SCORE_CALCULATION_COUNT, SolverMetric.MOVE_EVALUATION_COUNT, SolverMetric.PROBLEM_ENTITY_COUNT, SolverMetric.PROBLEM_VARIABLE_COUNT, SolverMetric.PROBLEM_VALUE_COUNT, SolverMetric.PROBLEM_SIZE_LOG)));
    }

    public void offerRandomSeedFromSubSingleIndex(long subSingleIndex) {
        if ((this.environmentMode == null || this.environmentMode.isReproducible()) && this.randomFactoryClass == null && this.randomSeed == null) {
            this.randomSeed = subSingleIndex;
        }
    }

    @Override
    public @NonNull SolverConfig inherit(@NonNull SolverConfig inheritedConfig) {
        this.clock = ConfigUtils.inheritOverwritableProperty(this.clock, inheritedConfig.getClock());
        this.classLoader = ConfigUtils.inheritOverwritableProperty(this.classLoader, inheritedConfig.getClassLoader());
        this.enablePreviewFeatureSet = ConfigUtils.inheritMergeableEnumSetProperty(this.enablePreviewFeatureSet, inheritedConfig.getEnablePreviewFeatureSet());
        this.environmentMode = ConfigUtils.inheritOverwritableProperty(this.environmentMode, inheritedConfig.getEnvironmentMode());
        this.daemon = ConfigUtils.inheritOverwritableProperty(this.daemon, inheritedConfig.getDaemon());
        this.randomType = ConfigUtils.inheritOverwritableProperty(this.randomType, inheritedConfig.getRandomType());
        this.randomSeed = ConfigUtils.inheritOverwritableProperty(this.randomSeed, inheritedConfig.getRandomSeed());
        this.randomFactoryClass = ConfigUtils.inheritOverwritableProperty(this.randomFactoryClass, inheritedConfig.getRandomFactoryClass());
        this.moveThreadCount = ConfigUtils.inheritOverwritableProperty(this.moveThreadCount, inheritedConfig.getMoveThreadCount());
        this.moveThreadBufferSize = ConfigUtils.inheritOverwritableProperty(this.moveThreadBufferSize, inheritedConfig.getMoveThreadBufferSize());
        this.threadFactoryClass = ConfigUtils.inheritOverwritableProperty(this.threadFactoryClass, inheritedConfig.getThreadFactoryClass());
        this.solutionClass = ConfigUtils.inheritOverwritableProperty(this.solutionClass, inheritedConfig.getSolutionClass());
        this.entityClassList = ConfigUtils.inheritMergeableListProperty(this.entityClassList, inheritedConfig.getEntityClassList());
        this.domainAccessType = ConfigUtils.inheritOverwritableProperty(this.domainAccessType, inheritedConfig.getDomainAccessType());
        this.gizmoMemberAccessorMap = ConfigUtils.inheritMergeableMapProperty(this.gizmoMemberAccessorMap, inheritedConfig.getGizmoMemberAccessorMap());
        this.gizmoSolutionClonerMap = ConfigUtils.inheritMergeableMapProperty(this.gizmoSolutionClonerMap, inheritedConfig.getGizmoSolutionClonerMap());
        this.scoreDirectorFactoryConfig = ConfigUtils.inheritConfig(this.scoreDirectorFactoryConfig, inheritedConfig.getScoreDirectorFactoryConfig());
        this.terminationConfig = ConfigUtils.inheritConfig(this.terminationConfig, inheritedConfig.getTerminationConfig());
        this.nearbyDistanceMeterClass = ConfigUtils.inheritOverwritableProperty(this.nearbyDistanceMeterClass, inheritedConfig.getNearbyDistanceMeterClass());
        this.phaseConfigList = ConfigUtils.inheritMergeableListConfig(this.phaseConfigList, inheritedConfig.getPhaseConfigList());
        this.monitoringConfig = ConfigUtils.inheritConfig(this.monitoringConfig, inheritedConfig.getMonitoringConfig());
        return this;
    }

    @Override
    public @NonNull SolverConfig copyConfig() {
        return new SolverConfig().inherit(this);
    }

    @Override
    public void visitReferencedClasses(@NonNull Consumer<Class<?>> classVisitor) {
        classVisitor.accept(this.randomFactoryClass);
        classVisitor.accept(this.threadFactoryClass);
        classVisitor.accept(this.solutionClass);
        if (this.entityClassList != null) {
            this.entityClassList.forEach(classVisitor);
        }
        if (this.scoreDirectorFactoryConfig != null) {
            this.scoreDirectorFactoryConfig.visitReferencedClasses(classVisitor);
        }
        if (this.nearbyDistanceMeterClass != null) {
            classVisitor.accept(this.nearbyDistanceMeterClass);
        }
        if (this.terminationConfig != null) {
            this.terminationConfig.visitReferencedClasses(classVisitor);
        }
        if (this.phaseConfigList != null) {
            this.phaseConfigList.forEach(pc -> pc.visitReferencedClasses(classVisitor));
        }
    }
}

