/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.config.solver;

import ai.timefold.solver.core.config.AbstractConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import jakarta.xml.bind.annotation.XmlType;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlType(propOrder={"parallelSolverCount", "threadFactoryClass"})
public class SolverManagerConfig
extends AbstractConfig<SolverManagerConfig> {
    public static final String PARALLEL_SOLVER_COUNT_AUTO = "AUTO";
    private static final Logger LOGGER = LoggerFactory.getLogger(SolverManagerConfig.class);
    protected String parallelSolverCount = null;
    protected Class<? extends ThreadFactory> threadFactoryClass = null;

    public @Nullable String getParallelSolverCount() {
        return this.parallelSolverCount;
    }

    public void setParallelSolverCount(@Nullable String parallelSolverCount) {
        this.parallelSolverCount = parallelSolverCount;
    }

    public @Nullable Class<? extends ThreadFactory> getThreadFactoryClass() {
        return this.threadFactoryClass;
    }

    public void setThreadFactoryClass(@Nullable Class<? extends ThreadFactory> threadFactoryClass) {
        this.threadFactoryClass = threadFactoryClass;
    }

    public @NonNull SolverManagerConfig withParallelSolverCount(@NonNull String parallelSolverCount) {
        this.parallelSolverCount = parallelSolverCount;
        return this;
    }

    public @NonNull SolverManagerConfig withThreadFactoryClass(@NonNull Class<? extends ThreadFactory> threadFactoryClass) {
        this.threadFactoryClass = threadFactoryClass;
        return this;
    }

    public @NonNull Integer resolveParallelSolverCount() {
        int availableProcessorCount = this.getAvailableProcessors();
        Integer resolvedParallelSolverCount = this.parallelSolverCount == null || this.parallelSolverCount.equals(PARALLEL_SOLVER_COUNT_AUTO) ? Integer.valueOf(this.resolveParallelSolverCountAutomatically(availableProcessorCount)) : Integer.valueOf(ConfigUtils.resolvePoolSize("parallelSolverCount", this.parallelSolverCount, PARALLEL_SOLVER_COUNT_AUTO));
        if (resolvedParallelSolverCount < 1) {
            throw new IllegalArgumentException("The parallelSolverCount (" + this.parallelSolverCount + ") resulted in a resolvedParallelSolverCount (" + resolvedParallelSolverCount + ") that is lower than 1.");
        }
        if (resolvedParallelSolverCount > availableProcessorCount) {
            LOGGER.warn("The resolvedParallelSolverCount ({}) is higher than the availableProcessorCount ({}), which is counter-efficient.", (Object)resolvedParallelSolverCount, (Object)availableProcessorCount);
        }
        return resolvedParallelSolverCount;
    }

    protected int getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    protected int resolveParallelSolverCountAutomatically(int availableProcessorCount) {
        if (availableProcessorCount < 2) {
            return 1;
        }
        return availableProcessorCount / 2;
    }

    @Override
    public @NonNull SolverManagerConfig inherit(@NonNull SolverManagerConfig inheritedConfig) {
        this.parallelSolverCount = ConfigUtils.inheritOverwritableProperty(this.parallelSolverCount, inheritedConfig.getParallelSolverCount());
        this.threadFactoryClass = ConfigUtils.inheritOverwritableProperty(this.threadFactoryClass, inheritedConfig.getThreadFactoryClass());
        return this;
    }

    @Override
    public @NonNull SolverManagerConfig copyConfig() {
        return new SolverManagerConfig().inherit(this);
    }

    @Override
    public void visitReferencedClasses(@NonNull Consumer<Class<?>> classVisitor) {
        classVisitor.accept(this.threadFactoryClass);
    }
}

