/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.config.solver.monitoring;

import ai.timefold.solver.core.api.solver.Solver;
import ai.timefold.solver.core.impl.solver.monitoring.statistic.BestScoreStatistic;
import ai.timefold.solver.core.impl.solver.monitoring.statistic.BestSolutionMutationCountStatistic;
import ai.timefold.solver.core.impl.solver.monitoring.statistic.MemoryUseStatistic;
import ai.timefold.solver.core.impl.solver.monitoring.statistic.MoveCountPerTypeStatistic;
import ai.timefold.solver.core.impl.solver.monitoring.statistic.PickedMoveBestScoreDiffStatistic;
import ai.timefold.solver.core.impl.solver.monitoring.statistic.PickedMoveStepScoreDiffStatistic;
import ai.timefold.solver.core.impl.solver.monitoring.statistic.SolverScopeStatistic;
import ai.timefold.solver.core.impl.solver.monitoring.statistic.SolverStatistic;
import ai.timefold.solver.core.impl.solver.monitoring.statistic.StatelessSolverStatistic;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import jakarta.xml.bind.annotation.XmlEnum;
import java.util.function.ToDoubleFunction;
import org.jspecify.annotations.NonNull;

@XmlEnum
public enum SolverMetric {
    SOLVE_DURATION("timefold.solver.solve.duration", false),
    ERROR_COUNT("timefold.solver.errors", false),
    SCORE_CALCULATION_COUNT("timefold.solver.score.calculation.count", SolverScope::getScoreCalculationCount, false),
    MOVE_EVALUATION_COUNT("timefold.solver.move.evaluation.count", SolverScope::getMoveEvaluationCount, false),
    PROBLEM_ENTITY_COUNT("timefold.solver.problem.entities", solverScope -> solverScope.getProblemSizeStatistics().entityCount(), false),
    PROBLEM_VARIABLE_COUNT("timefold.solver.problem.variables", solverScope -> solverScope.getProblemSizeStatistics().variableCount(), false),
    PROBLEM_VALUE_COUNT("timefold.solver.problem.values", solverScope -> solverScope.getProblemSizeStatistics().approximateValueCount(), false),
    PROBLEM_SIZE_LOG("timefold.solver.problem.size.log", solverScope -> solverScope.getProblemSizeStatistics().approximateProblemSizeLog(), false),
    BEST_SCORE("timefold.solver.best.score", new BestScoreStatistic<Solution_>(), true),
    STEP_SCORE("timefold.solver.step.score", false),
    BEST_SOLUTION_MUTATION("timefold.solver.best.solution.mutation", new BestSolutionMutationCountStatistic<Solution_>(), true),
    MOVE_COUNT_PER_STEP("timefold.solver.step.move.count", false),
    MOVE_COUNT_PER_TYPE("timefold.solver.move.type.count", new MoveCountPerTypeStatistic<Solution_>(), false),
    MEMORY_USE("jvm.memory.used", new MemoryUseStatistic<Solution_>(), false),
    CONSTRAINT_MATCH_TOTAL_BEST_SCORE("timefold.solver.constraint.match.best.score", true, true),
    CONSTRAINT_MATCH_TOTAL_STEP_SCORE("timefold.solver.constraint.match.step.score", false, true),
    PICKED_MOVE_TYPE_BEST_SCORE_DIFF("timefold.solver.move.type.best.score.diff", new PickedMoveBestScoreDiffStatistic<Solution_, Score_>(), true),
    PICKED_MOVE_TYPE_STEP_SCORE_DIFF("timefold.solver.move.type.step.score.diff", new PickedMoveStepScoreDiffStatistic<Solution_>(), false);

    private final String meterId;
    private final SolverStatistic registerFunction;
    private final boolean isBestSolutionBased;
    private final boolean isConstraintMatchBased;

    private SolverMetric(String meterId, boolean isBestSolutionBased) {
        this(meterId, isBestSolutionBased, false);
    }

    private SolverMetric(String meterId, boolean isBestSolutionBased, boolean isConstraintMatchBased) {
        this(meterId, new StatelessSolverStatistic(), isBestSolutionBased, isConstraintMatchBased);
    }

    private SolverMetric(String meterId, ToDoubleFunction<SolverScope<Object>> gaugeFunction, boolean isBestSolutionBased) {
        this(meterId, new SolverScopeStatistic(meterId, gaugeFunction), isBestSolutionBased, false);
    }

    private SolverMetric(String meterId, SolverStatistic<?> registerFunction, boolean isBestSolutionBased) {
        this(meterId, registerFunction, isBestSolutionBased, false);
    }

    private SolverMetric(String meterId, SolverStatistic<?> registerFunction, boolean isBestSolutionBased, boolean isConstraintMatchBased) {
        this.meterId = meterId;
        this.registerFunction = registerFunction;
        this.isBestSolutionBased = isBestSolutionBased;
        this.isConstraintMatchBased = isConstraintMatchBased;
    }

    public @NonNull String getMeterId() {
        return this.meterId;
    }

    public boolean isMetricBestSolutionBased() {
        return this.isBestSolutionBased;
    }

    public boolean isMetricConstraintMatchBased() {
        return this.isConstraintMatchBased;
    }

    public void register(@NonNull Solver<?> solver) {
        this.registerFunction.register(solver);
    }

    public void unregister(@NonNull Solver<?> solver) {
        this.registerFunction.unregister(solver);
    }
}

