/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.uni;

import ai.timefold.solver.core.impl.bavet.common.AbstractNode;
import ai.timefold.solver.core.impl.bavet.common.Propagator;
import ai.timefold.solver.core.impl.bavet.common.StaticPropagationQueue;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleState;
import ai.timefold.solver.core.impl.bavet.common.tuple.UniTuple;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@NullMarked
public abstract class AbstractForEachUniNode<A>
extends AbstractNode {
    private final Class<A> forEachClass;
    private final int outputStoreSize;
    private final StaticPropagationQueue<UniTuple<A>> propagationQueue;
    protected final Map<A, UniTuple<A>> tupleMap = new IdentityHashMap<A, UniTuple<A>>(1000);

    protected AbstractForEachUniNode(Class<A> forEachClass, TupleLifecycle<UniTuple<A>> nextNodesTupleLifecycle, int outputStoreSize) {
        this.forEachClass = forEachClass;
        this.outputStoreSize = outputStoreSize;
        this.propagationQueue = new StaticPropagationQueue<UniTuple<A>>(nextNodesTupleLifecycle);
    }

    public void insert(@Nullable A a) {
        UniTuple<A> tuple = new UniTuple<A>(a, this.outputStoreSize);
        UniTuple<A> old = this.tupleMap.put(a, tuple);
        if (old != null) {
            throw new IllegalStateException("The fact (%s) was already inserted, so it cannot insert again.".formatted(a));
        }
        this.propagationQueue.insert(tuple);
    }

    public abstract void update(@Nullable A var1);

    protected final void updateExisting(@Nullable A a, UniTuple<A> tuple) {
        TupleState state = tuple.state;
        if (state.isDirty()) {
            if (state == TupleState.DYING || state == TupleState.ABORTING) {
                throw new IllegalStateException("The fact (%s) was retracted, so it cannot update.".formatted(a));
            }
        } else {
            this.propagationQueue.update(tuple);
        }
    }

    public void retract(@Nullable A a) {
        UniTuple<A> tuple = this.tupleMap.remove(a);
        if (tuple == null) {
            throw new IllegalStateException("The fact (%s) was never inserted, so it cannot retract.".formatted(a));
        }
        this.retractExisting(a, tuple);
    }

    protected void retractExisting(@Nullable A a, UniTuple<A> tuple) {
        TupleState state = tuple.state;
        if (state.isDirty()) {
            if (state == TupleState.DYING || state == TupleState.ABORTING) {
                throw new IllegalStateException("The fact (%s) was already retracted, so it cannot retract.".formatted(a));
            }
            this.propagationQueue.retract(tuple, state == TupleState.CREATING ? TupleState.ABORTING : TupleState.DYING);
        } else {
            this.propagationQueue.retract(tuple, TupleState.DYING);
        }
    }

    @Override
    public Propagator getPropagator() {
        return this.propagationQueue;
    }

    public final Class<A> getForEachClass() {
        return this.forEachClass;
    }

    public abstract boolean supports(LifecycleOperation var1);

    @Override
    public final String toString() {
        return "%s(%s)".formatted(this.getClass().getSimpleName(), this.forEachClass.getSimpleName());
    }

    public static enum LifecycleOperation {
        INSERT,
        UPDATE,
        RETRACT;

    }
}

