/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.constructionheuristic.placer;

import ai.timefold.solver.core.impl.constructionheuristic.placer.AbstractEntityPlacer;
import ai.timefold.solver.core.impl.constructionheuristic.placer.EntityPlacer;
import ai.timefold.solver.core.impl.constructionheuristic.placer.EntityPlacerFactory;
import ai.timefold.solver.core.impl.constructionheuristic.placer.Placement;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.decorator.FilteringEntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.factory.MoveIteratorFactory;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class QueuedEntityPlacer<Solution_>
extends AbstractEntityPlacer<Solution_>
implements EntityPlacer<Solution_> {
    protected final EntitySelector<Solution_> entitySelector;
    protected final List<MoveSelector<Solution_>> moveSelectorList;

    public QueuedEntityPlacer(EntityPlacerFactory<Solution_> factory, HeuristicConfigPolicy<Solution_> configPolicy, EntitySelector<Solution_> entitySelector, List<MoveSelector<Solution_>> moveSelectorList) {
        super(factory, configPolicy);
        this.entitySelector = entitySelector;
        this.moveSelectorList = moveSelectorList;
        this.phaseLifecycleSupport.addEventListener(entitySelector);
        for (MoveSelector<Solution_> moveSelector : moveSelectorList) {
            this.phaseLifecycleSupport.addEventListener(moveSelector);
        }
    }

    @Override
    public Iterator<Placement<Solution_>> iterator() {
        return new QueuedEntityPlacingIterator(this.entitySelector.iterator());
    }

    @Override
    public EntityPlacer<Solution_> rebuildWithFilter(SelectionFilter<Solution_, Object> filter) {
        return new QueuedEntityPlacer<Solution_>(this.factory, this.configPolicy, FilteringEntitySelector.of(this.entitySelector, filter), this.moveSelectorList);
    }

    private class QueuedEntityPlacingIterator
    extends UpcomingSelectionIterator<Placement<Solution_>> {
        private final Iterator<Object> entityIterator;
        private Iterator<MoveSelector<Solution_>> moveSelectorIterator;

        private QueuedEntityPlacingIterator(Iterator<Object> entityIterator) {
            this.entityIterator = entityIterator;
            this.moveSelectorIterator = Collections.emptyIterator();
        }

        @Override
        protected Placement<Solution_> createUpcomingSelection() {
            Iterator moveIterator = null;
            while (moveIterator == null || !moveIterator.hasNext()) {
                while (!this.moveSelectorIterator.hasNext()) {
                    if (!this.entityIterator.hasNext()) {
                        return (Placement)this.noUpcomingSelection();
                    }
                    this.entityIterator.next();
                    this.moveSelectorIterator = QueuedEntityPlacer.this.moveSelectorList.iterator();
                }
                MoveSelector moveSelector = this.moveSelectorIterator.next();
                moveIterator = moveSelector.iterator();
            }
            return new Placement(MoveIteratorFactory.adaptIterator(moveIterator));
        }
    }
}

