/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.common.accessor.gizmo;

import java.util.HashMap;
import java.util.Map;

public final class GizmoClassLoader
extends ClassLoader {
    private final Map<String, byte[]> classNameToBytecodeMap;

    public GizmoClassLoader() {
        this(new HashMap<String, byte[]>());
    }

    public GizmoClassLoader(Map<String, byte[]> classNameToBytecodeMap) {
        super(GizmoClassLoader.class.getClassLoader());
        this.classNameToBytecodeMap = classNameToBytecodeMap;
    }

    @Override
    public String getName() {
        return "Timefold Solver Gizmo ClassLoader";
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] byteCode = this.getBytecodeFor(name);
        if (byteCode == null) {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        return this.defineClass(name, byteCode, 0, byteCode.length);
    }

    public synchronized byte[] getBytecodeFor(String className) {
        return this.classNameToBytecodeMap.get(className);
    }

    public boolean hasBytecodeFor(String className) {
        return this.getBytecodeFor(className) != null;
    }

    public synchronized void storeBytecode(String className, byte[] bytecode) {
        this.classNameToBytecodeMap.put(className, bytecode);
    }
}

