/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.entity.descriptor;

import ai.timefold.solver.core.api.domain.entity.PlanningEntity;
import ai.timefold.solver.core.api.domain.entity.PlanningPin;
import ai.timefold.solver.core.api.domain.entity.PlanningPinToIndex;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EntityDescriptorValidator {
    private static final Class[] ADDITIONAL_VARIABLE_ANNOTATION_CLASSES = new Class[]{PlanningPin.class, PlanningPinToIndex.class};

    private EntityDescriptorValidator() {
    }

    public static void assertNotMixedInheritance(Class<?> entityClass, List<Class<?>> declaredInheritedEntityClassList) {
        if (declaredInheritedEntityClassList.isEmpty()) {
            return;
        }
        boolean hasClass = false;
        boolean hasInterface = false;
        for (Class<?> declaredEntityClass : declaredInheritedEntityClassList) {
            if (!hasClass && !declaredEntityClass.isInterface()) {
                hasClass = true;
            }
            if (!hasInterface && declaredEntityClass.isInterface()) {
                hasInterface = true;
            }
            if (!hasClass || !hasInterface) continue;
            break;
        }
        if (hasClass && hasInterface) {
            List<String> classes = declaredInheritedEntityClassList.stream().filter(clazz -> !clazz.isInterface()).map(Class::getSimpleName).toList();
            List<String> interfaces = declaredInheritedEntityClassList.stream().filter(Class::isInterface).map(Class::getSimpleName).toList();
            throw new IllegalStateException("The class %s extends another class marked as an entity (%s) and also implements an interface that is annotated as an entity (%s). Mixed inheritance is not permitted.\nMaybe remove either the entity class or one of the entity interfaces from the inheritance chain.".formatted(classes, interfaces, entityClass));
        }
    }

    public static void assertSingleInheritance(Class<?> entityClass, List<Class<?>> declaredInheritedEntityClassList) {
        if (declaredInheritedEntityClassList.size() > 1) {
            List<String> classes = declaredInheritedEntityClassList.stream().filter(clazz -> !clazz.isInterface()).map(Class::getSimpleName).toList();
            List<String> interfaces = declaredInheritedEntityClassList.stream().filter(Class::isInterface).map(Class::getSimpleName).toList();
            throw new IllegalStateException("The class %s inherits its @%s annotation both from entities (%s) and interfaces (%s).\nRemove either the entity classes or entity interfaces from the inheritance chain to create a single-level inheritance structure.".formatted(entityClass.getName(), PlanningEntity.class.getSimpleName(), classes, interfaces));
        }
    }

    public static void assertValidPlanningVariables(Class<?> clazz) {
        if (clazz.getAnnotation(PlanningEntity.class) == null && EntityDescriptorValidator.hasAnyGenuineOrShadowVariables(clazz)) {
            List<String> planningVariables = EntityDescriptorValidator.extractPlanningVariables(clazz).stream().map(Member::getName).toList();
            throw new IllegalStateException("The class %s is not annotated with @PlanningEntity but defines genuine or shadow variables.\nMaybe annotate %s with @PlanningEntity.\nMaybe remove the planning variables (%s).".formatted(clazz.getName(), clazz.getName(), planningVariables));
        }
        ArrayList classList = new ArrayList();
        classList.add(clazz.getSuperclass());
        classList.addAll(Arrays.asList(clazz.getInterfaces()));
        for (Class clazz2 : classList) {
            if (clazz2 == null || clazz2.getAnnotation(PlanningEntity.class) != null || !EntityDescriptorValidator.hasAnyGenuineOrShadowVariables(clazz2)) continue;
            List<String> planningVariables = EntityDescriptorValidator.extractPlanningVariables(clazz2).stream().map(Member::getName).toList();
            throw new IllegalStateException("The class %s is not annotated with @PlanningEntity but defines genuine or shadow variables.\nMaybe annotate %s with @PlanningEntity.\nMaybe remove the planning variables (%s).".formatted(clazz2.getName(), clazz2.getName(), planningVariables));
        }
    }

    private static List<Member> extractPlanningVariables(Class<?> entityClass) {
        List<Member> membersList = ConfigUtils.getDeclaredMembers(entityClass);
        return membersList.stream().filter(member -> ConfigUtils.extractAnnotationClass(member, EntityDescriptor.VARIABLE_ANNOTATION_CLASSES) != null || ConfigUtils.extractAnnotationClass(member, ADDITIONAL_VARIABLE_ANNOTATION_CLASSES) != null).toList();
    }

    private static boolean hasAnyGenuineOrShadowVariables(Class<?> entityClass) {
        return !EntityDescriptorValidator.extractPlanningVariables(entityClass).isEmpty();
    }

    public static boolean isEntityClass(Class<?> clazz) {
        return clazz.getAnnotation(PlanningEntity.class) != null || clazz.getSuperclass() != null && clazz.getSuperclass().getAnnotation(PlanningEntity.class) != null || Arrays.stream(clazz.getInterfaces()).anyMatch(i -> i.getAnnotation(PlanningEntity.class) != null);
    }
}

