/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.lookup;

import ai.timefold.solver.core.api.domain.solution.ProblemFactCollectionProperty;
import ai.timefold.solver.core.impl.domain.lookup.LookUpStrategy;
import java.util.Map;

public final class EqualsLookUpStrategy
implements LookUpStrategy {
    @Override
    public void addWorkingObject(Map<Object, Object> idToWorkingObjectMap, Object workingObject) {
        Object oldAddedObject = idToWorkingObjectMap.put(workingObject, workingObject);
        if (oldAddedObject != null) {
            throw new IllegalStateException("The workingObjects (" + String.valueOf(oldAddedObject) + ", " + String.valueOf(workingObject) + ") are equal (as in Object.equals()). Working objects must be unique.");
        }
    }

    @Override
    public void removeWorkingObject(Map<Object, Object> idToWorkingObjectMap, Object workingObject) {
        Object removedObject = idToWorkingObjectMap.remove(workingObject);
        if (workingObject != removedObject) {
            throw new IllegalStateException("The workingObject (" + String.valueOf(workingObject) + ") differs from the removedObject (" + String.valueOf(removedObject) + ").");
        }
    }

    @Override
    public <E> E lookUpWorkingObject(Map<Object, Object> idToWorkingObjectMap, E externalObject) {
        Object workingObject = idToWorkingObjectMap.get(externalObject);
        if (workingObject == null) {
            throw new IllegalStateException("The externalObject (" + String.valueOf(externalObject) + ") has no known workingObject (" + String.valueOf(workingObject) + ").\nMaybe the workingObject was never added because the planning solution doesn't have a @" + ProblemFactCollectionProperty.class.getSimpleName() + " annotation on a member with instances of the externalObject's class (" + String.valueOf(externalObject.getClass()) + ").");
        }
        return (E)workingObject;
    }

    @Override
    public <E> E lookUpWorkingObjectIfExists(Map<Object, Object> idToWorkingObjectMap, E externalObject) {
        return (E)idToWorkingObjectMap.get(externalObject);
    }
}

