/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.policy;

import ai.timefold.solver.core.api.domain.common.DomainAccessType;
import ai.timefold.solver.core.api.domain.solution.PlanningScore;
import ai.timefold.solver.core.api.domain.solution.cloner.SolutionCloner;
import ai.timefold.solver.core.api.domain.valuerange.ValueRangeProvider;
import ai.timefold.solver.core.api.score.IBendableScore;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.buildin.bendable.BendableScore;
import ai.timefold.solver.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;
import ai.timefold.solver.core.api.score.buildin.bendablelong.BendableLongScore;
import ai.timefold.solver.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import ai.timefold.solver.core.api.score.buildin.hardmediumsoftbigdecimal.HardMediumSoftBigDecimalScore;
import ai.timefold.solver.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import ai.timefold.solver.core.api.score.buildin.hardsoft.HardSoftScore;
import ai.timefold.solver.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScore;
import ai.timefold.solver.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import ai.timefold.solver.core.api.score.buildin.simple.SimpleScore;
import ai.timefold.solver.core.api.score.buildin.simplebigdecimal.SimpleBigDecimalScore;
import ai.timefold.solver.core.api.score.buildin.simplelong.SimpleLongScore;
import ai.timefold.solver.core.config.solver.PreviewFeature;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessorFactory;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.score.descriptor.ScoreDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.CompositeValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.FromEntityPropertyValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.FromSolutionPropertyValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.score.buildin.BendableBigDecimalScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.BendableLongScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.BendableScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.HardMediumSoftBigDecimalScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.HardMediumSoftLongScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.HardMediumSoftScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.HardSoftBigDecimalScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.HardSoftLongScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.HardSoftScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.SimpleBigDecimalScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.SimpleLongScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.SimpleScoreDefinition;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class DescriptorPolicy {
    private Map<String, SolutionCloner> generatedSolutionClonerMap = new LinkedHashMap<String, SolutionCloner>();
    private final Map<String, MemberAccessor> fromSolutionValueRangeProviderMap = new LinkedHashMap<String, MemberAccessor>();
    private final Set<MemberAccessor> anonymousFromSolutionValueRangeProviderSet = new LinkedHashSet<MemberAccessor>();
    private final Map<String, MemberAccessor> fromEntityValueRangeProviderMap = new LinkedHashMap<String, MemberAccessor>();
    private final Set<MemberAccessor> anonymousFromEntityValueRangeProviderSet = new LinkedHashSet<MemberAccessor>();
    private DomainAccessType domainAccessType = DomainAccessType.REFLECTION;
    private Set<PreviewFeature> enabledPreviewFeatureSet = EnumSet.noneOf(PreviewFeature.class);
    private @Nullable MemberAccessorFactory memberAccessorFactory;
    private int entityDescriptorCount = 0;
    private int valueRangeDescriptorCount = 0;

    public <Solution_> EntityDescriptor<Solution_> buildEntityDescriptor(SolutionDescriptor<Solution_> solutionDescriptor, Class<?> entityClass) {
        EntityDescriptor<Solution_> entityDescriptor = new EntityDescriptor<Solution_>(this.entityDescriptorCount++, solutionDescriptor, entityClass);
        solutionDescriptor.addEntityDescriptor(entityDescriptor);
        return entityDescriptor;
    }

    public <Score_ extends Score<Score_>> ScoreDescriptor<Score_> buildScoreDescriptor(Member member, Class<?> solutionClass) {
        MemberAccessor scoreMemberAccessor = this.buildScoreMemberAccessor(member);
        Class<Score_> scoreType = DescriptorPolicy.extractScoreType(scoreMemberAccessor, solutionClass);
        PlanningScore annotation = DescriptorPolicy.extractPlanningScoreAnnotation(scoreMemberAccessor);
        Object scoreDefinition = DescriptorPolicy.buildScoreDefinition(solutionClass, scoreMemberAccessor, scoreType, annotation);
        return new ScoreDescriptor(scoreMemberAccessor, scoreDefinition);
    }

    public <Solution_> CompositeValueRangeDescriptor<Solution_> buildCompositeValueRangeDescriptor(GenuineVariableDescriptor<Solution_> variableDescriptor, List<ValueRangeDescriptor<Solution_>> childValueRangeDescriptorList) {
        return new CompositeValueRangeDescriptor<Solution_>(this.valueRangeDescriptorCount++, variableDescriptor, childValueRangeDescriptorList);
    }

    public <Solution_> FromSolutionPropertyValueRangeDescriptor<Solution_> buildFromSolutionPropertyValueRangeDescriptor(GenuineVariableDescriptor<Solution_> variableDescriptor, MemberAccessor valueRangeProviderMemberAccessor) {
        return new FromSolutionPropertyValueRangeDescriptor<Solution_>(this.valueRangeDescriptorCount++, variableDescriptor, valueRangeProviderMemberAccessor);
    }

    public <Solution_> FromEntityPropertyValueRangeDescriptor<Solution_> buildFromEntityPropertyValueRangeDescriptor(GenuineVariableDescriptor<Solution_> variableDescriptor, MemberAccessor valueRangeProviderMemberAccessor) {
        return new FromEntityPropertyValueRangeDescriptor<Solution_>(this.valueRangeDescriptorCount++, variableDescriptor, valueRangeProviderMemberAccessor);
    }

    private static <Score_ extends Score<Score_>> Class<Score_> extractScoreType(MemberAccessor scoreMemberAccessor, Class<?> solutionClass) {
        Class<?> memberType = scoreMemberAccessor.getType();
        if (!Score.class.isAssignableFrom(memberType)) {
            throw new IllegalStateException("The solutionClass (%s) has a @%s annotated member (%s) that does not return a subtype of Score.".formatted(solutionClass, PlanningScore.class.getSimpleName(), scoreMemberAccessor));
        }
        if (memberType == Score.class) {
            throw new IllegalStateException("The solutionClass (%s) has a @%s annotated member (%s) that doesn't return a non-abstract %s class.\nMaybe make it return %s or another specific %s implementation.".formatted(solutionClass, PlanningScore.class.getSimpleName(), scoreMemberAccessor, Score.class.getSimpleName(), HardSoftScore.class.getSimpleName(), Score.class.getSimpleName()));
        }
        return memberType;
    }

    private static PlanningScore extractPlanningScoreAnnotation(MemberAccessor scoreMemberAccessor) {
        PlanningScore annotation = scoreMemberAccessor.getAnnotation(PlanningScore.class);
        if (annotation != null) {
            return annotation;
        }
        try {
            return ScoreDescriptor.class.getDeclaredField("PLANNING_SCORE").getAnnotation(PlanningScore.class);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Impossible situation: the field (PLANNING_SCORE) must exist.", e);
        }
    }

    private static <Score_ extends Score<Score_>, ScoreDefinition_ extends ScoreDefinition<Score_>> ScoreDefinition_ buildScoreDefinition(Class<?> solutionClass, MemberAccessor scoreMemberAccessor, Class<Score_> scoreType, PlanningScore annotation) {
        Class<? extends ScoreDefinition> scoreDefinitionClass = annotation.scoreDefinitionClass();
        int bendableHardLevelsSize = annotation.bendableHardLevelsSize();
        int bendableSoftLevelsSize = annotation.bendableSoftLevelsSize();
        if (!Objects.equals(scoreDefinitionClass, PlanningScore.NullScoreDefinition.class)) {
            if (bendableHardLevelsSize != -1 || bendableSoftLevelsSize != -1) {
                throw new IllegalArgumentException("The solutionClass (%s) has a @%s annotated member (%s) that has a scoreDefinition (%s) that must not have a bendableHardLevelsSize (%d) or a bendableSoftLevelsSize (%d).".formatted(solutionClass, PlanningScore.class.getSimpleName(), scoreMemberAccessor, scoreDefinitionClass, bendableHardLevelsSize, bendableSoftLevelsSize));
            }
            return (ScoreDefinition_)ConfigUtils.newInstance(() -> String.valueOf(scoreMemberAccessor) + " with @" + PlanningScore.class.getSimpleName(), "scoreDefinitionClass", scoreDefinitionClass);
        }
        if (!IBendableScore.class.isAssignableFrom(scoreType)) {
            if (bendableHardLevelsSize != -1 || bendableSoftLevelsSize != -1) {
                throw new IllegalArgumentException("The solutionClass (%s) has a @%s annotated member (%s) that returns a scoreType (%s) that must not have a bendableHardLevelsSize (%d) or a bendableSoftLevelsSize (%d).".formatted(solutionClass, PlanningScore.class.getSimpleName(), scoreMemberAccessor, scoreType, bendableHardLevelsSize, bendableSoftLevelsSize));
            }
            if (scoreType.equals(SimpleScore.class)) {
                return (ScoreDefinition_)new SimpleScoreDefinition();
            }
            if (scoreType.equals(SimpleLongScore.class)) {
                return (ScoreDefinition_)new SimpleLongScoreDefinition();
            }
            if (scoreType.equals(SimpleBigDecimalScore.class)) {
                return (ScoreDefinition_)new SimpleBigDecimalScoreDefinition();
            }
            if (scoreType.equals(HardSoftScore.class)) {
                return (ScoreDefinition_)new HardSoftScoreDefinition();
            }
            if (scoreType.equals(HardSoftLongScore.class)) {
                return (ScoreDefinition_)new HardSoftLongScoreDefinition();
            }
            if (scoreType.equals(HardSoftBigDecimalScore.class)) {
                return (ScoreDefinition_)new HardSoftBigDecimalScoreDefinition();
            }
            if (scoreType.equals(HardMediumSoftScore.class)) {
                return (ScoreDefinition_)new HardMediumSoftScoreDefinition();
            }
            if (scoreType.equals(HardMediumSoftLongScore.class)) {
                return (ScoreDefinition_)new HardMediumSoftLongScoreDefinition();
            }
            if (scoreType.equals(HardMediumSoftBigDecimalScore.class)) {
                return (ScoreDefinition_)new HardMediumSoftBigDecimalScoreDefinition();
            }
            throw new IllegalArgumentException("The solutionClass (%s) has a @%s annotated member (%s) that returns a scoreType (%s) that is not recognized as a default %s implementation.\n  If you intend to use a custom implementation, maybe set a scoreDefinition in the @%s annotation.".formatted(solutionClass, PlanningScore.class.getSimpleName(), scoreMemberAccessor, scoreType, Score.class.getSimpleName(), PlanningScore.class.getSimpleName()));
        }
        if (bendableHardLevelsSize == -1 || bendableSoftLevelsSize == -1) {
            throw new IllegalArgumentException("The solutionClass (%s) has a @%s annotated member (%s) that returns a scoreType (%s) that must have a bendableHardLevelsSize (%d) and a bendableSoftLevelsSize (%d).".formatted(solutionClass, PlanningScore.class.getSimpleName(), scoreMemberAccessor, scoreType, bendableHardLevelsSize, bendableSoftLevelsSize));
        }
        if (scoreType.equals(BendableScore.class)) {
            return (ScoreDefinition_)new BendableScoreDefinition(bendableHardLevelsSize, bendableSoftLevelsSize);
        }
        if (scoreType.equals(BendableLongScore.class)) {
            return (ScoreDefinition_)new BendableLongScoreDefinition(bendableHardLevelsSize, bendableSoftLevelsSize);
        }
        if (scoreType.equals(BendableBigDecimalScore.class)) {
            return (ScoreDefinition_)new BendableBigDecimalScoreDefinition(bendableHardLevelsSize, bendableSoftLevelsSize);
        }
        throw new IllegalArgumentException("The solutionClass (%s) has a @%s annotated member (%s) that returns a bendable scoreType (%s) that is not recognized as a default %s implementation.\n  If you intend to use a custom implementation, maybe set a scoreDefinition in the annotation.".formatted(solutionClass, PlanningScore.class.getSimpleName(), scoreMemberAccessor, scoreType, Score.class.getSimpleName()));
    }

    public MemberAccessor buildScoreMemberAccessor(Member member) {
        return this.getMemberAccessorFactory().buildAndCacheMemberAccessor(member, MemberAccessorFactory.MemberAccessorType.FIELD_OR_GETTER_METHOD_WITH_SETTER, PlanningScore.class, this.getDomainAccessType());
    }

    public void addFromSolutionValueRangeProvider(MemberAccessor memberAccessor) {
        String id = this.extractValueRangeProviderId(memberAccessor);
        if (id == null) {
            this.anonymousFromSolutionValueRangeProviderSet.add(memberAccessor);
        } else {
            this.fromSolutionValueRangeProviderMap.put(id, memberAccessor);
        }
    }

    public boolean isFromSolutionValueRangeProvider(MemberAccessor memberAccessor) {
        return this.fromSolutionValueRangeProviderMap.containsValue(memberAccessor) || this.anonymousFromSolutionValueRangeProviderSet.contains(memberAccessor);
    }

    public boolean hasFromSolutionValueRangeProvider(String id) {
        return this.fromSolutionValueRangeProviderMap.containsKey(id);
    }

    public MemberAccessor getFromSolutionValueRangeProvider(String id) {
        return this.fromSolutionValueRangeProviderMap.get(id);
    }

    public Set<MemberAccessor> getAnonymousFromSolutionValueRangeProviderSet() {
        return this.anonymousFromSolutionValueRangeProviderSet;
    }

    public void addFromEntityValueRangeProvider(MemberAccessor memberAccessor) {
        String id = this.extractValueRangeProviderId(memberAccessor);
        if (id == null) {
            this.anonymousFromEntityValueRangeProviderSet.add(memberAccessor);
        } else {
            this.fromEntityValueRangeProviderMap.put(id, memberAccessor);
        }
    }

    public boolean isFromEntityValueRangeProvider(MemberAccessor memberAccessor) {
        return this.fromEntityValueRangeProviderMap.containsValue(memberAccessor) || this.anonymousFromEntityValueRangeProviderSet.contains(memberAccessor);
    }

    public boolean hasFromEntityValueRangeProvider(String id) {
        return this.fromEntityValueRangeProviderMap.containsKey(id);
    }

    public Set<MemberAccessor> getAnonymousFromEntityValueRangeProviderSet() {
        return this.anonymousFromEntityValueRangeProviderSet;
    }

    public DomainAccessType getDomainAccessType() {
        return this.domainAccessType;
    }

    public void setDomainAccessType(DomainAccessType domainAccessType) {
        this.domainAccessType = domainAccessType;
    }

    public Set<PreviewFeature> getEnabledPreviewFeatureSet() {
        return this.enabledPreviewFeatureSet;
    }

    public void setEnabledPreviewFeatureSet(Set<PreviewFeature> enabledPreviewFeatureSet) {
        this.enabledPreviewFeatureSet = enabledPreviewFeatureSet;
    }

    public Map<String, SolutionCloner> getGeneratedSolutionClonerMap() {
        return this.generatedSolutionClonerMap;
    }

    public void setGeneratedSolutionClonerMap(Map<String, SolutionCloner> generatedSolutionClonerMap) {
        this.generatedSolutionClonerMap = generatedSolutionClonerMap;
    }

    public MemberAccessorFactory getMemberAccessorFactory() {
        return this.memberAccessorFactory;
    }

    public void setMemberAccessorFactory(MemberAccessorFactory memberAccessorFactory) {
        this.memberAccessorFactory = memberAccessorFactory;
    }

    public MemberAccessor getFromEntityValueRangeProvider(String id) {
        return this.fromEntityValueRangeProviderMap.get(id);
    }

    public boolean isPreviewFeatureEnabled(PreviewFeature previewFeature) {
        return this.enabledPreviewFeatureSet.contains((Object)previewFeature);
    }

    private @Nullable String extractValueRangeProviderId(MemberAccessor memberAccessor) {
        ValueRangeProvider annotation = memberAccessor.getAnnotation(ValueRangeProvider.class);
        String id = annotation.id();
        if (id == null || id.isEmpty()) {
            return null;
        }
        this.validateUniqueValueRangeProviderId(id, memberAccessor);
        return id;
    }

    private void validateUniqueValueRangeProviderId(String id, MemberAccessor memberAccessor) {
        MemberAccessor duplicate = this.fromSolutionValueRangeProviderMap.get(id);
        if (duplicate != null) {
            throw new IllegalStateException("2 members (%s, %s) with a @%s annotation must not have the same id (%s).".formatted(duplicate, memberAccessor, ValueRangeProvider.class.getSimpleName(), id));
        }
        duplicate = this.fromEntityValueRangeProviderMap.get(id);
        if (duplicate != null) {
            throw new IllegalStateException("2 members (%s, %s) with a @%s annotation must not have the same id (%s).".formatted(duplicate, memberAccessor, ValueRangeProvider.class.getSimpleName(), id));
        }
    }

    public Collection<String> getValueRangeProviderIds() {
        ArrayList<String> valueRangeProviderIds = new ArrayList<String>(this.fromSolutionValueRangeProviderMap.size() + this.fromEntityValueRangeProviderMap.size());
        valueRangeProviderIds.addAll(this.fromSolutionValueRangeProviderMap.keySet());
        valueRangeProviderIds.addAll(this.fromEntityValueRangeProviderMap.keySet());
        return valueRangeProviderIds;
    }
}

